/**
 * NumberFieldBean.java  1.00 97/08/09 Merlin Hughes
 *
 * Copyright (c) 1997 Merlin Hughes, All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for commercial and non-commercial purposes and without fee is
 * hereby granted provided that this copyright notice appears in
 * all copies.
 *
 * http://prominence.com/                         ego@merlin.org
 */

package org.merlin.beans.numberfield;

import java.awt.*;
import java.beans.*;
import java.awt.event.*;

import org.merlin.beans.arrow.*;

public class NumberFieldBean extends Container implements ActionListener {
  protected ArrowBean up, down;
  protected TextField field;
  
  public NumberFieldBean () {
    setLayout (new BorderLayout ());
    try {
      down = (ArrowBean) Beans.instantiate (getClass ().getClassLoader (), "org.merlin.beans.arrow.ArrowBean");
      up = (ArrowBean) Beans.instantiate (getClass ().getClassLoader (), "org.merlin.beans.arrow.ArrowBean");
    } catch (Exception ex) {
      ex.printStackTrace ();
    }
    add ("West", (Component) Beans.getInstanceOf (down, Component.class));
    down.setDirection (ArrowBean.LEFT);
    down.addActionListener (this);
    add ("Center", field = new TextField (4));
    field.addActionListener (this);
    add ("East", (Component) Beans.getInstanceOf (up, Component.class));
    up.setDirection (ArrowBean.RIGHT);
    up.addActionListener (this);
  }

  public void requestFocus () {
    field.requestFocus ();
  }

  public void setColumns (int c) {
    field.setColumns (c);
  }

  public int getColumns () {
    return field.getColumns ();
  }

  public synchronized void setValue (int v) {
    field.setText (String.valueOf (v));
    fireValueChange (getValue ());
  }

  public int getValue () {
    try {
      return clamp (Integer.parseInt (field.getText ()));
    } catch (NumberFormatException ex) {
      return clamp (0);
    }
  }

  protected int minimum = Integer.MIN_VALUE;
  
  public synchronized void setMinimum (int m) {
    minimum = m;
  }

  public int getMinimum () {
    return minimum;
  }

  protected int maximum = Integer.MAX_VALUE;
  
  public synchronized void setMaximum (int m) {
    maximum = m;
  }

  public int getMaximum () {
    return maximum;
  }

  protected int clamp (int v) {
    return Math.max (minimum, Math.min (maximum, v));
  }

  protected int step = 1;
  
  public synchronized void setStep (int s) {
    if (s <= 0)
      throw new IllegalArgumentException ("Step too small (" + s + ").");
    step = s;
  }

  public int getStep () {
    return step;
  }

  public synchronized void actionPerformed (ActionEvent e) {
    int value = getValue ();
    if (e.getSource () == down) {
      if (value > minimum) {
        value = (value - step > value) ? minimum : clamp (value - step);
        setValue (value);
        fireValueChange (value);
      }
    } else if (e.getSource () == up) {
      if (value < maximum) {
        value = (value + step < value) ? maximum : clamp (value + step);
        setValue (value);
        fireValueChange (value);
      }
    } else if (e.getSource () == field) {
      try {
        int v = Integer.parseInt (e.getActionCommand ());
        if ((v < minimum) || (v > maximum))
          getToolkit ().beep ();
        else
          fireValueChange (v);
      } catch (NumberFormatException ex) {
        getToolkit ().beep ();
      }
    }
  }

  protected PropertyChangeSupport listeners =
    new PropertyChangeSupport (this);

  public void addPropertyChangeListener (PropertyChangeListener l) {
    listeners.addPropertyChangeListener (l);
  }

  public void removePropertyChangeListener (PropertyChangeListener l) {
    listeners.removePropertyChangeListener (l);
  }

  Integer oValue = new Integer (0);

  protected void fireValueChange (int v) {
    listeners.firePropertyChange ("value", oValue, oValue = new Integer (v));
  }
}
