/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.argouml.model.Model;
import org.argouml.model.UmlChangeEvent;
import org.argouml.notation.Notation;
import org.argouml.notation.NotationProvider;
import org.argouml.notation.NotationProviderFactory2;
import org.argouml.notation.NotationSettings;
import org.argouml.notation.SDNotationSettings;
import org.argouml.sequence2.diagram.ActionSetOperation;
import org.argouml.sequence2.diagram.FigClassifierRole;
import org.argouml.sequence2.diagram.FigMessageSpline;
import org.argouml.sequence2.diagram.SelectionMessage;
import org.argouml.ui.ArgoJMenu;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.ui.FigEdgeModelElement;
import org.argouml.uml.diagram.ui.FigTextGroup;
import org.argouml.uml.diagram.ui.PathItemPlacement;
import org.tigris.gef.base.PathConv;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.ArrowHead;
import org.tigris.gef.presentation.ArrowHeadGreater;
import org.tigris.gef.presentation.ArrowHeadTriangle;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigMessage
extends FigEdgeModelElement {
    private static final long serialVersionUID = -2961220746360335159L;
    private static final Logger LOG = Logger.getLogger(FigEdgeModelElement.class.getName());
    private FigTextGroup textGroup;
    private Object action = null;
    private SDNotationSettings notationSettings;
    private boolean[] t = new boolean[]{false, false, false, false, false, false, false, false};

    public FigMessage(Object edge, DiagramSettings settings) {
        super(edge, settings);
        this.textGroup = new FigTextGroup(edge, settings);
        this.initialize();
        this.action = Model.getFacade().getAction(this.getOwner());
        this.updateArrow();
        if (this.action != null) {
            this.addElementListener(this.action, "isAsynchronous");
        }
        this.t[1] = Model.getFacade().isASynchCallMessage(this.getOwner());
        this.t[2] = Model.getFacade().isAASynchCallMessage(this.getOwner());
        this.t[3] = Model.getFacade().isACreateMessage(this.getOwner());
        this.t[4] = Model.getFacade().isADeleteMessage(this.getOwner());
        this.t[5] = Model.getFacade().isAReplyMessage(this.getOwner());
        this.t[6] = Model.getFacade().isAASynchSignalMessage(this.getOwner());
    }

    private void initialize() {
        this.textGroup.addFig((Fig)this.getNameFig());
        this.textGroup.addFig((Fig)this.getStereotypeFig());
        this.addPathItem((Fig)this.textGroup, (PathConv)new PathItemPlacement((FigEdge)this, (Fig)this.textGroup, 50, 10));
        this.notationSettings = new SDNotationSettings();
    }

    protected int getNotationProviderType() {
        return 21;
    }

    protected void initNotationProviders(Object own) {
        super.initNotationProviders(own);
        this.notationSettings.setShowSequenceNumbers(false);
    }

    protected void textEditStarted(FigText ft) {
        this.notationSettings.setShowSequenceNumbers(true);
        super.textEditStarted(ft);
        this.notationSettings.setShowSequenceNumbers(false);
    }

    protected SDNotationSettings getNotationSettings() {
        return this.notationSettings;
    }

    boolean isSynchCallMessage() {
        return this.t[1];
    }

    boolean isASynchCallMessage() {
        return this.t[2];
    }

    boolean isCreateMessage() {
        return this.t[3];
    }

    boolean isDeleteMessage() {
        return this.t[4];
    }

    boolean isReplyMessage() {
        return this.t[5];
    }

    boolean isASynchSignalMessage() {
        return this.t[6];
    }

    private void updateArrow() {
        ArrowHeadTriangle arrowHead;
        if (this.getOwner() == null) {
            return;
        }
        this.getFig().setDashed(this.isReplyMessage());
        Object act = this.getAction();
        if (act != null && Model.getFacade().isAsynchronous(this.getAction())) {
            arrowHead = new ArrowHeadGreater();
        } else {
            arrowHead = new ArrowHeadTriangle();
            this.getFig().setFillColor(this.getLineColor());
        }
        this.setDestArrowHead((ArrowHead)arrowHead);
    }

    private Object getAction() {
        return this.action;
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        if (Model.getFacade().isACallAction(this.getAction())) {
            ArgoJMenu opMenu = this.buildOperationMenu();
            int index = popUpActions.size() - FigMessage.getPopupAddOffset() - 1;
            if (index < 0) {
                index = 0;
            }
            popUpActions.add(index, new JSeparator());
            popUpActions.add(index, opMenu);
        }
        return popUpActions;
    }

    protected ArgoJMenu buildOperationMenu() {
        ArgoJMenu opMenu = new ArgoJMenu("Operation");
        Iterator<Object> iter = this.getReceiverOperations().iterator();
        opMenu.setEnabled(iter.hasNext());
        while (iter.hasNext()) {
            Object op = iter.next();
            NotationProvider np = null;
            try {
                String s = this.getNotationSettings().getNotationLanguage();
                np = NotationProviderFactory2.getInstance().getNotationProvider(6, op, Notation.findNotation((String)s));
            }
            catch (Exception e) {
                np = null;
            }
            String label = np != null ? np.toString(op, (NotationSettings)this.getNotationSettings()) : Model.getFacade().getName(op);
            opMenu.add((Action)((Object)new ActionSetOperation(this.getAction(), op, label)));
        }
        return opMenu;
    }

    public Selection makeSelection() {
        return new SelectionMessage(this);
    }

    public void setFig(Fig f) {
        super.setFig(f);
        this.updateArrow();
    }

    int getFinalY() {
        int finalY = 0;
        Point[] points = this.getFig().getPoints();
        if (points.length > 0) {
            finalY = points[points.length - 1].y;
        }
        return finalY;
    }

    int getStartY() {
        int finalY = 0;
        Point[] points = this.getFig().getPoints();
        if (points.length > 0) {
            finalY = points[0].y;
        }
        return finalY;
    }

    boolean isSelfMessage() {
        if (this.getDestPortFig() == null || this.getSourcePortFig() == null) {
            return this.getDestination().equals(this.getSource());
        }
        return this.getDestPortFig().equals(this.getSourcePortFig());
    }

    public void convertToArc() {
        if (this.getPoints().length > 0) {
            FigMessageSpline spline = new FigMessageSpline(this.getPoint(0));
            spline.setDashed(this.isReplyMessage());
            super.setFig((Fig)spline);
            this.computeRoute();
        }
    }

    public void computeRouteImpl() {
        super.computeRouteImpl();
        this.updateActivations();
    }

    public void calcBounds() {
        FigPoly fp = (FigPoly)this.getFig();
        FigNode node = this.getSourceFigNode();
        if (node != null && this.isSelfMessage() && fp.isComplete()) {
            int x = node.getX() + (node.getWidth() + 20) / 2;
            Point startPoint = new Point(x, this.getYs()[0]);
            FigMessageSpline spline = new FigMessageSpline(startPoint);
            spline.setComplete(true);
            spline.setDashed(this.isReplyMessage());
            super.setFig((Fig)spline);
        }
        super.calcBounds();
    }

    private synchronized void updateActivations() {
        FigClassifierRole dest;
        FigClassifierRole source = (FigClassifierRole)this.getSourceFigNode();
        if (source != null) {
            source.createActivations();
        }
        if (!this.isSelfMessage() && (dest = (FigClassifierRole)this.getDestFigNode()) != null) {
            dest.createActivations();
        }
    }

    public void setLineColor(Color c) {
        super.setLineColor(c);
        this.getDestArrowHead().setFillColor(c);
    }

    public void deleteFromModel() {
        ((FigClassifierRole)this.getSourceFigNode()).createActivations();
        if (!this.isSelfMessage()) {
            ((FigClassifierRole)this.getDestFigNode()).createActivations();
        }
        super.deleteFromModel();
    }

    protected boolean determineFigNodes() {
        return true;
    }

    public void translate(int dx, int dy) {
        if (this.isSelfMessage()) {
            ((FigMessageSpline)this.getFig()).translateFig(dx, dy);
        }
        super.translate(dx, dy);
    }

    public void updateLayout(UmlChangeEvent event) {
        if ("isAsynchronous".equals(event.getPropertyName())) {
            this.updateArrow();
        }
        super.updateLayout(event);
    }

    protected void updateListeners(Object oldOwner, Object newOwner) {
        this.action = Model.getFacade().getAction(newOwner);
        HashSet<Object[]> listeners = new HashSet<Object[]>();
        Object action = this.getAction();
        listeners.add(new Object[]{this.getOwner(), "remove"});
        if (action != null) {
            listeners.add(new Object[]{action, "isAsynchronous"});
        }
        try {
            this.updateElementListeners(listeners);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception caught", e);
        }
    }

    private Collection<Object> getReceiverOperations() {
        ArrayList<Object> opList = new ArrayList<Object>();
        Object action = this.getAction();
        Object receiver = Model.getFacade().getReceiver(this.getOwner());
        if (action != null && receiver != null && Model.getFacade().isACallAction(action)) {
            for (Object base : Model.getFacade().getBases(receiver)) {
                opList.addAll(Model.getFacade().getOperations(base));
            }
        }
        return opList;
    }

    public Object determineActivator() {
        FigClassifierRole fcr = (FigClassifierRole)this.getSourceFigNode();
        List<FigMessage> messageFigs = fcr.getFigMessages();
        Iterator<FigMessage> it = messageFigs.iterator();
        Object activator = null;
        while (it.hasNext()) {
            FigMessage messageFig = it.next();
            if ((messageFig.isCreateMessage() || messageFig.isSynchCallMessage()) && messageFig.getDestFigNode() == fcr) {
                activator = messageFig.getOwner();
                continue;
            }
            if (messageFig == this) {
                Model.getCollaborationsHelper().setActivator(this.getOwner(), activator);
                return activator;
            }
            if (!messageFig.isReplyMessage()) continue;
            activator = null;
        }
        return null;
    }
}

