/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDatabase;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeFactory;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;

public class VirtualList
extends AbstractList {
    private ArrayList keys = new ArrayList();
    private BtreeDatabase store;
    private String name;
    private BtreeStorage storage;

    public VirtualList(String fileName, ObjectResolver resolver) {
        this(VirtualList.defaultMap(fileName), resolver);
    }

    public VirtualList(Map properties, ObjectResolver resolver) {
        try {
            this.storage = (BtreeStorage)new BtreeFactory().createStorage(properties);
            this.storage.create(true, resolver);
            this.store = (BtreeDatabase)this.storage.getPrimaryIndex();
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public void delete() {
        try {
            this.store.close();
            BtreeDatabase.delete(this.name);
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public synchronized Object get(int index) {
        try {
            MOFID key = (MOFID)this.keys.get(index);
            return this.store.get(key);
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public int size() {
        return this.keys.size();
    }

    public synchronized Object set(int index, Object element) {
        try {
            MOFID key = (MOFID)this.keys.get(index);
            Object retval = this.store.getIfExists(key);
            this.store.put(key, element);
            return retval;
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public synchronized void add(int index, Object element) {
        try {
            MOFID key = new MOFID(this.storage);
            this.keys.add(index, key);
            this.store.add(key, element);
        }
        catch (StorageException ex) {
            this.keys.remove(index);
            throw new RuntimeStorageException(ex);
        }
    }

    public synchronized Object remove(int index) {
        try {
            MOFID key = (MOFID)this.keys.get(index);
            Object o = this.store.get(key);
            this.store.remove(key);
            this.keys.remove(index);
            return o;
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public synchronized void changed(int index) {
        try {
            this.store.objectStateChanged((MOFID)this.keys.get(index));
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    private static Map defaultMap(String fileName) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("org.netbeans.mdr.persistence.btreeimpl.filename", fileName);
        return map;
    }
}

