/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.uml.reveng.idl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.uml.reveng.ImportCommon;
import org.argouml.uml.reveng.idl.ClassifierNotFoundException;
import org.argouml.uml.reveng.idl.Context;
import org.argouml.uml.reveng.idl.PackageContext;
import org.argouml.uml.reveng.idl.ParameterDeclaration;
import org.argouml.uml.reveng.idl.ParseState;
import org.argouml.uml.reveng.idl.ParseStateException;

class Modeler {
    private static final Logger LOG = Logger.getLogger(Modeler.class.getName());
    private static final String DEFAULT_PACKAGE = "default";
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private Object model;
    private ImportCommon importSession;
    private Object currentPackage;
    private ParseState parseState;
    private Stack<ParseState> parseStateStack;
    private boolean noAssociations = false;
    private boolean arraysAsDatatype = false;
    private String fileName;
    private Hashtable<String, Object> attributes = new Hashtable();
    private List<String> methodCalls = new ArrayList<String>();
    private Hashtable<String, String> localVariables = new Hashtable();
    private Collection<Object> newElements;
    private boolean generateNames = true;
    private static final String IMPORT_STEREOTYPE = "idlImport";

    Modeler(Object theModel, String theFileName) {
        this.model = theModel;
        this.noAssociations = false;
        this.arraysAsDatatype = false;
        this.currentPackage = this.model;
        this.newElements = new HashSet<Object>();
        this.parseState = new ParseState(this.model, this.getPackage(DEFAULT_PACKAGE));
        this.parseStateStack = new Stack();
        this.fileName = theFileName;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void addComponent() {
        Object component = Model.getFacade().lookupIn(this.currentPackage, this.fileName);
        if (component == null) {
            component = Model.getCoreFactory().createComponent();
            Model.getCoreHelper().setName(component, this.fileName);
            this.newElements.add(component);
        }
        this.parseState.addComponent(component);
        Model.getCoreHelper().setNamespace(this.parseState.getComponent(), this.model);
    }

    public void addPackage(String name) {
        String currentName = name;
        String ownerPackageName = this.getPackageName(currentName);
        while (!"".equals(ownerPackageName)) {
            currentName = ownerPackageName;
            ownerPackageName = this.getPackageName(currentName);
        }
        Object mPackage = this.getPackage(currentName);
        if (this.importSession != null && this.importSession.getSrcPath() != null && Model.getFacade().getTaggedValue(mPackage, "src_path") == null) {
            Model.getCoreHelper().setTaggedValue(mPackage, "src_path", this.importSession.getSrcPath());
        }
        this.currentPackage = mPackage = this.getPackage(name);
        this.parseState.addPackageContext(mPackage);
        Object component = Model.getFacade().lookupIn(this.currentPackage, this.fileName);
        if (component == null) {
            Model.getCoreHelper().setNamespace(this.parseState.getComponent(), this.currentPackage);
        } else {
            Object oldComponent = this.parseState.getComponent();
            Model.getUmlFactory().delete(oldComponent);
            this.newElements.remove(oldComponent);
            this.parseState.addComponent(component);
        }
    }

    public void addImport(String name) {
        this.addImport(name, false);
    }

    void addImport(String name, boolean forceIt) {
        if (this.getLevel() == 0) {
            return;
        }
        String packageName = this.getPackageName(name);
        String classifierName = this.getClassifierName(name);
        Object mPackage = this.getPackage(packageName);
        if (classifierName.equals("*")) {
            this.parseState.addPackageContext(mPackage);
            Object srcFile = this.parseState.getComponent();
            this.buildImport(mPackage, srcFile);
        } else {
            Object mClassifier = null;
            try {
                mClassifier = new PackageContext(null, mPackage).get(classifierName);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && classifierName != null && mPackage != null) {
                    LOG.log(Level.INFO, "Modeler.java: forced creation of unknown classifier " + classifierName);
                    mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                    this.newElements.add(mClassifier);
                }
                this.warnClassifierNotFound(classifierName, "an imported classifier");
            }
            if (mClassifier != null) {
                this.parseState.addClassifierContext(mClassifier);
                Object srcFile = this.parseState.getComponent();
                this.buildImport(mClassifier, srcFile);
            }
        }
    }

    private Object buildImport(Object element, Object srcFile) {
        Collection dependencies = Model.getCoreHelper().getDependencies(element, srcFile);
        for (Object dep : dependencies) {
            if (!Model.getExtensionMechanismsHelper().hasStereotype(dep, IMPORT_STEREOTYPE)) continue;
            return dep;
        }
        Object pkgImport = Model.getCoreFactory().buildDependency(srcFile, element);
        Model.getCoreHelper().addStereotype(pkgImport, this.getStereotype(IMPORT_STEREOTYPE));
        String newName = this.makeFromToName(srcFile, element);
        Model.getCoreHelper().setName(pkgImport, newName);
        this.newElements.add(pkgImport);
        return pkgImport;
    }

    private String makeAbstractionName(Object child, Object parent) {
        return this.makeFromToName(child, parent);
    }

    private String makeAssociationName(Object from, Object to) {
        return this.makeFromToName(from, to);
    }

    private String makeFromToName(Object from, Object to) {
        if (!this.generateNames) {
            return null;
        }
        return this.makeFromToName(Model.getFacade().getName(from), Model.getFacade().getName(to));
    }

    private String makeFromToName(String from, String to) {
        if (!this.generateNames) {
            return null;
        }
        return from + " -> " + to;
    }

    public void addClass(String name, short modifiers, String superclassName, List<String> interfaces, String javadoc) {
        this.addClass(name, modifiers, EMPTY_STRING_LIST, superclassName, interfaces, javadoc, false);
    }

    void addClass(String name, short modifiers, List<String> typeParameters, String superclassName, List<String> interfaces, String javadoc, boolean forceIt) {
        if (typeParameters != null && typeParameters.size() > 0) {
            this.logError("type parameters not supported on Class", name);
        }
        Object mClass = this.addClassifier(Model.getCoreFactory().createClass(), name, modifiers, javadoc, typeParameters);
        Model.getCoreHelper().setRoot(mClass, false);
        this.newElements.add(mClass);
        if (this.getLevel() == 0) {
            return;
        }
        if (superclassName != null) {
            Object parentClass = null;
            try {
                parentClass = this.getContext(superclassName).get(this.getClassifierName(superclassName));
                this.getGeneralization(this.currentPackage, parentClass, mClass);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && superclassName != null && this.model != null) {
                    LOG.log(Level.INFO, "Modeler.java: forced creation of unknown class " + superclassName);
                    String packageName = this.getPackageName(superclassName);
                    String classifierName = this.getClassifierName(superclassName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName) : this.model;
                    parentClass = Model.getCoreFactory().buildClass(classifierName, mPackage);
                    this.newElements.add(parentClass);
                    this.getGeneralization(this.currentPackage, parentClass, mClass);
                }
                this.warnClassifierNotFound(superclassName, "a generalization");
            }
        }
        if (interfaces != null) {
            this.addInterfaces(mClass, interfaces, forceIt);
        }
    }

    public void addAnonymousClass(String type) {
        this.addAnonymousClass(type, false);
    }

    void addAnonymousClass(String type, boolean forceIt) {
        String name = this.parseState.anonymousClass();
        try {
            Object mClassifier = this.getContext(type).get(this.getClassifierName(type));
            ArrayList<String> interfaces = new ArrayList<String>();
            if (Model.getFacade().isAInterface(mClassifier)) {
                interfaces.add(type);
            }
            this.addClass(name, (short)0, EMPTY_STRING_LIST, Model.getFacade().isAClass(mClassifier) ? type : null, interfaces, "", forceIt);
        }
        catch (ClassifierNotFoundException e) {
            this.addClass(name, (short)0, EMPTY_STRING_LIST, null, EMPTY_STRING_LIST, "", forceIt);
            LOG.log(Level.INFO, "Modeler.java: an anonymous class was created although it could not be found in the classpath.");
        }
    }

    public void addInterface(String name, short modifiers, List<String> interfaces, String javadoc) {
        this.addInterface(name, modifiers, EMPTY_STRING_LIST, interfaces, javadoc, false);
    }

    void addInterface(String name, short modifiers, List<String> typeParameters, List<String> interfaces, String javadoc, boolean forceIt) {
        if (typeParameters != null && typeParameters.size() > 0) {
            this.logError("type parameters not supported on Interface", name);
        }
        Object mInterface = this.addClassifier(Model.getCoreFactory().createInterface(), name, modifiers, javadoc, typeParameters);
        if (this.getLevel() == 0) {
            return;
        }
        for (String interfaceName : interfaces) {
            Object parentInterface = null;
            try {
                parentInterface = this.getContext(interfaceName).getInterface(this.getClassifierName(interfaceName));
                this.getGeneralization(this.currentPackage, parentInterface, mInterface);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && interfaceName != null && this.model != null) {
                    LOG.log(Level.INFO, "Modeler.java: forced creation of unknown interface " + interfaceName);
                    String packageName = this.getPackageName(interfaceName);
                    String classifierName = this.getClassifierName(interfaceName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName) : this.model;
                    parentInterface = Model.getCoreFactory().buildInterface(classifierName, mPackage);
                    this.newElements.add(parentInterface);
                    this.getGeneralization(this.currentPackage, parentInterface, mInterface);
                    continue;
                }
                this.warnClassifierNotFound(interfaceName, "a generalization");
            }
        }
    }

    void addEnumeration(String name, short modifiers, List<String> interfaces, String javadoc, boolean forceIt) {
        Object mClass = this.addClassifier(Model.getCoreFactory().createClass(), name, modifiers, javadoc, EMPTY_STRING_LIST);
        Model.getCoreHelper().addStereotype(mClass, this.getStereotype("enumeration"));
        Model.getCoreHelper().setLeaf(mClass, true);
        Model.getCoreHelper().setRoot(mClass, false);
        if (this.getLevel() == 0) {
            return;
        }
        if (interfaces != null) {
            this.addInterfaces(mClass, interfaces, forceIt);
        }
    }

    private void addInterfaces(Object mClass, List<String> interfaces, boolean forceIt) {
        for (String interfaceName : interfaces) {
            Object mInterface = null;
            try {
                mInterface = this.getContext(interfaceName).getInterface(this.getClassifierName(interfaceName));
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && interfaceName != null && this.model != null) {
                    LOG.log(Level.INFO, "Modeler: forced creation of unknown interface " + interfaceName);
                    String packageName = this.getPackageName(interfaceName);
                    String classifierName = this.getClassifierName(interfaceName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName) : this.model;
                    mInterface = Model.getCoreFactory().buildInterface(classifierName, mPackage);
                    this.newElements.add(mInterface);
                }
                this.warnClassifierNotFound(interfaceName, "an abstraction");
            }
            if (mInterface == null) continue;
            Object mAbstraction = this.getAbstraction(mInterface, mClass);
            if (Model.getFacade().getSuppliers(mAbstraction).size() == 0) {
                Model.getCoreHelper().addSupplier(mAbstraction, mInterface);
                Model.getCoreHelper().addClient(mAbstraction, mClass);
            }
            Model.getCoreHelper().setNamespace(mAbstraction, this.currentPackage);
            Model.getCoreHelper().addStereotype(mAbstraction, this.getStereotype("realize"));
            this.newElements.add(mAbstraction);
        }
    }

    void addEnumerationLiteral(String name) {
        Object enumeration = this.parseState.getClassifier();
        if (!this.isAEnumeration(enumeration)) {
            throw new ParseStateException("not an Enumeration");
        }
        short mod = 1;
        this.addAttribute(mod, null, name, null, null, true);
    }

    private boolean isAEnumeration(Object element) {
        if (!Model.getFacade().isAClass(element)) {
            return false;
        }
        return Model.getExtensionMechanismsHelper().hasStereotype(element, "enumeration");
    }

    private Object addClassifier(Object newClassifier, String name, short modifiers, String javadoc, List<String> typeParameters) {
        Object mNamespace;
        Object mClassifier;
        if (this.parseState.getClassifier() != null) {
            mClassifier = Model.getFacade().lookupIn(this.parseState.getClassifier(), name);
            mNamespace = this.parseState.getClassifier();
        } else {
            this.parseState.outerClassifier();
            mClassifier = Model.getFacade().lookupIn(this.currentPackage, name);
            mNamespace = this.currentPackage;
        }
        if (mClassifier == null) {
            LOG.log(Level.INFO, "Created new classifier for {0}", name);
            mClassifier = newClassifier;
            Model.getCoreHelper().setName(mClassifier, name);
            Model.getCoreHelper().setNamespace(mClassifier, mNamespace);
            this.newElements.add(mClassifier);
        } else {
            LOG.log(Level.INFO, "Found existing classifier for {0}", name);
            this.cleanModelElement(mClassifier);
        }
        this.parseState.innerClassifier(mClassifier);
        if (this.parseState.getClassifier() == null && Model.getFacade().getElementResidences(mClassifier).isEmpty()) {
            Object resident = Model.getCoreFactory().createElementResidence();
            Model.getCoreHelper().setResident(resident, mClassifier);
            Model.getCoreHelper().setContainer(resident, this.parseState.getComponent());
        }
        this.parseStateStack.push(this.parseState);
        this.parseState = new ParseState(this.parseState, mClassifier, this.currentPackage);
        this.setVisibility(mClassifier, modifiers);
        if (this.getLevel() <= 0) {
            this.addDocumentationTag(mClassifier, javadoc);
        }
        return mClassifier;
    }

    private int getLevel() {
        Object level = this.getAttribute("level");
        if (level != null) {
            return (Integer)level;
        }
        return -1;
    }

    public void popClassifier() {
        this.parseState.removeObsoleteFeatures();
        this.parseState.removeObsoleteInnerClasses();
        this.parseState = this.parseStateStack.pop();
    }

    public Object addOperation(short modifiers, String returnType, String name, List<ParameterDeclaration> parameters, String javadoc) {
        return this.addOperation(modifiers, EMPTY_STRING_LIST, returnType, name, parameters, javadoc, false);
    }

    Object addOperation(short modifiers, List<String> typeParameters, String returnType, String name, List<ParameterDeclaration> parameters, String javadoc, boolean forceIt) {
        if (typeParameters != null && typeParameters.size() > 0) {
            this.logError("type parameters not supported on operation return type", name);
        }
        Object mOperation = this.getOperation(name);
        this.parseState.feature(mOperation);
        Model.getCoreHelper().setRoot(mOperation, false);
        this.setOwnerScope(mOperation, modifiers);
        this.setVisibility(mOperation, modifiers);
        if (Model.getFacade().getConcurrency(mOperation) == Model.getConcurrencyKind().getGuarded()) {
            Model.getCoreHelper().setConcurrency(mOperation, Model.getConcurrencyKind().getSequential());
        }
        ArrayList c = new ArrayList(Model.getFacade().getParameters(mOperation));
        for (Object parameter : c) {
            Model.getCoreHelper().removeParameter(mOperation, parameter);
        }
        Object mClassifier = null;
        if (returnType == null || "void".equals(returnType) && name.equals(Model.getFacade().getName(this.parseState.getClassifier()))) {
            Model.getCoreHelper().addStereotype(mOperation, this.getStereotype(mOperation, "create", "BehavioralFeature"));
        } else {
            try {
                mClassifier = this.getContext(returnType).get(this.getClassifierName(returnType));
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && returnType != null && this.model != null) {
                    LOG.log(Level.INFO, "Modeler.java: forced creation of unknown classifier " + returnType);
                    String packageName = this.getPackageName(returnType);
                    String classifierName = this.getClassifierName(returnType);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName) : this.model;
                    mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                    this.newElements.add(mClassifier);
                }
                this.warnClassifierNotFound(returnType, "operation return type");
            }
            if (mClassifier != null) {
                Object i$ = this.buildReturnParameter(mOperation, mClassifier);
            }
        }
        for (ParameterDeclaration parameter : parameters) {
            String typeName = parameter.getType();
            if (typeName.endsWith("...")) {
                this.logError("Unsupported variable length parameter list notation", parameter.getName());
            }
            mClassifier = null;
            try {
                mClassifier = this.getContext(typeName).get(this.getClassifierName(typeName));
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && typeName != null && this.model != null) {
                    LOG.log(Level.INFO, "Modeler.java: forced creation of unknown classifier " + typeName);
                    String packageName = this.getPackageName(typeName);
                    String classifierName = this.getClassifierName(typeName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName) : this.model;
                    mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                    this.newElements.add(mClassifier);
                }
                this.warnClassifierNotFound(typeName, "operation params");
            }
            if (mClassifier == null) continue;
            Object mParameter = this.buildInParameter(mOperation, mClassifier, parameter.getName());
            if (Model.getFacade().isAClassifier(mClassifier)) continue;
            this.logError("Modeler.java: a valid type for a parameter could not be resolved:\n In file: " + this.fileName + ", for operation: " + Model.getFacade().getName(mOperation) + ", for parameter: ", Model.getFacade().getName(mParameter));
        }
        this.addDocumentationTag(mOperation, javadoc);
        return mOperation;
    }

    private Object buildInParameter(Object operation, Object classifier, String name) {
        Object parameter = this.buildParameter(operation, classifier, name);
        Model.getCoreHelper().setKind(parameter, Model.getDirectionKind().getInParameter());
        return parameter;
    }

    private Object buildReturnParameter(Object operation, Object classifier) {
        Object parameter = this.buildParameter(operation, classifier, "return");
        Model.getCoreHelper().setKind(parameter, Model.getDirectionKind().getReturnParameter());
        return parameter;
    }

    private Object buildParameter(Object operation, Object classifier, String name) {
        Object parameter = Model.getCoreFactory().buildParameter(operation, classifier);
        Model.getCoreHelper().setName(parameter, name);
        return parameter;
    }

    private void warnClassifierNotFound(String name, String operation) {
        this.logError("Modeler.java: a classifier (" + name + ") that was in the source " + "file could not be generated in the model ", operation);
    }

    private void logError(String message, String identifier) {
        LOG.log(Level.WARNING, message + " : " + identifier);
    }

    public void addAttribute(short modifiers, String typeSpec, String name, String initializer, String javadoc) {
        this.addAttribute(modifiers, typeSpec, name, initializer, javadoc, false);
    }

    void addAttribute(short modifiers, String typeSpec, String name, String initializer, String javadoc, boolean forceIt) {
        String multiplicity = "1_1";
        Object mClassifier = null;
        if (typeSpec != null) {
            if (!this.arraysAsDatatype && typeSpec.indexOf(91) != -1) {
                typeSpec = typeSpec.substring(0, typeSpec.indexOf(91));
                multiplicity = "1_N";
            }
            try {
                mClassifier = this.getContext(typeSpec).get(this.getClassifierName(typeSpec));
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && typeSpec != null && this.model != null) {
                    LOG.log(Level.INFO, "Modeler.java: forced creation of unknown classifier " + typeSpec);
                    String packageName = this.getPackageName(typeSpec);
                    String classifierName = this.getClassifierName(typeSpec);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName) : this.model;
                    mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                    this.newElements.add(mClassifier);
                }
                this.warnClassifierNotFound(typeSpec, "an attribute");
            }
            if (mClassifier == null) {
                this.logError("failed to find or create type", typeSpec);
                return;
            }
        }
        if (mClassifier == null || this.noAssociations || Model.getFacade().isADataType(mClassifier)) {
            Object mAttribute = this.parseState.getAttribute(name);
            if (mAttribute == null) {
                mAttribute = this.buildAttribute(this.parseState.getClassifier(), mClassifier, name);
            }
            this.parseState.feature(mAttribute);
            this.setOwnerScope(mAttribute, modifiers);
            this.setVisibility(mAttribute, modifiers);
            Model.getCoreHelper().setMultiplicity(mAttribute, multiplicity);
            if (Model.getFacade().isAClassifier(mClassifier)) {
                Model.getCoreHelper().setType(mAttribute, mClassifier);
            } else {
                this.logError("Modeler.java: a valid type for a parameter could not be resolved:\n In file: " + this.fileName + ", for attribute: ", Model.getFacade().getName(mAttribute));
            }
            if (initializer != null) {
                initializer = initializer.replace('\n', ' ');
                initializer = initializer.replace('\t', ' ');
                Object newInitialValue = Model.getDataTypesFactory().createExpression("Java", initializer);
                Model.getCoreHelper().setInitialValue(mAttribute, newInitialValue);
            }
            if (Model.getFacade().isReadOnly(mAttribute)) {
                Model.getCoreHelper().setReadOnly(mAttribute, true);
            }
            this.addDocumentationTag(mAttribute, javadoc);
        } else {
            Object mAssociationEnd = this.getAssociationEnd(name, mClassifier);
            this.setVisibility(mAssociationEnd, modifiers);
            Model.getCoreHelper().setMultiplicity(mAssociationEnd, multiplicity);
            Model.getCoreHelper().setType(mAssociationEnd, mClassifier);
            Model.getCoreHelper().setName(mAssociationEnd, name);
            if (!mClassifier.equals(this.parseState.getClassifier())) {
                Model.getCoreHelper().setNavigable(mAssociationEnd, true);
            }
            this.addDocumentationTag(mAssociationEnd, javadoc);
        }
    }

    private Object getGeneralization(Object mPackage, Object parent, Object child) {
        Object mGeneralization = Model.getFacade().getGeneralization(child, parent);
        if (mGeneralization == null) {
            mGeneralization = Model.getCoreFactory().buildGeneralization(child, parent);
            this.newElements.add(mGeneralization);
        }
        if (mGeneralization != null) {
            Model.getCoreHelper().setNamespace(mGeneralization, mPackage);
        }
        return mGeneralization;
    }

    private Object getAbstraction(Object parent, Object child) {
        Object mAbstraction2 = null;
        for (Object mAbstraction2 : Model.getFacade().getClientDependencies(child)) {
            Collection c = Model.getFacade().getSuppliers(mAbstraction2);
            if (c == null || c.size() == 0) {
                Model.getCoreHelper().removeClientDependency(child, mAbstraction2);
                continue;
            }
            if (parent == c.toArray()[0]) break;
            mAbstraction2 = null;
        }
        if (mAbstraction2 == null) {
            mAbstraction2 = Model.getCoreFactory().buildAbstraction(this.makeAbstractionName(child, parent), parent, child);
            this.newElements.add(mAbstraction2);
        }
        return mAbstraction2;
    }

    private Object getPackage(String name) {
        Object mPackage = this.searchPackageInModel(name);
        if (mPackage == null) {
            mPackage = Model.getModelManagementFactory().buildPackage(this.getRelativePackageName(name));
            this.newElements.add(mPackage);
            Model.getCoreHelper().setNamespace(mPackage, this.model);
            if ("".equals(this.getPackageName(name))) {
                Model.getCoreHelper().addOwnedElement(this.model, mPackage);
            } else {
                Model.getCoreHelper().addOwnedElement(this.getPackage(this.getPackageName(name)), mPackage);
            }
        }
        return mPackage;
    }

    private Object searchPackageInModel(String name) {
        if ("".equals(this.getPackageName(name))) {
            return Model.getFacade().lookupIn(this.model, name);
        }
        Object owner = this.searchPackageInModel(this.getPackageName(name));
        return owner == null ? null : Model.getFacade().lookupIn(owner, this.getRelativePackageName(name));
    }

    private Object getOperation(String name) {
        Object mOperation = this.parseState.getOperation(name);
        if (mOperation != null) {
            LOG.info("Getting the existing operation " + name);
        } else {
            LOG.info("Creating a new operation " + name);
            Object cls = this.parseState.getClassifier();
            Object returnType = ProjectManager.getManager().getCurrentProject().getDefaultReturnType();
            mOperation = Model.getCoreFactory().buildOperation2(cls, returnType, name);
            this.newElements.add(mOperation);
        }
        return mOperation;
    }

    private Object buildAttribute(Object classifier, Object type, String name) {
        Object mAttribute = Model.getCoreFactory().buildAttribute2(classifier, type);
        this.newElements.add(mAttribute);
        Model.getCoreHelper().setName(mAttribute, name);
        return mAttribute;
    }

    private Object getAssociationEnd(String name, Object mClassifier) {
        Object mAssociationEnd = null;
        for (Object ae : Model.getFacade().getAssociationEnds(mClassifier)) {
            Object assoc = Model.getFacade().getAssociation(ae);
            if (!name.equals(Model.getFacade().getName(ae)) || Model.getFacade().getConnections(assoc).size() != 2 || Model.getFacade().getType(Model.getFacade().getNextEnd(ae)) != this.parseState.getClassifier()) continue;
            mAssociationEnd = ae;
        }
        if (mAssociationEnd == null && !this.noAssociations) {
            String newName = this.makeAssociationName(this.parseState.getClassifier(), mClassifier);
            Object mAssociation = Modeler.buildDirectedAssociation(newName, this.parseState.getClassifier(), mClassifier);
            mAssociationEnd = Model.getFacade().getAssociationEnd(mClassifier, mAssociation);
        }
        return mAssociationEnd;
    }

    public static Object buildDirectedAssociation(String name, Object sourceClassifier, Object destClassifier) {
        return Model.getCoreFactory().buildAssociation(destClassifier, true, sourceClassifier, false, name);
    }

    private Object getStereotype(String name) {
        LOG.fine("Trying to find a stereotype of name <<" + name + ">>");
        Object stereotype = Model.getFacade().lookupIn(this.model, name);
        if (stereotype == null) {
            LOG.fine("Couldn't find so creating it");
            return Model.getExtensionMechanismsFactory().buildStereotype(name, this.model);
        }
        if (!Model.getFacade().isAStereotype(stereotype)) {
            LOG.fine("Found something that isn't a stereotype so creating it");
            return Model.getExtensionMechanismsFactory().buildStereotype(name, this.model);
        }
        LOG.fine("Found it");
        return stereotype;
    }

    private Object getStereotype(Object me, String name, String baseClass) {
        Collection models = ProjectManager.getManager().getCurrentProject().getModels();
        Collection stereos = Model.getExtensionMechanismsHelper().getAllPossibleStereotypes(models, me);
        Object stereotype2 = null;
        if (stereos != null && stereos.size() > 0) {
            for (Object stereotype2 : stereos) {
                if (!Model.getExtensionMechanismsHelper().isStereotypeInh(stereotype2, name, baseClass)) continue;
                LOG.info("Returning the existing stereotype of <<" + Model.getFacade().getName(stereotype2) + ">>");
                return stereotype2;
            }
        }
        if ((stereotype2 = this.getStereotype(name)) != null) {
            Model.getExtensionMechanismsHelper().addBaseClass(stereotype2, me);
            return stereotype2;
        }
        throw new IllegalArgumentException("Could not find a suitable stereotype for " + Model.getFacade().getName(me) + " -  stereotype: <<" + name + ">> base: " + baseClass);
    }

    private void cleanModelElement(Object element) {
        Object tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        while (tv != null) {
            Model.getUmlFactory().delete(tv);
            tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        }
    }

    private String getPackageName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        String pkgName = name.substring(0, lastDot);
        return pkgName;
    }

    private String getRelativePackageName(String packageName) {
        return this.getClassifierName(packageName);
    }

    private String getClassifierName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1);
    }

    private void setVisibility(Object element, short modifiers) {
        if ((modifiers & 1) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPublic());
        } else {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPackage());
        }
    }

    private void setOwnerScope(Object feature, short modifiers) {
    }

    private Context getContext(String name) {
        Context context = this.parseState.getContext();
        String packageName = this.getPackageName(name);
        if (!"".equals(packageName)) {
            context = new PackageContext(context, this.getPackage(packageName));
        }
        return context;
    }

    private void addDocumentationTag(Object modelElement, String sJavaDocs) {
        if (sJavaDocs != null && sJavaDocs.trim().length() >= 5) {
            StringBuffer sbPureDocs = new StringBuffer(80);
            Object sCurrentTagData = null;
            int nStartPos = 3;
            boolean fHadAsterisk = true;
            block4: while (nStartPos < sJavaDocs.length()) {
                int j;
                switch (sJavaDocs.charAt(nStartPos)) {
                    case '*': {
                        fHadAsterisk = true;
                        ++nStartPos;
                        continue block4;
                    }
                    case '\t': 
                    case ' ': {
                        if (fHadAsterisk) break;
                        ++nStartPos;
                        continue block4;
                    }
                }
                for (j = nStartPos; j < sJavaDocs.length() && (sJavaDocs.charAt(j) == ' ' || sJavaDocs.charAt(j) == '\t'); ++j) {
                }
                if (j < sJavaDocs.length()) {
                    int nTemp = sJavaDocs.indexOf(10, nStartPos);
                    nTemp = nTemp == -1 ? sJavaDocs.length() : ++nTemp;
                    sbPureDocs.append(sJavaDocs.substring(nStartPos, nTemp));
                    nStartPos = nTemp;
                }
                fHadAsterisk = false;
            }
            sJavaDocs = sbPureDocs.toString();
            sJavaDocs = this.removeTrailingSlash(sJavaDocs);
            Model.getExtensionMechanismsHelper().addTaggedValue(modelElement, Model.getExtensionMechanismsFactory().buildTaggedValue("documentation", sJavaDocs));
        }
    }

    private String removeTrailingSlash(String s) {
        if (s.endsWith("\n/")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void addCall(String methodName) {
        this.methodCalls.add(methodName);
    }

    public synchronized List<String> getMethodCalls() {
        return this.methodCalls;
    }

    public void clearMethodCalls() {
        this.methodCalls.clear();
    }

    public void addLocalVariableDeclaration(String type, String name) {
        this.localVariables.put(name, type);
    }

    public Hashtable getLocalVariableDeclarations() {
        return this.localVariables;
    }

    public void clearLocalVariableDeclarations() {
        this.localVariables.clear();
    }

    public Collection getNewElements() {
        return this.newElements;
    }

    public void setGenerateNames(boolean generateNamesFlag) {
        this.generateNames = generateNamesFlag;
    }
}

