/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.SaveGraphicsAction;
import org.tigris.gef.base.TransFilter;
import org.tigris.gef.util.Localizer;

public class SaveGIFAction
extends SaveGraphicsAction {
    private static final long serialVersionUID = 2390013810162720448L;
    public static final int TRANSPARENT_BG_COLOR = 0xEFEFEF;

    public SaveGIFAction(String name) {
        this(name, false);
    }

    public SaveGIFAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public SaveGIFAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SaveGIFAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    protected void saveGraphics(OutputStream s, Editor ce, Rectangle drawingArea) throws IOException {
        Image i = ce.createImage(drawingArea.width * this.scale, drawingArea.height * this.scale);
        Graphics g = i.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.scale, this.scale);
        }
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(0, 0, drawingArea.width * this.scale, drawingArea.height * this.scale);
        g.translate(-drawingArea.x, -drawingArea.y);
        ce.print(g);
        try {
            FilteredImageSource fis = new FilteredImageSource(i.getSource(), new TransFilter(0xEFEFEF));
            GifEncoder ge = new GifEncoder(fis, s);
            ge.encode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        g.dispose();
        g = null;
        i = null;
    }
}

