/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.util.Localizer;

public class SelectNextAction
extends AbstractAction {
    private static final long serialVersionUID = 1725046263612956528L;
    private String direction;
    public static final String DIR = "Direction";
    public static final String DIR_NEXT = "Next";
    public static final String DIR_PREV = "Previous";

    public SelectNextAction() {
        this(null, true);
    }

    public SelectNextAction(String name) {
        this(name, true);
    }

    public SelectNextAction(String name, boolean next) {
        this(name, next ? DIR_NEXT : DIR_PREV, false);
    }

    public SelectNextAction(String name, String direction) {
        this(name, direction, false);
    }

    public SelectNextAction(String name, Icon icon) {
        this(name, icon, DIR_NEXT);
    }

    public SelectNextAction(String name, Icon icon, boolean next) {
        this(name, icon, next ? DIR_NEXT : DIR_PREV, false);
    }

    public SelectNextAction(String name, Icon icon, String direction) {
        this(name, icon, direction, false);
    }

    public SelectNextAction(String name, String direction, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public SelectNextAction(String name, Icon icon, String direction, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void actionPerformed(ActionEvent e) {
        Fig newFig = null;
        int offset = 1;
        if (DIR_PREV.equals(this.direction)) {
            offset = -1;
        }
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        List<Fig> diagramContents = ce.getLayerManager().getContents();
        int diagramSize = diagramContents.size();
        int newIndex = diagramSize + 1;
        if (sm.size() == 0) {
            newIndex = 0;
        } else if (sm.size() == 1) {
            Selection curSel = (Selection)sm.selections().firstElement();
            Fig curFig = curSel.getContent();
            int curIndex = diagramContents.indexOf(curFig);
            newIndex = (curIndex + offset + diagramSize) % diagramSize;
        }
        if (diagramSize > newIndex) {
            newFig = diagramContents.get(newIndex);
        }
        if (newFig != null) {
            ce.getSelectionManager().select(newFig);
        }
    }
}

