/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;

public class AnnotationHelper {
    private static AnnotationHelper theInstance = null;

    private AnnotationHelper() {
    }

    public static AnnotationHelper instance() {
        if (theInstance == null) {
            theInstance = new AnnotationHelper();
        }
        return theInstance;
    }

    public static final int getNormOffset(Point p0, Point p1, Point p2) {
        float dd = (float)((double)((p2.x - p1.x) * (p0.y - p1.y) - (p0.x - p1.x) * (p2.y - p1.y)) / Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y)));
        int offset = -1 * Math.round(dd);
        return offset;
    }

    public static final float getRatio(Point from, Point begin, Point end) {
        int directionX = end.x - begin.x;
        int directionY = end.y - begin.y;
        int lengthSqr = directionX * directionX + directionY * directionY;
        float diffToStart = directionX * (from.x - begin.x) + directionY * (from.y - begin.y);
        return diffToStart / (float)lengthSqr;
    }

    public static final Point getClosestPoint(Point from, FigEdge to) {
        List<Point> points;
        try {
            points = ((FigPoly)to.getFig()).getPointsList();
        }
        catch (Exception e) {
            points = new ArrayList<Point>();
        }
        if (points.size() < 2) {
            points.add(to.getSourcePortFig().getCenter());
            points.add(to.getDestPortFig().getCenter());
        }
        Point bestPoint = AnnotationHelper.getClosestPointOnEdge(from, points.get(0), points.get(1));
        int bestDistance = AnnotationHelper.sqr_distance(from, bestPoint);
        for (int i = 1; i < points.size() - 1; ++i) {
            Point two;
            Point one = points.get(i);
            Point candidate = AnnotationHelper.getClosestPointOnEdge(from, one, two = points.get(i + 1));
            if (AnnotationHelper.sqr_distance(from, candidate) >= bestDistance) continue;
            bestPoint = candidate;
            bestDistance = AnnotationHelper.sqr_distance(from, bestPoint);
        }
        return bestPoint;
    }

    public static final Point getClosestPointOnEdge(Point p, Point begin, Point end) {
        double length;
        double diffToStart;
        double directionX = end.x - begin.x;
        double directionY = end.y - begin.y;
        if ((diffToStart = (directionX /= (length = Math.sqrt(directionX * directionX + directionY * directionY))) * (double)(p.x - begin.x) + (directionY /= length) * (double)(p.y - begin.y)) < 0.0) {
            return begin;
        }
        if (diffToStart > length) {
            return end;
        }
        return new Point(begin.x + (int)(diffToStart * directionX), begin.y + (int)(diffToStart * directionY));
    }

    public static final int sqr_distance(Point p1, Point p2) {
        return (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
    }

    public static Point getNormPointOnEdge(Point r1, Point r0, Point r2) {
        Point a = new Point(r2.x - r0.x, r2.y - r0.y);
        float t = (float)((r1.x - r0.x) * a.x + (r1.y - r0.y) * a.y) / (float)(a.x * a.x + a.y * a.y);
        Point normpoint = new Point();
        normpoint.x = (int)((float)r1.x + ((float)(r0.x - r1.x) + t * (float)a.x));
        normpoint.y = (int)((float)r1.y + ((float)(r0.y - r1.y) + t * (float)a.y));
        return normpoint;
    }
}

