/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class FigEdgePoly
extends FigEdge {
    private static final long serialVersionUID = -5534202173807357676L;
    @Deprecated
    protected boolean _initiallyLaidOut;
    private static Handle _TempHandle = new Handle(0);

    protected Fig makeEdgeFig() {
        FigPoly res = new FigPoly(Color.black);
        res.setRectilinear(false);
        res.setFixedHandles(1);
        res.setFilled(false);
        return res;
    }

    public void computeRouteImpl() {
        if (!this._initiallyLaidOut) {
            this.layoutEdge();
            this._initiallyLaidOut = true;
        }
        FigPoly p = (FigPoly)this.getFig();
        Fig sourcePortFig = this.getSourcePortFig();
        Fig destPortFig = this.getDestPortFig();
        Point srcPt = sourcePortFig.getCenter();
        Point dstPt = destPortFig.getCenter();
        if (this._useNearest) {
            if (p.getNumPoints() == 2) {
                srcPt = sourcePortFig.connectionPoint(p.getPoint(1));
                dstPt = destPortFig.connectionPoint(p.getPoint(p.getNumPoints() - 2));
                srcPt = sourcePortFig.connectionPoint(dstPt);
                dstPt = destPortFig.connectionPoint(srcPt);
            } else if (p.getNumPoints() > 2) {
                srcPt = sourcePortFig.connectionPoint(p.getPoint(1));
                dstPt = destPortFig.connectionPoint(p.getPoint(p.getNumPoints() - 2));
            }
        }
        this.setEndPoints(srcPt, dstPt);
        this.calcBounds();
    }

    protected void layoutEdge() {
        int npoints = 0;
        int[] xpoints = new int[16];
        int[] ypoints = new int[16];
        Fig sourcePortFig = this.getSourcePortFig();
        Fig destPortFig = this.getDestPortFig();
        if (sourcePortFig == null || destPortFig == null) {
            throw new IllegalStateException("Both the source port and dest port fig must be defined on a " + this.getClass().getName() + " before the edge can be layed out");
        }
        Point srcPt = sourcePortFig.getCenter();
        Point dstPt = destPortFig.getCenter();
        if (this._useNearest) {
            int xdiff = srcPt.x - dstPt.x;
            int ydiff = srcPt.y - dstPt.y;
            srcPt.x = (int)((double)srcPt.x - 0.1 * (double)xdiff);
            srcPt.y = (int)((double)srcPt.y - 0.1 * (double)ydiff);
            dstPt.x = (int)((double)dstPt.x + 0.1 * (double)xdiff);
            dstPt.y = (int)((double)dstPt.y + 0.1 * (double)ydiff);
            srcPt = sourcePortFig.connectionPoint(dstPt);
            dstPt = destPortFig.connectionPoint(srcPt);
            srcPt = sourcePortFig.connectionPoint(dstPt);
            dstPt = destPortFig.connectionPoint(srcPt);
        }
        xpoints[npoints] = srcPt.x;
        ypoints[npoints++] = srcPt.y;
        xpoints[npoints] = dstPt.x;
        ypoints[npoints++] = dstPt.y;
        Polygon routePoly = new Polygon(xpoints, ypoints, npoints);
        ((FigPoly)this.getFig()).setPolygon(routePoly);
    }

    protected Point routingRectPoint(Point p, Rectangle r, int sector) {
        switch (sector) {
            case -1: {
                return new Point(p.x, r.y);
            }
            case 2: {
                return new Point(r.x, p.y);
            }
            case 1: {
                return new Point(p.x, r.y + r.height);
            }
            case -2: {
                return new Point(r.x + r.width, p.y);
            }
        }
        System.out.println("error, undefined sector!");
        return p;
    }

    protected int tryRoute(int x, int y, int np, int[] xs, int[] ys, Rectangle avoid1, Rectangle avoid2, int srcSector, int dstSector) {
        if (np > 12) {
            return 0;
        }
        int fx = xs[np - 1];
        int fy = ys[np - 1];
        if ((fx == x || fy == y) && this.segOK(fx, fy, x, y, avoid1, avoid2)) {
            xs[np] = x;
            ys[np++] = y;
            xs[np] = x;
            ys[np++] = y;
            return 1;
        }
        if (this.segOK(fx, fy, fx, y, avoid1, avoid2) && this.segOK(fx, y, x, y, avoid1, avoid2)) {
            xs[np] = fx;
            ys[np++] = y;
            xs[np] = x;
            ys[np++] = y;
            return 2;
        }
        if (this.segOK(fx, fy, x, fy, avoid1, avoid2) && this.segOK(x, fy, x, y, avoid1, avoid2)) {
            xs[np] = x;
            ys[np++] = fy;
            xs[np] = x;
            ys[np++] = y;
            return 2;
        }
        Point avoidPt = this.findAvoidPt(fx, fy, x, y, avoid1, avoid2);
        if ((srcSector == 1 || srcSector == -1 || fy == avoidPt.y) && fx != avoidPt.x) {
            xs[np] = avoidPt.x;
            ys[np++] = fy;
            return this.tryRoute(x, y, np, xs, ys, avoid1, avoid2, srcSector, dstSector) + 1;
        }
        if ((srcSector == 2 || srcSector == -2 || fx == avoidPt.x) && fy != avoidPt.y) {
            xs[np] = fx;
            ys[np++] = avoidPt.y;
            return this.tryRoute(x, y, np, xs, ys, avoid1, avoid2, srcSector, dstSector) + 1;
        }
        return 0;
    }

    protected Point findAvoidPt(int fx, int fy, int x, int y, Rectangle avoid1, Rectangle avoid2) {
        Point res = new Point(fx, fy);
        res.x = avoid1.x + avoid1.width < avoid2.x ? avoid2.x : (avoid2.x + avoid2.width < avoid1.x ? avoid1.x : Math.min(avoid1.x, avoid2.x));
        res.y = avoid1.y + avoid1.height < avoid2.y ? avoid2.y : (avoid2.y + avoid2.height < avoid1.y ? avoid1.y : Math.min(avoid1.y, avoid2.y));
        return res;
    }

    protected boolean segOK(int x1, int y1, int x2, int y2, Rectangle avoid1, Rectangle avoid2) {
        int xmin = Math.min(x1, x2);
        int xmax = Math.max(x1, x2);
        int ymin = Math.min(y1, y2);
        int ymax = Math.max(y1, y2);
        int rright = avoid1.x + avoid1.width;
        int rbot = avoid1.y + avoid1.height;
        if (x1 == x2 && x1 > avoid1.x && x1 < rright && (ymin < avoid1.y && ymax > avoid1.y || ymin < rbot && ymax > rbot)) {
            return false;
        }
        if (y1 == y2 && y1 > avoid1.y && y1 < rbot && (xmin < avoid1.x && xmax > avoid1.x || xmin < rright && xmax > rright)) {
            return false;
        }
        rright = avoid2.x + avoid2.width;
        rbot = avoid2.y + avoid2.height;
        if (x1 == x2 && x1 > avoid2.x && x1 < rright && (ymin < avoid2.y && ymax > avoid2.y || ymin < rbot && ymax > rbot)) {
            return false;
        }
        return y1 != y2 || y1 <= avoid2.y || y1 >= rbot || (xmin >= avoid2.x || xmax <= avoid2.x) && (xmin >= rright || xmax <= rright);
    }

    public void moveVertex(Handle h, int x, int y, boolean ov) {
        int i = h.index;
        int np = this.getFig().getNumPoints();
        FigPoly p = (FigPoly)this.getFig();
        if (!p.getRectilinear()) {
            if (p.isComplete()) {
                if (i == 0) {
                    if (!(p._xpoints[i + 1] != x || p._ypoints[i + 1] != y || p._isSelfLoop && p._npoints <= 4)) {
                        p.removePoint(i + 1);
                    }
                } else if (!(i != np - 1 || p._xpoints[i - 1] != x || p._ypoints[i - 1] != y || p._isSelfLoop && p._npoints <= 4)) {
                    p.removePoint(i - 1);
                }
                if (np > 2) {
                    Point handlePoint = new Point(x, y);
                    Fig sourcePortFig = this.getSourcePortFig();
                    Fig destPortFig = this.getDestPortFig();
                    Point srcPt = sourcePortFig.getCenter();
                    Point dstPt = destPortFig.getCenter();
                    if (i == 1 && np == 3) {
                        srcPt = sourcePortFig.connectionPoint(handlePoint);
                        dstPt = destPortFig.connectionPoint(handlePoint);
                        p.moveVertex(new Handle(0), srcPt.x, srcPt.y, true);
                        p.moveVertex(new Handle(np - 1), dstPt.x, dstPt.y, true);
                        this.calcBounds();
                    } else if (i == 1) {
                        srcPt = sourcePortFig.connectionPoint(handlePoint);
                        p.moveVertex(new Handle(0), srcPt.x, srcPt.y, true);
                        this.calcBounds();
                    } else if (i == np - 2) {
                        dstPt = destPortFig.connectionPoint(handlePoint);
                        p.moveVertex(new Handle(np - 1), dstPt.x, dstPt.y, true);
                        this.calcBounds();
                    }
                }
            }
            p._xpoints[i] = x;
            p._ypoints[i] = y;
        }
    }

    public void setPoint(Handle h, int mX, int mY) {
        this.moveVertex(h, mX, mY, false);
        this.calcBounds();
    }

    public void setPolygon(Polygon p) {
        ((FigPoly)this.getFig()).setPolygon(p);
        this.calcBounds();
    }

    public Polygon getPolygon() {
        return ((FigPoly)this.getFig()).getPolygon();
    }

    public void insertPoint(int i, int x, int y) {
        FigPoly p = (FigPoly)this.getFig();
        p.insertPoint(i, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndPoints(Point start, Point end) {
        FigPoly p = (FigPoly)this.getFig();
        while (p._npoints < 2) {
            p.addPoint(start);
        }
        Handle handle = _TempHandle;
        synchronized (handle) {
            FigEdgePoly._TempHandle.index = 0;
            this.moveVertex(_TempHandle, start.x, start.y, true);
            FigEdgePoly._TempHandle.index = p._npoints - 1;
            this.moveVertex(_TempHandle, end.x, end.y, true);
        }
    }

    public void paint(Graphics graphicContext) {
        super.paint(graphicContext);
        if (this._highlight) {
            FigPoly f = (FigPoly)this.getFig();
            int nPoints = f.getNumPoints();
            int[] xs = f.getXs();
            int[] ys = f.getYs();
            Graphics g = graphicContext;
            for (int i = 1; i < nPoints; ++i) {
                this.paintHighlightLine(g, xs[i - 1], ys[i - 1], xs[i], ys[i]);
            }
        }
    }

    public void setInitiallyLaidOut(boolean laidOut) {
        this._initiallyLaidOut = laidOut;
    }
}

