/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.importer;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.language.csharp.importer.bridge.ModifierMap;
import org.argouml.language.csharp.importer.csparser.collections.NodeCollection;
import org.argouml.language.csharp.importer.csparser.members.FieldNode;
import org.argouml.language.csharp.importer.csparser.members.InterfaceMethodNode;
import org.argouml.language.csharp.importer.csparser.members.MethodNode;
import org.argouml.language.csharp.importer.csparser.members.ParamDeclNode;
import org.argouml.language.csharp.importer.csparser.members.PropertyNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.IdentifierExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.TypeNode;
import org.argouml.language.csharp.importer.csparser.structural.CompilationUnitNode;
import org.argouml.language.csharp.importer.csparser.structural.NamespaceNode;
import org.argouml.language.csharp.importer.csparser.structural.UsingDirectiveNode;
import org.argouml.language.csharp.importer.csparser.types.ClassNode;
import org.argouml.language.csharp.importer.csparser.types.InterfaceNode;
import org.argouml.model.Model;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.ImportSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSModeller {
    private Project project;
    private ImportSettings settings;
    private CompilationUnitNode cu = null;
    private int phase = 0;
    private static String TAG_CLASS = "cls#";
    private static String TAG_INTERFACE = "int#";
    private static String TAG_NS = "ns#";
    private static String TAG_GEN = "gen#";
    private static String TAG_EXTEND = "ext#";
    private static String TAG_OP = "opr#";
    private static String TAG_STEREOTYPE = "str#";
    private Object model;
    private Hashtable<String, Object> ele = new Hashtable();
    private boolean arraysAsDatatype;

    public CSModeller(Project p, ImportSettings settings) {
        this.project = p;
        this.model = p.getModel();
        this.settings = settings;
        this.arraysAsDatatype = false;
    }

    public void model(List cNodes, ProgressMonitor monitor, int startCount) {
        int count = startCount;
        this.phase = 0;
        for (Object obj : cNodes) {
            if (monitor.isCanceled()) {
                monitor.updateSubTask(Translator.localize((String)"dialog.import.cancelled"));
                return;
            }
            this.cu = (CompilationUnitNode)obj;
            this.addNamespace(this.cu.DefaultNamespace);
            this.addNamespaceNodes(this.cu.Namespaces);
            monitor.updateProgress(count++);
        }
        ++this.phase;
        for (Object obj : cNodes) {
            if (monitor.isCanceled()) {
                monitor.updateSubTask(Translator.localize((String)"dialog.import.cancelled"));
                return;
            }
            this.cu = (CompilationUnitNode)obj;
            this.addNamespace(this.cu.DefaultNamespace);
            this.addNamespaceNodes(this.cu.Namespaces);
            monitor.updateProgress(count++);
        }
    }

    public void addNamespaceNodes(NodeCollection<NamespaceNode> nss) {
        for (NamespaceNode ns : nss) {
            if (this.phase == 0) {
                this.addNamespace(ns);
            }
            this.addNamespaceClasses(ns);
        }
        for (NamespaceNode ns : nss) {
            this.addNamespaceNodes(ns.Namespaces);
        }
    }

    private void addNamespaceClasses(NamespaceNode ns) {
        String parent = this.buildToParent(ns.Name.Identifier, ns.Name.Identifier.length);
        for (ClassNode classNode : ns.Classes) {
            if (this.phase == 0) {
                this.addClass(classNode.Modifiers, classNode.Name.Identifier[classNode.Name.Identifier.length - 1], parent);
                continue;
            }
            if (this.phase != 1) continue;
            this.addAttributes(classNode, parent);
            this.addProperties(classNode, parent);
            this.addMethods(classNode, parent);
            this.buildGeneralization(classNode, ns);
        }
        for (InterfaceNode interfaceNode : ns.Interfaces) {
            if (this.phase == 0) {
                this.addInterface(interfaceNode.Modifiers, interfaceNode.Name.Identifier[interfaceNode.Name.Identifier.length - 1], parent);
                continue;
            }
            if (this.phase != 1) continue;
            this.addMethods(interfaceNode, parent);
        }
    }

    private void addMethods(ClassNode cn, String namespace) {
        for (MethodNode mn : cn.Methods) {
            this.addOperation(cn.Name.Identifier[0], mn, namespace);
        }
    }

    private void addMethods(InterfaceNode cn, String namespace) {
        for (InterfaceMethodNode mn : cn.Methods) {
            this.addOperation(cn.Name.Identifier[0], mn, namespace);
        }
    }

    private void addRootNamesapce(String name) {
        if (this.ele.get(TAG_NS + name) != null) {
            return;
        }
        Object pk = Model.getModelManagementFactory().buildPackage(name);
        Model.getCoreHelper().setRoot(pk, true);
        Model.getCoreHelper().setNamespace(pk, this.model);
        Model.getCoreHelper().addOwnedElement(this.model, pk);
        this.ele.put(TAG_NS + name, pk);
    }

    private void addSubNamesapce(String name, String parent) {
        if (this.ele.get(TAG_NS + parent + "." + name) != null) {
            return;
        }
        Object pk = Model.getModelManagementFactory().buildPackage(name);
        Model.getCoreHelper().setRoot(pk, true);
        Model.getCoreHelper().setNamespace(pk, this.ele.get(TAG_NS + parent));
        this.ele.put(TAG_NS + parent + "." + name, pk);
    }

    public void addNamespace(NamespaceNode ns) {
        for (int i = 0; i < ns.Name.Identifier.length; ++i) {
            if (i == 0) {
                this.addRootNamesapce(ns.Name.Identifier[i]);
                continue;
            }
            this.addSubNamesapce(ns.Name.Identifier[i], this.buildToParent(ns.Name.Identifier, i));
        }
        this.addFixedStereotypes();
    }

    private String buildToParent(String[] sa, int k) {
        String p = "";
        for (int i = 0; i < k; ++i) {
            p = i < k - 1 ? p + sa[i] + "." : p + sa[i];
        }
        return p;
    }

    public Object addClass(long modifiers, String name, String parent) {
        if (this.ele.get(TAG_CLASS + parent + "." + name) != null) {
            return this.ele.get(TAG_CLASS + parent + "." + name);
        }
        short cmod = ModifierMap.getUmlModifierForVisibility(modifiers);
        Object mClass = Model.getCoreFactory().createClass();
        Model.getCoreHelper().setName(mClass, name);
        Model.getCoreHelper().setNamespace(mClass, this.ele.get(TAG_NS + parent));
        this.setVisibility(mClass, cmod);
        Model.getCoreHelper().setAbstract(mClass, (cmod & 0x400) > 0);
        Model.getCoreHelper().setLeaf(mClass, (cmod & 0x10) > 0);
        Model.getCoreHelper().setRoot(mClass, false);
        this.ele.put(TAG_CLASS + parent + "." + name, mClass);
        System.out.println("Add class " + TAG_CLASS + parent + "." + name);
        return mClass;
    }

    public Object addInterface(long modifiers, String name, String parent) {
        if (this.ele.get(TAG_INTERFACE + parent + "." + name) != null) {
            return this.ele.get(TAG_INTERFACE + parent + "." + name);
        }
        short cmod = ModifierMap.getUmlModifierForVisibility(modifiers);
        Object mInterface = Model.getCoreFactory().createInterface();
        Model.getCoreHelper().setName(mInterface, name);
        Model.getCoreHelper().setNamespace(mInterface, this.ele.get(TAG_NS + parent));
        this.setVisibility(mInterface, cmod);
        Model.getCoreHelper().setRoot(mInterface, false);
        this.ele.put(TAG_INTERFACE + parent + "." + name, mInterface);
        return mInterface;
    }

    public void addOperation(String parent, MethodNode mn, String cPackage) {
        String name = ((IdentifierExpression)mn.names.get((int)0)).Identifier[0];
        String className = cPackage + "." + parent;
        String id = TAG_OP + className + "." + name + this.getParameterTypeString(mn);
        if (this.ele.get(id) != null) {
            return;
        }
        short cmod = ModifierMap.getUmlModifierForVisibility(mn.modifiers);
        Object cls = this.ele.get(TAG_CLASS + className);
        Object classifier = null;
        String temp = this.buildToParent(mn.type.Identifier.Identifier, mn.type.Identifier.Identifier.length);
        classifier = this.getStoredDataType(temp, cPackage);
        Object mOperation = Model.getCoreFactory().buildOperation2(cls, classifier, name);
        this.setVisibility(mOperation, cmod);
        Model.getCoreHelper().setAbstract(mOperation, (cmod & 0x400) > 0);
        Model.getCoreHelper().setLeaf(mOperation, (cmod & 0x10) > 0);
        Model.getCoreHelper().setRoot(mOperation, false);
        Model.getCoreHelper().setStatic(mOperation, (cmod & 8) > 0);
        Object parameter = null;
        if (mn.params != null) {
            for (ParamDeclNode p : mn.params) {
                classifier = null;
                classifier = this.getStoredDataType(this.buildToParent(p.type.Identifier.Identifier, p.type.Identifier.Identifier.length), cPackage);
                parameter = Model.getCoreFactory().buildParameter(mOperation, classifier);
                Model.getCoreHelper().setName(parameter, p.name);
            }
        }
        this.ele.put(id, mOperation);
    }

    public void addOperation(String parent, InterfaceMethodNode mn, String cPackage) {
        String name = ((IdentifierExpression)mn.names.get((int)0)).Identifier[0];
        String className = cPackage + "." + parent;
        String id = TAG_OP + className + "." + name + this.getParameterTypeString(mn);
        if (this.ele.get(id) != null) {
            return;
        }
        short cmod = ModifierMap.getUmlModifierForVisibility(mn.modifiers);
        Object cls = this.ele.get(TAG_CLASS + className);
        if (cls == null) {
            cls = this.ele.get(TAG_INTERFACE + className);
        }
        if (cls == null) {
            return;
        }
        Object classifier = null;
        String temp = this.buildToParent(mn.type.Identifier.Identifier, mn.type.Identifier.Identifier.length);
        classifier = this.getStoredDataType(temp, cPackage);
        Object mOperation = Model.getCoreFactory().buildOperation2(cls, classifier, name);
        this.setVisibility(mOperation, cmod);
        Model.getCoreHelper().setAbstract(mOperation, (cmod & 0x400) > 0);
        Model.getCoreHelper().setLeaf(mOperation, (cmod & 0x10) > 0);
        Model.getCoreHelper().setRoot(mOperation, false);
        Model.getCoreHelper().setStatic(mOperation, (cmod & 8) > 0);
        Object parameter = null;
        if (mn.params != null) {
            for (ParamDeclNode p : mn.params) {
                classifier = null;
                classifier = this.getStoredDataType(this.buildToParent(p.type.Identifier.Identifier, p.type.Identifier.Identifier.length), cPackage);
                parameter = Model.getCoreFactory().buildParameter(mOperation, classifier);
                Model.getCoreHelper().setName(parameter, p.name);
            }
        }
        this.ele.put(id, mOperation);
    }

    void addAttributes(ClassNode cn, String cPackage) {
        if (cn.Fields != null) {
            for (FieldNode f : cn.Fields) {
                this.addAttribute(cn, f, cPackage);
            }
        }
    }

    void addProperties(ClassNode cn, String cPackage) {
        if (cn.Properties != null) {
            for (PropertyNode f : cn.Properties) {
                this.addProperty(cn, f, cPackage);
            }
        }
    }

    void addAttribute(ClassNode cn, FieldNode fn, String cPackage) {
        short modifiers = ModifierMap.getUmlModifierForVisibility(fn.modifiers);
        String typeSpec = this.buildToParent(fn.type.Identifier.Identifier, fn.type.Identifier.Identifier.length);
        String name = this.buildToParent(((IdentifierExpression)fn.names.get((int)0)).Identifier, ((IdentifierExpression)fn.names.get((int)0)).Identifier.length);
        String initializer = null;
        String docs = "";
        boolean forceIt = false;
        String multiplicity = "1_1";
        Object mClassifier = null;
        String className = cPackage + "." + cn.Name.Identifier[0];
        Object cls = this.ele.get(TAG_CLASS + className);
        if (typeSpec != null) {
            if (!this.arraysAsDatatype && typeSpec.indexOf(91) != -1) {
                typeSpec = typeSpec.substring(0, typeSpec.indexOf(91));
                multiplicity = "1_N";
            }
            mClassifier = this.getStoredDataType(typeSpec, cPackage);
        }
        Object mAttribute = this.buildAttribute(cls, mClassifier, name);
        this.setOwnerScope(mAttribute, modifiers);
        this.setVisibility(mAttribute, modifiers);
        Model.getCoreHelper().setMultiplicity(mAttribute, multiplicity);
        if (initializer != null) {
            initializer = initializer.replace('\n', ' ');
            initializer = initializer.replace('\t', ' ');
            Object newInitialValue = Model.getDataTypesFactory().createExpression("CSharp", initializer);
            Model.getCoreHelper().setInitialValue(mAttribute, newInitialValue);
        }
        if ((modifiers & 0x10) > 0) {
            Model.getCoreHelper().setReadOnly(mAttribute, true);
        } else if (Model.getFacade().isReadOnly(mAttribute)) {
            Model.getCoreHelper().setReadOnly(mAttribute, true);
        }
    }

    private Object buildReturnParameter(Object operation, Object classifier) {
        Object parameter = this.buildParameter(operation, classifier, "return");
        Model.getCoreHelper().setKind(parameter, Model.getDirectionKind().getReturnParameter());
        return parameter;
    }

    private Object buildParameter(Object operation, Object classifier, String name) {
        Object parameter = Model.getCoreFactory().buildParameter(operation, classifier);
        Model.getCoreHelper().setName(parameter, name);
        return parameter;
    }

    private void buildGeneralization(ClassNode cn, NamespaceNode ns) {
        if (cn.BaseClasses != null) {
            for (TypeNode tn : cn.BaseClasses) {
                String parent = this.buildToParent(tn.Identifier.Identifier, tn.Identifier.Identifier.length);
                String child = this.buildToParent(cn.Name.Identifier, cn.Name.Identifier.length);
                String pkg = this.buildToParent(ns.Name.Identifier, ns.Name.Identifier.length);
                Object c = this.getStoredDataType(child, pkg);
                Object p = this.getStoredDataType(parent, pkg);
                Object n = this.getNameSpace(pkg);
                Object g = null;
                g = Model.getFacade().isAInterface(p) ? this.buildRealization(c, p, n) : this.buildGeneralizations(c, p);
                if (g == null) continue;
                Model.getCoreHelper().setName(g, child + " -> " + parent);
            }
        }
    }

    private Object buildGeneralizations(Object child, Object parnt) {
        Object gen = Model.getCoreFactory().buildGeneralization(child, parnt);
        return gen;
    }

    private Object buildRealization(Object child, Object parnt, Object namespace) {
        Object rel = Model.getCoreFactory().buildRealization(child, parnt, namespace);
        return rel;
    }

    Object getClasesByName(String paramType, String cPackage) {
        Object kx = null;
        if (paramType.contains(".")) {
            return this.ele.get(TAG_CLASS + paramType);
        }
        kx = this.ele.get(TAG_CLASS + cPackage + "." + paramType);
        System.out.println(kx);
        if (kx != null) {
            return kx;
        }
        for (UsingDirectiveNode u : this.cu.UsingDirectives) {
            String temp = this.buildToParent(u.Target.Identifier, u.Target.Identifier.length);
            kx = this.ele.get(TAG_CLASS + temp + "." + paramType);
            System.out.println(kx);
            if (kx == null) continue;
            return kx;
        }
        return null;
    }

    Object getInterfaceByName(String paramType, String cPackage) {
        Object kx = null;
        if (paramType.contains(".")) {
            return this.ele.get(TAG_INTERFACE + paramType);
        }
        kx = this.ele.get(TAG_INTERFACE + cPackage + "." + paramType);
        if (kx != null) {
            return kx;
        }
        for (UsingDirectiveNode u : this.cu.UsingDirectives) {
            kx = this.ele.get(TAG_INTERFACE + this.buildToParent(u.Target.Identifier, u.Target.Identifier.length) + "." + paramType);
            if (kx == null) continue;
            return kx;
        }
        return null;
    }

    private void setVisibility(Object element, short modifiers) {
        if ((modifiers & 2) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPrivate());
        } else if ((modifiers & 4) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getProtected());
        } else if ((modifiers & 1) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPublic());
        } else {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPackage());
        }
    }

    private void setOwnerScope(Object feature, short modifiers) {
        Model.getCoreHelper().setStatic(feature, (modifiers & 8) > 0);
    }

    private String getParameterTypeString(MethodNode mn) {
        String k = "";
        if (mn.params == null) {
            return k;
        }
        for (ParamDeclNode p : mn.params) {
            k = k + "|" + this.buildToParent(p.type.Identifier.Identifier, p.type.Identifier.Identifier.length);
        }
        return k.toLowerCase();
    }

    private String getParameterTypeString(InterfaceMethodNode mn) {
        String k = "";
        if (mn.params == null) {
            return k;
        }
        for (ParamDeclNode p : mn.params) {
            k = k + "|" + this.buildToParent(p.type.Identifier.Identifier, p.type.Identifier.Identifier.length);
        }
        return k.toLowerCase();
    }

    private short concatModifires(short[] modifiers) {
        short mod = 0;
        for (int i = 0; i < modifiers.length; ++i) {
            mod = (short)(mod + modifiers[i]);
        }
        return mod;
    }

    public Collection getNewElements() {
        return this.ele.values();
    }

    public Object getStoredDataType(String name, String cPackage) {
        Object classifier = this.getClasesByName(name, cPackage);
        if (classifier == null) {
            classifier = this.getInterfaceByName(name, cPackage);
        }
        if (classifier == null) {
            classifier = this.addClass(0L, name, "DefaultNamespace");
            this.ele.put(TAG_CLASS + "DefaultNamespace" + "." + name, classifier);
        }
        return classifier;
    }

    public Object getNameSpace(String pkg) {
        return this.ele.get(TAG_NS + pkg);
    }

    private Object buildAttribute(Object classifier, Object type, String name) {
        Object mAttribute = Model.getCoreFactory().buildAttribute2(classifier, type);
        Model.getCoreHelper().setName(mAttribute, name);
        return mAttribute;
    }

    void addProperty(ClassNode cn, PropertyNode fn, String cPackage) {
        short modifiers = ModifierMap.getUmlModifierForVisibility(fn.modifiers);
        String typeSpec = this.buildToParent(fn.type.Identifier.Identifier, fn.type.Identifier.Identifier.length);
        String name = this.buildToParent(((IdentifierExpression)fn.names.get((int)0)).Identifier, ((IdentifierExpression)fn.names.get((int)0)).Identifier.length);
        String initializer = null;
        String docs = "";
        boolean forceIt = false;
        String multiplicity = "1_1";
        Object mClassifier = null;
        String className = cPackage + "." + cn.Name.Identifier[0];
        Object cls = this.ele.get(TAG_CLASS + className);
        if (typeSpec != null) {
            if (!this.arraysAsDatatype && typeSpec.indexOf(91) != -1) {
                typeSpec = typeSpec.substring(0, typeSpec.indexOf(91));
                multiplicity = "1_N";
            }
            mClassifier = this.getStoredDataType(typeSpec, cPackage);
        }
        Object mAttribute = this.buildAttribute(cls, mClassifier, name);
        this.setOwnerScope(mAttribute, modifiers);
        this.setVisibility(mAttribute, modifiers);
        Model.getCoreHelper().setMultiplicity(mAttribute, multiplicity);
        if (fn.getter != null && fn.setter != null) {
            this.applyReadWriteStereotype(mAttribute);
        } else if (fn.getter != null) {
            this.applyWriteOnlyStereotype(mAttribute);
        } else if (fn.setter != null) {
            this.applyReadOnlyStereotype(mAttribute);
        }
        if (initializer != null) {
            initializer = initializer.replace('\n', ' ');
            initializer = initializer.replace('\t', ' ');
            Object newInitialValue = Model.getDataTypesFactory().createExpression("CSharp", initializer);
            Model.getCoreHelper().setInitialValue(mAttribute, newInitialValue);
        }
        if ((modifiers & 0x10) > 0) {
            Model.getCoreHelper().setReadOnly(mAttribute, true);
        } else if (Model.getFacade().isReadOnly(mAttribute)) {
            Model.getCoreHelper().setReadOnly(mAttribute, true);
        }
    }

    private void applyReadWriteStereotype(Object property) {
        Object mSt = this.ele.get(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_rw");
        if (mSt != null) {
            Model.getCoreHelper().addStereotype(property, mSt);
        }
    }

    private void applyWriteOnlyStereotype(Object property) {
        Object mSt = this.ele.get(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_ro");
        if (mSt != null) {
            Model.getCoreHelper().addStereotype(property, mSt);
        }
    }

    private void applyReadOnlyStereotype(Object property) {
        Object mSt = this.ele.get(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_ro");
        if (mSt != null) {
            Model.getCoreHelper().addStereotype(property, mSt);
        }
    }

    private void addFixedStereotypes() {
        Object mSt = this.ele.get(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_rw");
        if (mSt == null) {
            Object strCP = Model.getExtensionMechanismsFactory().buildStereotype("CSharp Property", this.model);
            Object tv = Model.getExtensionMechanismsFactory().buildTaggedValue("accessors", "read-only");
            Model.getExtensionMechanismsHelper().addTaggedValue(strCP, tv);
            this.ele.put(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_ro", strCP);
            strCP = Model.getExtensionMechanismsFactory().buildStereotype("CSharp Property", this.model);
            tv = Model.getExtensionMechanismsFactory().buildTaggedValue("accessors", "write-only");
            Model.getExtensionMechanismsHelper().addTaggedValue(strCP, tv);
            this.ele.put(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_wo", strCP);
            strCP = Model.getExtensionMechanismsFactory().buildStereotype("CSharp Property", this.model);
            tv = Model.getExtensionMechanismsFactory().buildTaggedValue("accessors", "read-and-write");
            Model.getExtensionMechanismsHelper().addTaggedValue(strCP, tv);
            this.ele.put(TAG_STEREOTYPE + "DefaultNamespace" + "." + "CSharp_Property_rw", strCP);
        }
    }
}

