/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.argouml.core.propertypanels.model.GetterSetterManager;
import org.argouml.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionModel {
    private static final Logger LOG = Logger.getLogger(ExpressionModel.class.getName());
    private Object target;
    private String propertyName;
    private final GetterSetterManager getterSetterManager;
    private final Class<?> type;
    private static final String EMPTYSTRING = "";
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public ExpressionModel(String propertyName, Class<?> type, Object umlElement, GetterSetterManager getterSetterManager) {
        this.target = umlElement;
        LOG.log(Level.INFO, "Creating ExpressionModel with target {0}", this.target);
        this.propertyName = propertyName;
        this.getterSetterManager = getterSetterManager;
        this.type = type;
    }

    private Object getExpression() {
        Object expression = null;
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            expression = this.getterSetterManager.get(this.target, this.propertyName, this.type);
            LOG.log(Level.INFO, "Got the expression {0}", expression);
        } else {
            expression = this.target;
        }
        return expression;
    }

    public void setExpression(Object expr) {
        LOG.log(Level.INFO, "Setting the expression to {0}", expr);
        this.getterSetterManager.set(this.target, expr, this.propertyName);
    }

    public Object newExpression(String language, String body) {
        return this.getterSetterManager.create(this.propertyName, language, body);
    }

    public String getLanguage() {
        Object expression = this.getExpression();
        if (expression == null) {
            return EMPTYSTRING;
        }
        return Model.getDataTypesHelper().getLanguage(expression);
    }

    public String getBody() {
        Object expression = this.getExpression();
        if (expression == null) {
            return EMPTYSTRING;
        }
        return Model.getDataTypesHelper().getBody(expression);
    }

    public void setLanguage(String lang) {
        String oldValue;
        Object expression = this.getExpression();
        boolean mustChange = true;
        if (expression != null && (oldValue = Model.getDataTypesHelper().getLanguage(expression)) != null && oldValue.equals(lang)) {
            mustChange = false;
        }
        if (mustChange) {
            String body = EMPTYSTRING;
            if (expression != null && Model.getDataTypesHelper().getBody(expression) != null) {
                body = Model.getDataTypesHelper().getBody(expression);
            }
            this.setExpression(lang, body);
        }
    }

    public void setBody(String body) {
        String oldValue;
        Object expression = this.getExpression();
        boolean mustChange = true;
        if (expression != null && (oldValue = Model.getDataTypesHelper().getBody(expression)) != null && oldValue.equals(body)) {
            mustChange = false;
        }
        if (mustChange) {
            String lang = null;
            if (expression != null) {
                lang = Model.getDataTypesHelper().getLanguage(expression);
            }
            if (lang == null) {
                lang = EMPTYSTRING;
            }
            this.setExpression(lang, body);
        }
    }

    private void setExpression(String lang, String body) {
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Object currentExpression = this.getExpression();
            if (currentExpression != null) {
                LOG.log(Level.INFO, "Deleting the current expression {0}", currentExpression);
                Model.getUmlFactory().delete(currentExpression);
            }
            Object newExpression = lang.length() == 0 && body.length() == 0 ? null : this.newExpression(lang, body);
            this.setExpression(newExpression);
        } else {
            Object expression = this.getExpression();
            Model.getDataTypesHelper().setBody(expression, body);
            Model.getDataTypesHelper().setLanguage(expression, lang);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
        LOG.log(Level.FINE, ">>Add listener");
    }

    protected void fireStateChanged() {
        LOG.log(Level.FINE, ">>Fire state changed to listeners.");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

