/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import org.argouml.core.propertypanels.ui.Expandable;
import org.tigris.swidgets.FlexiGridLayout;

class LabelledComponent
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -6805892904843209588L;
    private static final Set<String> EXPANDED_CONTROLS = new TreeSet<String>();
    private static Icon expandedIcon;
    private JComponent expansion;
    private static Icon collapsedIcon;
    private final JLabel label;
    private final JComponent component;
    private final JLabel expander;
    private final JPanel leftPanel;

    public LabelledComponent(String name, JComponent component) {
        super(new BorderLayout());
        this.component = component;
        this.setName(name);
        this.add((Component)component, "Center");
        if (name != null) {
            this.label = new JLabel(name);
            this.label.setLabelFor(component);
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout((LayoutManager)new FlexiGridLayout(1, 2, 21));
            labelPanel.add(this.label);
            this.leftPanel = new JPanel(new BorderLayout());
            this.leftPanel.add((Component)labelPanel, "North");
            this.add((Component)this.leftPanel, "West");
            if (component instanceof Expandable && ((Expandable)((Object)component)).isExpandable()) {
                this.expander = new JLabel();
                labelPanel.add(this.expander);
                this.addMouseListener(this);
                this.setIcon();
                if (EXPANDED_CONTROLS.contains(this.getId())) {
                    this.toggleExpansion((Expandable)((Object)component));
                }
            } else {
                this.expander = null;
            }
        } else {
            this.label = null;
            this.expander = null;
            this.leftPanel = null;
        }
    }

    private String getId() {
        return this.label.getText();
    }

    private void setIcon() {
        if (this.expander != null) {
            if (((Expandable)((Object)this.component)).isExpanded()) {
                this.expander.setIcon(expandedIcon);
            } else {
                this.expander.setIcon(collapsedIcon);
            }
        }
    }

    JLabel getLabel() {
        return this.label;
    }

    public Dimension getPreferredSize() {
        if (this.component instanceof JComboBox) {
            return null;
        }
        return super.getPreferredSize();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this) {
            this.toggleExpansion((Expandable)((Object)this.component));
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    private void toggleExpansion(Expandable expandable) {
        boolean expanded = !expandable.isExpanded();
        expandable.setExpanded(expanded);
        if (expanded) {
            EXPANDED_CONTROLS.add(this.getId());
        } else {
            EXPANDED_CONTROLS.remove(this.getId());
        }
        this.setIcon();
        if (this.expansion == null) {
            this.expansion = expandable.getExpansion();
            this.leftPanel.add((Component)this.expansion, "Center");
        }
        this.expansion.setVisible(expanded);
        Container c = this.component.getParent().getParent();
        if (c != null) {
            ((Component)c).invalidate();
            ((Component)c).validate();
        }
    }

    static {
        JTree dummyTree = new JTree();
        BasicTreeUI btu = dummyTree.getUI() instanceof BasicTreeUI ? (BasicTreeUI)dummyTree.getUI() : new MetalTreeUI();
        expandedIcon = btu.getExpandedIcon();
        collapsedIcon = btu.getCollapsedIcon();
    }
}

