/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.profile.Profile;
import org.argouml.profile.ProfileException;
import org.argouml.ui.UndoableAction;

class UMLComponentInstanceClassifierComboBoxModel
extends UMLComboBoxModel {
    private static final Logger LOG = Logger.getLogger("UMLComponentInstanceClassifierComboBoxModel");

    public UMLComponentInstanceClassifierComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected void buildModelList() {
        ArrayList list = new ArrayList();
        Project p = ProjectManager.getManager().getCurrentProject();
        Object model = p.getRoot();
        list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(model, Model.getMetaTypes().getComponent()));
        for (Profile profile : p.getProfileConfiguration().getProfiles()) {
            try {
                for (Object topPackage : profile.getProfilePackages()) {
                    list.addAll(Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(topPackage, Model.getMetaTypes().getComponent()));
                }
            }
            catch (ProfileException e) {
                LOG.log(Level.SEVERE, "Exception", e);
            }
        }
        this.setElements(list);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAClassifier(element) && Model.getFacade().getRepresentedClassifier(this.getTarget()) == element;
    }

    protected Object getSelectedModelElement() {
        Collection list = Model.getFacade().getClassifiers(this.getTarget());
        if (list.size() == 0) {
            return null;
        }
        return list.iterator().next();
    }

    public Action getAction() {
        return new ActionSet();
    }

    private class ActionSet
    extends UndoableAction {
        ActionSet() {
            super(Translator.localize((String)"action.set"), (Icon)ResourceLoaderWrapper.lookupIcon((String)"action.set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox source = (UMLComboBox)e.getSource();
            Object target = source.getTarget();
            Object newValue = source.getSelectedItem();
            ArrayList<Object> classifiers = new ArrayList<Object>(1);
            if (Model.getFacade().isAClassifier(newValue)) {
                classifiers.add(newValue);
            }
            Model.getCommonBehaviorHelper().setClassifiers(UMLComponentInstanceClassifierComboBoxModel.this.getTarget(), classifiers);
        }
    }
}

