/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationModel;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationPanel;

class UMLValueSpecificationPanelOptional
extends JPanel
implements ChangeListener {
    private static final Logger LOG = Logger.getLogger(UMLValueSpecificationPanel.class.getName());
    private JCheckBox valueExists;
    private UMLValueSpecificationPanel uvsPanel;
    private final UMLValueSpecificationModel model;

    public UMLValueSpecificationPanelOptional(UMLValueSpecificationModel aModel, String title) {
        super(new BorderLayout());
        LOG.log(Level.FINE, ">>New Optional ValueSpecification panel created");
        TitledBorder border = new TitledBorder(title);
        this.setBorder(border);
        this.model = aModel;
        this.valueExists = new JCheckBox();
        boolean withDefault = this.model.getExpression() != null;
        this.valueExists.setSelected(withDefault);
        this.valueExists.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UMLValueSpecificationPanelOptional.this.uvsPanel.setVisible(UMLValueSpecificationPanelOptional.this.valueExists.isSelected());
                if (UMLValueSpecificationPanelOptional.this.valueExists.isSelected()) {
                    UMLValueSpecificationPanelOptional.this.uvsPanel.selectDefaultVS();
                } else {
                    UMLValueSpecificationPanelOptional.this.model.setValue(null);
                }
            }
        });
        this.uvsPanel = new UMLValueSpecificationPanel(this.model, "");
        this.uvsPanel.setVisible(this.valueExists.isSelected());
        this.add((Component)this.valueExists, "West");
        this.add((Component)this.uvsPanel, "Center");
        this.model.addChangeListener(this);
    }

    public void removeNotify() {
        this.model.removeChangeListener(this);
        super.removeNotify();
    }

    public void stateChanged(ChangeEvent e) {
        LOG.log(Level.FINE, ">>Values shown on panel are changed");
    }
}

