/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.php.generator;

import org.apache.log4j.Logger;
import org.argouml.model.Model;

public final class NameGenerator {
    private static final Logger LOG = Logger.getLogger(NameGenerator.class);
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    protected static final String generate(Object object, int n) {
        String string = "";
        if (Model.getFacade().isAPackage(object)) {
            string = NameGenerator.generatePackageName(object);
        } else if (Model.getFacade().isAClassifier(object)) {
            string = NameGenerator.generateClassifierName(object);
        } else if (Model.getFacade().isAAttribute(object)) {
            string = NameGenerator.generateAttributeName(object, n);
        } else if (Model.getFacade().isAOperation(object)) {
            string = NameGenerator.generateOperationName(object, n);
        } else if (Model.getFacade().isAAssociationEnd(object)) {
            String string2 = Model.getFacade().getName(object);
            if (string2 == null) {
                Object object2 = Model.getFacade().getType(object);
                String string3 = Model.getFacade().getName(object2);
                string2 = "my" + string3;
            }
            string = string2;
        } else {
            try {
                string = Model.getFacade().getName(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error((Object)"org.argouml.model.Facade#getName needs already a fix");
            }
        }
        return string;
    }

    public static final String generatePackageName(Object object) {
        if (object == null || !Model.getFacade().isANamespace(object) || Model.getFacade().getNamespace(object) == null) {
            return null;
        }
        if (!Model.getFacade().isAPackage(object)) {
            object = Model.getFacade().getNamespace(object);
            if (Model.getFacade().getNamespace(object) == null) {
                return null;
            }
        }
        String string = Model.getFacade().getName(object);
        while ((object = Model.getFacade().getNamespace(object)) != null) {
            if (Model.getFacade().getNamespace(object) == null) continue;
            string = Model.getFacade().getName(object) + '_' + string;
        }
        return string;
    }

    private static final String generatePackagePath(Object object) {
        if (object == null || !Model.getFacade().isANamespace(object) || Model.getFacade().getNamespace(object) == null) {
            return null;
        }
        if (!Model.getFacade().isAPackage(object)) {
            object = Model.getFacade().getNamespace(object);
            if (Model.getFacade().getNamespace(object) == null) {
                return null;
            }
        }
        String string = Model.getFacade().getName(object);
        while ((object = Model.getFacade().getNamespace(object)) != null) {
            if (Model.getFacade().getNamespace(object) == null) continue;
            string = Model.getFacade().getName(object) + FILE_SEPARATOR + string;
        }
        return string;
    }

    public static final String generateClassifierName(Object object) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string = Model.getFacade().getName(object);
        String string2 = NameGenerator.generatePackageName(object);
        if (string != null && string2 != null && string2.length() > 0) {
            string = string2 + "_" + string;
        }
        return string;
    }

    protected static final String generateAttributeName(Object object, int n) {
        if (!Model.getFacade().isAAttribute(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Attribute required");
        }
        String string = Model.getFacade().getName(object);
        if (n < 5 && !Model.getFacade().isPublic(object)) {
            return "_" + string;
        }
        return string;
    }

    protected static final String generateAssociationEndName(Object object, int n) {
        if (!Model.getFacade().isAAssociationEnd(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, AssociationEnd required");
        }
        String string = Model.getFacade().getName(object);
        if (string == null) {
            Object object2 = Model.getFacade().getType(object);
            String string2 = Model.getFacade().getName(object2);
            String string3 = Model.getFacade().getName(object);
            if (string3 == null) {
                string3 = "my" + string2;
            }
        }
        if (n < 5 && !Model.getFacade().isPublic(object)) {
            return "_" + string;
        }
        return string;
    }

    protected static final String generateOperationName(Object object, int n) {
        if (!Model.getFacade().isAOperation(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Operation required");
        }
        String string = Model.getFacade().getName(object);
        if (n < 5 && !Model.getFacade().isPublic(object)) {
            return "_" + string;
        }
        return string;
    }

    protected static final String generateFilename(Object object, int n) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        return NameGenerator.generateFilename(object, null, n);
    }

    protected static final String generateFilename(Object object, String string, int n) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        if (string != null && string.trim().length() > 0) {
            if (!string.endsWith(FILE_SEPARATOR)) {
                string = string + FILE_SEPARATOR;
            }
        } else {
            string = "";
        }
        String string2 = NameGenerator.generatePackagePath(object);
        String string3 = string = string + (string2 != null ? string2 + FILE_SEPARATOR : "");
        if (n > 4) {
            string3 = Model.getFacade().isAInterface(object) ? string3 + "interface." : (Model.getFacade().isAClass(object) ? string3 + "class." : string3 + "unknown.");
        }
        String string4 = Model.getFacade().getName(object);
        string3 = string3 + string4 + ".php";
        return string3;
    }
}

