/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.deployment2.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import org.argouml.model.Model;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.ui.FigNodeModelElement;
import org.tigris.gef.presentation.Fig;

public class FigNode
extends FigNodeModelElement {
    protected static final int DEPTH = 20;
    private static final int WIDTH = 200;
    private static final int HEIGHT = 180;
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 80;
    private static final int MARGIN = 2;

    protected Fig createBigPortFig() {
        FigCube port = new FigCube(0, 0, 200, 180, 20);
        port.setFilled(false);
        port.setLineWidth(1);
        return port;
    }

    public FigNode(Object owner, Rectangle bounds, DiagramSettings settings) {
        super(owner, bounds, settings);
        this.initialize();
    }

    private void initialize() {
        this.addFig(this.getBigPort());
        this.addFig((Fig)this.getStereotypeFig());
        this.addFig((Fig)this.getNameFig());
    }

    public Dimension getMinimumSize() {
        Dimension stereoDim = this.getStereotypeFig().getMinimumSize();
        Dimension nameDim = this.getNameFig().getMinimumSize();
        int w = Math.max(stereoDim.width, nameDim.width) + 20;
        int h = stereoDim.height + nameDim.height + 20;
        w = Math.max(80, w);
        h = Math.max(80, h);
        return new Dimension(w, h);
    }

    protected void setStandardBounds(int x, int y, int w, int h) {
        if (this.getNameFig() == null) {
            return;
        }
        this.getBigPort().setBounds(x, y, w, h);
        Dimension stereoDim = this.getStereotypeFig().getMinimumSize();
        this.getStereotypeFig().setBounds(x + this.getLeftMargin(), y + this.getTopMargin(), w - this.getLeftMargin() - this.getRightMargin(), stereoDim.height);
        Dimension nameDim = this.getNameFig().getMinimumSize();
        this.getNameFig().setBounds(x + this.getLeftMargin(), this.getStereotypeFig().getY() + stereoDim.height + 1, w - this.getLeftMargin() - this.getRightMargin(), nameDim.height);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this.updateEdges();
    }

    public void setEnclosingFig(Fig encloser) {
        if (encloser == null || encloser != null && Model.getFacade().isANode(encloser.getOwner())) {
            super.setEnclosingFig(encloser);
        }
    }

    public boolean getUseTrapRect() {
        return true;
    }

    public Rectangle getTrapRect() {
        return new Rectangle(this._x, this._y + 20, this._w - 20, this._h - 20);
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        popUpActions.add(popUpActions.size() - FigNode.getPopupAddOffset(), this.buildModifierPopUp(7));
        return popUpActions;
    }

    int getRightMargin() {
        return 22;
    }

    int getLeftMargin() {
        return 2;
    }

    int getTopMargin() {
        return 22;
    }

    int getBottomMargin() {
        return 2;
    }

    public class FigCube
    extends Fig
    implements Serializable {
        private final int depth;

        public FigCube(int x, int y, int w, int h, int d) {
            super(x, y, w, h);
            this.depth = d;
        }

        public void paint(Graphics g) {
            Color fillColor = this.getFillColor();
            Color lineColor = this.getLineColor();
            g.setColor(fillColor);
            Polygon p = new Polygon();
            p.addPoint(this._x + this.depth, this._y);
            p.addPoint(this._x + this._w, this._y);
            p.addPoint(this._x + this._w, this._y + this._h - this.depth);
            p.addPoint(this._x + this._w - this.depth, this._y + this._h);
            p.addPoint(this._x, this._y + this._h);
            p.addPoint(this._x, this._y + this.depth);
            p.addPoint(this._x + this.depth, this._y);
            g.fillPolygon(p);
            g.setColor(lineColor);
            g.drawPolygon(p);
            g.drawLine(this._x, this._y + this.depth, this._x + this._w - this.depth, this._y + this.depth);
            g.drawLine(this._x + this._w - this.depth, this._y + this.depth, this._x + this._w - this.depth, this._y + this._h);
            g.drawLine(this._x + this._w - this.depth, this._y + this.depth, this._x + this._w, this._y);
        }

        public void appendSvg(StringBuffer sb) {
        }
    }
}

