/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.argouml.model.ModelManagementHelper;
import org.argouml.model.euml.EUMLModelImplementation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelManagementHelperEUMLImpl
implements ModelManagementHelper {
    private EUMLModelImplementation modelImpl;

    public ModelManagementHelperEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    @Override
    public Collection getAllBehavioralFeatures(Object ns) {
        return this.modelImpl.getCoreHelper().getAllBehavioralFeatures(ns);
    }

    @Override
    public Collection getAllContents(Object element) {
        if (!(element instanceof Element)) {
            throw new IllegalArgumentException("The argument must be instance of Element");
        }
        HashSet<PackageableElement> result = new HashSet<PackageableElement>();
        if (element instanceof Collaboration) {
            // empty if block
        }
        if (element instanceof Classifier) {
            result.addAll((Collection<PackageableElement>)((Classifier)element).allFeatures());
        }
        if (element instanceof Namespace) {
            result.addAll((Collection<PackageableElement>)((Namespace)element).getMembers());
        }
        if (element instanceof Package) {
            result.addAll((Collection<PackageableElement>)((Package)element).getPackagedElements());
            for (Package p = ((Package)element).getNestingPackage(); p != null; p = p.getNestingPackage()) {
                for (PackageableElement e : p.getPackagedElements()) {
                    if (e.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
                    result.add(e);
                }
            }
        }
        return result;
    }

    @Override
    public Collection getAllImportedElements(Object pack) {
        return null;
    }

    @Override
    public Collection getAllModelElementsOfKind(Object nsa, Object type) {
        if (!(nsa instanceof Element)) {
            return new ArrayList();
        }
        Class theType = null;
        if (type instanceof String) {
            try {
                theType = Class.forName((String)type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (type instanceof Class) {
            theType = (Class)type;
        } else {
            throw new IllegalArgumentException("type must be instance of Class or String");
        }
        if (!Element.class.isAssignableFrom(theType)) {
            throw new IllegalArgumentException("type must represent an Element");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : ((Namespace)nsa).allOwnedElements()) {
            if (!theType.isAssignableFrom(element.getClass())) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public Collection getAllModelElementsOfKind(Object nsa, String kind) {
        try {
            return this.getAllModelElementsOfKind(nsa, Class.forName(kind));
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
    }

    @Override
    public Collection getAllModelElementsOfKindWithModel(Object model, Object type) {
        if (!(model instanceof Model)) {
            throw new IllegalArgumentException("model must be instance of Model");
        }
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("type must be instance of java.lang.Class");
        }
        Class kind = (Class)type;
        ArrayList<Object> ret = this.getAllModelElementsOfKind(model, kind);
        if (kind.isAssignableFrom(model.getClass()) && !(ret = new ArrayList<Object>(ret)).contains(model)) {
            ret.add(model);
        }
        return ret;
    }

    @Override
    public Collection getAllNamespaces(Object ns) {
        return this.getAllModelElementsOfKind(ns, Namespace.class);
    }

    @Override
    public Collection getAllPossibleImports(Object pack) {
        return null;
    }

    @Override
    public Collection getAllSubSystems(Object ns) {
        return null;
    }

    @Override
    public Collection getAllSurroundingNamespaces(Object element) {
        if (!(element instanceof NamedElement)) {
            throw new IllegalArgumentException("element must be instance of NamedElement");
        }
        return ((NamedElement)element).allNamespaces();
    }

    @Override
    public Collection getContents(Object element) {
        if (!(element instanceof Element)) {
            throw new IllegalArgumentException("element must be instance of Element");
        }
        HashSet result = new HashSet();
        if (element instanceof Namespace) {
            result.addAll(((Namespace)element).getOwnedMembers());
            result.addAll(((Namespace)element).getImportedMembers());
        }
        if (element instanceof Package) {
            result.addAll(((Package)element).getPackagedElements());
        }
        return result;
    }

    @Override
    public Object getElement(List<String> path) {
        return this.getElement(path, null);
    }

    @Override
    public Object getElement(List<String> path, Object theRootNamespace) {
        return null;
    }

    @Override
    public List<String> getPathList(Object element) {
        ArrayList<String> path = new ArrayList<String>();
        String name = this.modelImpl.getFacade().isANamedElement(element) ? this.modelImpl.getFacade().getName(element) : this.modelImpl.getFacade().getUMLClassName(element) + " <not nameable>";
        path.add(name);
        return path;
    }

    @Override
    public List<Object> getRootElements(Object model) {
        if (model instanceof EObject) {
            ArrayList<Object> contents = new ArrayList<Object>();
            contents.addAll((Collection<Object>)((EObject)model).eResource().getContents());
            if (!contents.contains(model)) {
                contents.add(model);
            }
            return contents;
        }
        throw new IllegalArgumentException("model must be instance of EObject");
    }

    @Override
    public boolean isCyclicOwnership(Object parent, Object child) {
        return false;
    }

    @Override
    public void removeImportedElement(Object handle, Object me) {
    }

    @Override
    public void setAlias(Object handle, String alias) {
    }

    @Override
    public void setImportedElements(Object pack, Collection imports) {
    }

    @Override
    public void setSpecification(Object handle, boolean isSpecification) {
    }

    @Override
    public boolean isReadOnly(Object element) {
        return false;
    }
}

