/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.model.NotImplementedException;
import org.argouml.model.UmlException;
import org.argouml.model.XmiReader;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.NotYetImplementedException;
import org.argouml.model.euml.UMLUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.uml2.uml.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmiReaderEUMLImpl
implements XmiReader {
    private static final Logger LOG = Logger.getLogger(XmiReaderEUMLImpl.class.getName());
    private EUMLModelImplementation modelImpl;
    private static Set<String> searchDirs = new HashSet<String>();
    private Resource resource;

    public XmiReaderEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    @Override
    public int getIgnoredElementCount() {
        return 0;
    }

    @Override
    public String[] getIgnoredElements() {
        return new String[0];
    }

    @Override
    public Map<String, Object> getXMIUUIDToObjectMap() {
        if (this.resource == null) {
            throw new IllegalStateException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        TreeIterator it = this.resource.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            map.put(this.resource.getURIFragment(o), o);
        }
        return map;
    }

    @Override
    public Collection parse(InputSource inputSource, boolean readOnly) throws UmlException {
        int ix;
        if (inputSource == null) {
            throw new NullPointerException("The input source must be non-null.");
        }
        InputStream is = null;
        boolean needsClosing = false;
        String name = inputSource.getSystemId();
        if (name == null) {
            name = inputSource.getPublicId();
        }
        if (name == null) {
            name = inputSource.toString();
        }
        LOG.log(Level.FINE, "Parsing {0}", name);
        if (inputSource.getByteStream() != null) {
            is = inputSource.getByteStream();
        } else if (inputSource.getSystemId() != null) {
            try {
                URL url = new URL(inputSource.getSystemId());
                if (url != null) {
                    LOG.log(Level.FINE, "Parsing URL {0}", url);
                    is = url.openStream();
                    if (is != null) {
                        is = new BufferedInputStream(is);
                        needsClosing = true;
                    }
                }
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new UnsupportedOperationException();
        }
        String id = inputSource.getPublicId();
        if (id == null && (id = inputSource.getSystemId()) != null && (ix = id.lastIndexOf(47)) != -1) {
            id = id.substring(ix + 1);
        }
        Resource r = UMLUtil.getResource(this.modelImpl, URI.createURI((String)id), readOnly);
        try {
            this.modelImpl.getModelEventPump().stopPumpingEvents();
            r.unload();
            r.load(is, null);
            if (this.isUML14(r)) {
                throw new UmlException("Attempted to load UML 1.4 file");
            }
        }
        catch (IOException e) {
            throw new UmlException(e);
        }
        finally {
            this.modelImpl.getModelEventPump().startPumpingEvents();
            if (needsClosing) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.resource = r;
        LOG.log(Level.FINE, "Parsed resource " + this.resource + " with " + this.resource.getContents().size() + " elements");
        return r.getContents();
    }

    private boolean isUML2(Resource r) {
        for (EObject eobj : r.getContents()) {
            if (!(eobj instanceof Element)) continue;
            return true;
        }
        return false;
    }

    private boolean isUML14(Resource r) {
        for (EObject eobj : r.getContents()) {
            if (!"XMI.header".equals(eobj.eClass().getName())) continue;
            for (FeatureMap.Entry e1 : ((AnyType)eobj).getMixed()) {
                EStructuralFeatureImpl.BasicFeatureMapEntry x1;
                String n1;
                if (!(e1 instanceof EStructuralFeatureImpl.BasicFeatureMapEntry) || !"XMI.metamodel".equals(n1 = (x1 = (EStructuralFeatureImpl.BasicFeatureMapEntry)e1).getEStructuralFeature().getName())) continue;
                AnyType v = (AnyType)x1.getValue();
                for (FeatureMap.Entry e2 : v.getAnyAttribute()) {
                    String version;
                    if (!(e2 instanceof EStructuralFeatureImpl.SimpleFeatureMapEntry)) continue;
                    EStructuralFeatureImpl.SimpleFeatureMapEntry x = (EStructuralFeatureImpl.SimpleFeatureMapEntry)e2;
                    String n = x.getEStructuralFeature().getName();
                    if ("xmi.name".equals(n)) {
                        if ("UML".equals((String)x.getValue())) continue;
                        LOG.log(Level.WARNING, "Tried to parse XMI file with XMI.header/XMI.metamodel/xmi.name = " + (String)x.getValue());
                        return false;
                    }
                    if (!"xmi.version".equals(n) || (version = (String)x.getValue()) == null || !version.startsWith("1.4")) continue;
                    LOG.log(Level.FINE, "Tried to parse XMI file with XMI.header/XMI.metamodel/xmi.version = " + version);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean setIgnoredElements(String[] elementNames) {
        if (elementNames == null) {
            return true;
        }
        throw new NotImplementedException("setIgnoredElements not implemented for UML 2.x");
    }

    @Override
    public String getTagName() {
        if (this.resource == null) {
            return "uml:Model";
        }
        EList l = this.resource.getContents();
        if (!l.isEmpty()) {
            return "uml:" + this.modelImpl.getMetaTypes().getName(l.get(0));
        }
        return null;
    }

    @Override
    public void addSearchPath(String path) {
        searchDirs.add(path);
    }

    @Override
    public List<String> getSearchPath() {
        return new ArrayList<String>(searchDirs);
    }

    @Override
    public void removeSearchPath(String path) {
        searchDirs.remove(path);
    }

    @Override
    public String getHeader() {
        throw new NotYetImplementedException();
    }
}

