/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.ast.SimpleCharStream;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserTokenManager;
import net.sourceforge.pmd.lang.plsql.ast.Token;

public class PLSQLTokenizer
implements Tokenizer {
    private static final Logger LOGGER = Logger.getLogger(PLSQLTokenizer.class.getName());
    public static final String IGNORE_COMMENTS = "ignore_comments";
    public static final String IGNORE_IDENTIFIERS = "ignore_identifiers";
    public static final String IGNORE_LITERALS = "ignore_literals";
    private boolean ignoreComments;
    private boolean ignoreIdentifiers;
    private boolean ignoreLiterals;

    public void setProperties(Properties properties) {
        this.ignoreComments = Boolean.parseBoolean(properties.getProperty(IGNORE_COMMENTS, "true"));
        this.ignoreIdentifiers = Boolean.parseBoolean(properties.getProperty(IGNORE_IDENTIFIERS, "false"));
        this.ignoreLiterals = Boolean.parseBoolean(properties.getProperty(IGNORE_LITERALS, "false"));
    }

    public void setIgnoreComments(boolean ignore) {
        this.ignoreComments = ignore;
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        long encounteredTokens = 0L;
        long addedTokens = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("PLSQLTokenizer: ignoreComments==" + this.ignoreComments);
            LOGGER.fine("PLSQLTokenizer: ignoreIdentifiers==" + this.ignoreIdentifiers);
            LOGGER.fine("PLSQLTokenizer: ignoreLiterals==" + this.ignoreLiterals);
        }
        String fileName = sourceCode.getFileName();
        StringBuilder sb = sourceCode.getCodeBuffer();
        PLSQLParserTokenManager tokenMgr = new PLSQLParserTokenManager(new SimpleCharStream((Reader)new StringReader(sb.toString())));
        Token currentToken = tokenMgr.getNextToken();
        while (currentToken.image.length() > 0) {
            String image = currentToken.image;
            ++encounteredTokens;
            if (this.ignoreComments && (currentToken.kind == 30 || currentToken.kind == 33 || currentToken.kind == 32 || currentToken.kind == 75 || currentToken.kind == 2 || currentToken.kind == 1)) {
                image = String.valueOf(currentToken.kind);
            }
            if (this.ignoreIdentifiers && currentToken.kind == 418) {
                image = String.valueOf(currentToken.kind);
            }
            if (this.ignoreLiterals && (currentToken.kind == 419 || currentToken.kind == 420 || currentToken.kind == 421 || currentToken.kind == 423 || currentToken.kind == 424 || currentToken.kind == 426)) {
                image = String.valueOf(currentToken.kind);
            }
            tokenEntries.add(new TokenEntry(image, fileName, currentToken.beginLine));
            ++addedTokens;
            currentToken = tokenMgr.getNextToken();
        }
        tokenEntries.add(TokenEntry.getEOF());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sourceCode.getFileName() + ": encountered " + encounteredTokens + " tokens;" + " added " + addedTokens + " tokens");
        }
    }
}

