/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.XmlParser;
import net.sourceforge.pmd.util.CompoundIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlNodeInvocationHandler
implements InvocationHandler {
    private final org.w3c.dom.Node node;
    private Object userData;
    private XmlParser parser;

    public XmlNodeInvocationHandler(XmlParser parser, org.w3c.dom.Node node) {
        this.parser = parser;
        this.node = node;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().isAssignableFrom(XmlNode.class) && !"java.lang.Object".equals(method.getDeclaringClass().getName())) {
            if ("jjtGetNumChildren".equals(method.getName())) {
                return this.node.hasChildNodes() ? this.node.getChildNodes().getLength() : 0;
            }
            if ("jjtGetChild".equals(method.getName())) {
                return this.parser.createProxy(this.node.getChildNodes().item((Integer)args[0]));
            }
            if ("jjtGetChildIndex".equals(method.getName())) {
                org.w3c.dom.Node parent = this.node.getParentNode();
                NodeList childNodes = parent.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    if (this.node != childNodes.item(i)) continue;
                    return i;
                }
                throw new IllegalStateException("This node is not a child of its parent: " + this.node);
            }
            if ("getImage".equals(method.getName())) {
                if (this.node instanceof Text) {
                    return ((Text)this.node).getData();
                }
                return null;
            }
            if ("jjtGetParent".equals(method.getName())) {
                org.w3c.dom.Node parent = this.node.getParentNode();
                if (parent != null && !(parent instanceof Document)) {
                    return this.parser.createProxy(parent);
                }
                return null;
            }
            if ("getAttributeIterator".equals(method.getName())) {
                ArrayList<Iterator<Attribute>> iterators = new ArrayList<Iterator<Attribute>>();
                final NamedNodeMap attributes = this.node.getAttributes();
                iterators.add(new Iterator<Attribute>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        return attributes != null && this.index < attributes.getLength();
                    }

                    @Override
                    public Attribute next() {
                        org.w3c.dom.Node attributeNode = attributes.item(this.index++);
                        return new Attribute((Node)XmlNodeInvocationHandler.this.parser.createProxy(XmlNodeInvocationHandler.this.node), attributeNode.getNodeName(), attributeNode.getNodeValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
                if (proxy instanceof Text) {
                    iterators.add(Collections.singletonList(new Attribute((Node)proxy, "Image", ((Text)proxy).getData())).iterator());
                }
                return new CompoundIterator(iterators.toArray(new Iterator[iterators.size()]));
            }
            if ("getBeginLine".equals(method.getName())) {
                return this.getUserData("pmd:beginLine");
            }
            if ("getBeginColumn".equals(method.getName())) {
                return this.getUserData("pmd:beginColumn");
            }
            if ("getEndLine".equals(method.getName())) {
                return this.getUserData("pmd:endLine");
            }
            if ("getEndColumn".equals(method.getName())) {
                return this.getUserData("pmd:endColumn");
            }
            if ("getNode".equals(method.getName())) {
                return this.node;
            }
            if ("getUserData".equals(method.getName())) {
                return this.userData;
            }
            if ("setUserData".equals(method.getName())) {
                this.userData = args[0];
                return null;
            }
            if ("isFindBoundary".equals(method.getName())) {
                return false;
            }
            throw new UnsupportedOperationException("Method not supported for XmlNode: " + method);
        }
        if ("toString".equals(method.getName())) {
            String s = this.node.getNodeName();
            s = s.replace("#", "");
            return s;
        }
        Object result = method.invoke((Object)this.node, args);
        return result;
    }

    private Integer getUserData(String key) {
        if (this.node.getUserData(key) != null) {
            return (Integer)this.node.getUserData(key);
        }
        return -1;
    }
}

