/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.xml.XmlParserOptions;
import net.sourceforge.pmd.lang.xml.ast.DOMLineNumbers;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.XmlNodeInvocationHandler;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    protected final XmlParserOptions parserOptions;
    protected Map<Node, XmlNode> nodeCache = new HashMap<Node, XmlNode>();

    public XmlParser(XmlParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    protected Document parseDocument(Reader reader) throws ParseException {
        this.nodeCache.clear();
        try {
            String xmlData = IOUtils.toString((Reader)reader);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(this.parserOptions.isNamespaceAware());
            dbf.setValidating(this.parserOptions.isValidating());
            dbf.setIgnoringComments(this.parserOptions.isIgnoringComments());
            dbf.setIgnoringElementContentWhitespace(this.parserOptions.isIgnoringElementContentWhitespace());
            dbf.setExpandEntityReferences(this.parserOptions.isExpandEntityReferences());
            dbf.setCoalescing(this.parserOptions.isCoalescing());
            dbf.setXIncludeAware(this.parserOptions.isXincludeAware());
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.parserOptions.getEntityResolver());
            Document document = documentBuilder.parse(new InputSource(new StringReader(xmlData)));
            DOMLineNumbers lineNumbers = new DOMLineNumbers(document, xmlData);
            lineNumbers.determine();
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new ParseException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public XmlNode parse(Reader reader) {
        Document document = this.parseDocument(reader);
        return this.createProxy(document);
    }

    public XmlNode createProxy(Node node) {
        XmlNode proxy = this.nodeCache.get(node);
        if (proxy != null) {
            return proxy;
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        interfaces.add(XmlNode.class);
        if (node instanceof Document) {
            interfaces.add(RootNode.class);
        }
        this.addAllInterfaces(interfaces, node.getClass());
        proxy = (XmlNode)Proxy.newProxyInstance(XmlParser.class.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new XmlNodeInvocationHandler(this, node));
        this.nodeCache.put(node, proxy);
        return proxy;
    }

    public void addAllInterfaces(Set<Class<?>> interfaces, Class<?> clazz) {
        interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
        if (clazz.getSuperclass() != null) {
            this.addAllInterfaces(interfaces, clazz.getSuperclass());
        }
    }
}

