/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.CommentUtil;
import net.sourceforge.pmd.lang.java.ast.JavadocElement;
import net.sourceforge.pmd.lang.java.ast.Token;
import net.sourceforge.pmd.lang.java.javadoc.JavadocTag;

public abstract class Comment
extends AbstractNode {
    protected Comment(Token t) {
        super(-1, t.beginLine, t.endLine, t.beginColumn, t.endColumn);
        this.setImage(t.image);
        if (t.image.startsWith("/**")) {
            this.findJavadocs(t.image);
        }
    }

    public String toString() {
        return this.getImage();
    }

    private void findJavadocs(String commentText) {
        ArrayList<JavadocElement> kids = new ArrayList<JavadocElement>();
        Map<String, Integer> tags = CommentUtil.javadocTagsIn(commentText);
        for (Map.Entry<String, Integer> entry : tags.entrySet()) {
            JavadocTag tag = JavadocTag.tagFor(entry.getKey());
            if (tag == null) continue;
            kids.add(new JavadocElement(this.getBeginLine(), this.getBeginLine(), entry.getValue() + 1, entry.getValue() + tag.label.length() + 1, tag));
        }
        this.children = kids.toArray(new Node[kids.size()]);
    }
}

