/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.controversial;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class OnlyOneReturnRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isAbstract()) {
            return data;
        }
        List<ASTReturnStatement> returnNodes = new ArrayList<ASTReturnStatement>();
        node.findDescendantsOfType(ASTReturnStatement.class, returnNodes, false);
        returnNodes = this.filterLambdaExpressions(returnNodes);
        if (returnNodes.size() > 1) {
            Iterator<ASTReturnStatement> i = returnNodes.iterator();
            while (i.hasNext()) {
                Node problem = (Node)i.next();
                if (!i.hasNext()) continue;
                this.addViolation(data, problem);
            }
        }
        return data;
    }

    private List<ASTReturnStatement> filterLambdaExpressions(List<ASTReturnStatement> returnNodes) {
        ArrayList<ASTReturnStatement> filtered = new ArrayList<ASTReturnStatement>();
        for (ASTReturnStatement ret : returnNodes) {
            if (ret.getFirstParentOfType(ASTLambdaExpression.class) != null) continue;
            filtered.add(ret);
        }
        return filtered;
    }
}

