/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.typeresolution.PMDASMClassLoader;
import net.sourceforge.pmd.util.ClasspathClassLoader;

public class TypeSet {
    private final PMDASMClassLoader pmdClassLoader;
    private boolean hasAuxclasspath;
    private String pkg;
    private Set<String> imports = new HashSet<String>();
    private List<Resolver> resolvers = new ArrayList<Resolver>();

    public TypeSet() {
        this(TypeSet.class.getClassLoader());
    }

    public TypeSet(ClassLoader classLoader) {
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = TypeSet.class.getClassLoader();
        }
        this.hasAuxclasspath = cl instanceof ClasspathClassLoader;
        this.pmdClassLoader = PMDASMClassLoader.getInstance(cl);
    }

    public boolean hasAuxclasspath() {
        return this.hasAuxclasspath;
    }

    public void setASTCompilationUnitPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getASTCompilationUnitPackage() {
        return this.pkg;
    }

    public void addImport(String importString) {
        this.imports.add(importString);
    }

    public int getImportsCount() {
        return this.imports.size();
    }

    public Set<String> getExplicitImports() {
        return this.imports;
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.resolvers.isEmpty()) {
            this.buildResolvers();
        }
        for (Resolver resolver : this.resolvers) {
            try {
                return resolver.resolve(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException("Type " + name + " not found");
    }

    private void buildResolvers() {
        this.resolvers.add(new PrimitiveTypeResolver());
        this.resolvers.add(new VoidResolver());
        this.resolvers.add(new ExplicitImportResolver(this.pmdClassLoader, this.imports));
        this.resolvers.add(new CurrentPackageResolver(this.pmdClassLoader, this.pkg));
        this.resolvers.add(new ImplicitImportResolver(this.pmdClassLoader));
        this.resolvers.add(new ImportOnDemandResolver(this.pmdClassLoader, this.imports));
        this.resolvers.add(new FullyQualifiedNameResolver(this.pmdClassLoader));
    }

    public static class FullyQualifiedNameResolver
    extends AbstractResolver {
        public FullyQualifiedNameResolver(PMDASMClassLoader pmdClassLoader) {
            super(pmdClassLoader);
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            return this.pmdClassLoader.loadClass(name);
        }
    }

    public static class VoidResolver
    implements Resolver {
        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if ("void".equals(name)) {
                return Void.TYPE;
            }
            throw new ClassNotFoundException(name);
        }
    }

    public static class PrimitiveTypeResolver
    implements Resolver {
        private Map<String, Class<?>> primitiveTypes = new HashMap();

        public PrimitiveTypeResolver() {
            this.primitiveTypes.put("int", Integer.TYPE);
            this.primitiveTypes.put("float", Float.TYPE);
            this.primitiveTypes.put("double", Double.TYPE);
            this.primitiveTypes.put("long", Long.TYPE);
            this.primitiveTypes.put("boolean", Boolean.TYPE);
            this.primitiveTypes.put("byte", Byte.TYPE);
            this.primitiveTypes.put("short", Short.TYPE);
            this.primitiveTypes.put("char", Character.TYPE);
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (!this.primitiveTypes.containsKey(name)) {
                throw new ClassNotFoundException(name);
            }
            return this.primitiveTypes.get(name);
        }
    }

    public static class ImportOnDemandResolver
    extends AbstractResolver {
        private Set<String> importStmts;

        public ImportOnDemandResolver(PMDASMClassLoader pmdClassLoader, Set<String> importStmts) {
            super(pmdClassLoader);
            this.importStmts = importStmts;
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            for (String importStmt : this.importStmts) {
                if (!importStmt.endsWith("*")) continue;
                try {
                    String importPkg = importStmt.substring(0, importStmt.indexOf(42) - 1);
                    return this.pmdClassLoader.loadClass(importPkg + '.' + name);
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
            throw new ClassNotFoundException("Type " + name + " not found");
        }
    }

    public static class ImplicitImportResolver
    extends AbstractResolver {
        public ImplicitImportResolver(PMDASMClassLoader pmdClassLoader) {
            super(pmdClassLoader);
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            return this.pmdClassLoader.loadClass("java.lang." + name);
        }
    }

    public static class CurrentPackageResolver
    extends AbstractResolver {
        private String pkg;

        public CurrentPackageResolver(PMDASMClassLoader pmdClassLoader, String pkg) {
            super(pmdClassLoader);
            this.pkg = pkg;
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            return this.pmdClassLoader.loadClass(this.pkg + '.' + name);
        }
    }

    public static class ExplicitImportResolver
    extends AbstractResolver {
        private Set<String> importStmts;

        public ExplicitImportResolver(PMDASMClassLoader pmdClassLoader, Set<String> importStmts) {
            super(pmdClassLoader);
            this.importStmts = importStmts;
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            for (String importStmt : this.importStmts) {
                if (!importStmt.endsWith(name)) continue;
                return this.pmdClassLoader.loadClass(importStmt);
            }
            throw new ClassNotFoundException("Type " + name + " not found");
        }
    }

    public static abstract class AbstractResolver
    implements Resolver {
        protected final PMDASMClassLoader pmdClassLoader;

        public AbstractResolver(PMDASMClassLoader pmdClassLoader) {
            this.pmdClassLoader = pmdClassLoader;
        }
    }

    public static interface Resolver {
        public Class<?> resolve(String var1) throws ClassNotFoundException;
    }
}

