/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.scripting;

import Jxe.AttributedTextLine;
import Jxe.TextDocument;
import java.io.File;

public class AJSTextDocument {
    TextDocument doc;

    AJSTextDocument(TextDocument doc) {
        this.doc = doc;
    }

    public int getLineCount() {
        return this.doc.size();
    }

    public String getLine(int li) {
        return this.doc.lineAt(li).toString();
    }

    public int getLineLength(int li) {
        return this.doc.lineAt(li).size();
    }

    public boolean hasSelection() {
        return this.doc.hasSelection();
    }

    public boolean isModified() {
        return this.doc.isModified();
    }

    public boolean isReadOnly() {
        return this.doc.isReadOnly();
    }

    public void pasteDocument(AJSTextDocument toPaste) {
        this.doc.pasteDoc(toPaste.doc);
    }

    public void cutSelection() {
        this.doc.cutSelection();
    }

    public AJSTextDocument getSelection() {
        return new AJSTextDocument(this.doc.getSelection());
    }

    public String getSelectionAsString() {
        return this.doc.getSelectionAsString();
    }

    public void deSelect() {
        this.doc.unsetSelection();
    }

    public int[] getSelectionPosition() {
        return new int[]{this.doc.selStartX(), this.doc.selStartY(), this.doc.selEndX(), this.doc.selEndY()};
    }

    public void select(int colStart, int lineStart, int colEnd, int lineEnd) {
        this.doc.setSelection(colStart, lineStart, colEnd, lineEnd);
    }

    public void findAndSelect(String s) {
        this.doc.findAndSelectForward(s, this.doc.cX(), this.doc.cY());
    }

    public void moveToEnd() {
        this.doc.moveCursorAbs(this.doc.lineAt(this.doc.size() - 1).size(), this.doc.size() - 1);
    }

    public void moveToHome() {
        this.doc.moveCursorAbs(0, 0);
    }

    public void insertIndent() {
        this.doc.insertTab();
    }

    public String constructWhiteSpace(int col) {
        return this.doc.constructSpace(col).toString();
    }

    public int computeScreenColumn(int col, int line) {
        return this.doc.lineAt(line).translateX(col);
    }

    public void unInsertIndent() {
        this.doc.unInsertTab();
    }

    public void deleteLine(int line) {
        this.doc.remLineAt(line);
    }

    public void deleteCharLeft() {
        this.doc.deleteBackward();
    }

    public void deleteCharRight() {
        this.doc.deleteForward();
    }

    public void insertLine(String line) {
        this.doc.addLineAt(this.doc.cY(), new AttributedTextLine(line));
    }

    public void insertLine(String line, int index) {
        this.doc.addLineAt(index, new AttributedTextLine(line));
    }

    public void hilightAll() {
        this.doc.highlightAll();
    }

    public void hilightLine(int index) {
        this.doc.highLightLine(index);
    }

    public void setLine(String line, int index) {
        this.doc.remLineAt(index);
        this.doc.addLineAt(index, new AttributedTextLine(line));
    }

    public void insertString(String s) {
        this.doc.insertAndMove(s);
    }

    public void save(File f) throws Exception {
        this.doc.save(f);
    }

    public void load(File f) {
        this.doc.load(f);
    }

    public File getFile() {
        return this.doc.getFile();
    }

    public int getCursorCol() {
        return this.doc.cX();
    }

    public int getCursorLine() {
        return this.doc.cY();
    }

    public void moveCursorAbsolute(int x, int y, boolean doScroll) {
        if (doScroll) {
            this.doc.moveCursorAbs(x, y);
        } else {
            this.doc.moveCursorNoScroll(x, y);
        }
    }

    public void repaint() {
        this.doc.repaintAll();
    }

    public void lockUpdate(boolean b) {
        this.doc.lockUpdate(b);
    }

    public void centerLine(int line) {
        this.doc.centerPosition(line);
    }

    public char getCharacter(int col, int line) {
        return this.doc.charAt(col, line);
    }
}

