/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.ajp.tomcat4.Ajp13Connector;
import org.apache.ajp.tomcat4.Ajp13Logger;
import org.apache.ajp.tomcat4.Ajp13Principal;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.BaseRequest;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public class Ajp13Request
extends HttpRequestBase {
    private static final String match = ";jsessionid=";
    private static int id = 1;
    private Ajp13Logger logger = new Ajp13Logger();
    private int debug;

    public Ajp13Request(Ajp13Connector connector) {
        this.debug = connector.getDebug();
        this.logger.setConnector(connector);
        this.logger.setName("Ajp13Request[" + id++ + "]");
    }

    private void addCookies(Cookies cookies) {
        int ncookies = cookies.getCookieCount();
        int j = 0;
        while (j < ncookies) {
            ServerCookie scookie = cookies.getCookie(j);
            Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
            if (cookie.getName().equals("JSESSIONID") && !this.isRequestedSessionIdFromCookie()) {
                this.setRequestedSessionId(cookie.getValue());
                this.setRequestedSessionCookie(true);
                this.setRequestedSessionURL(false);
                if (this.debug > 0) {
                    this.logger.log(" Requested cookie session id is " + ((HttpServletRequest)this.getRequest()).getRequestedSessionId());
                }
            }
            if (this.debug > 0) {
                this.logger.log(" Adding cookie " + cookie.getName() + "=" + cookie.getValue());
            }
            this.addCookie(cookie);
            ++j;
        }
    }

    public ServletInputStream createInputStream() throws IOException {
        return (ServletInputStream)this.getStream();
    }

    public void recycle() {
        super.recycle();
    }

    void setAjpRequest(BaseRequest ajp) throws UnsupportedEncodingException {
        this.setMethod(ajp.method().toString());
        this.setProtocol(ajp.protocol().toString());
        this.setRequestURI(ajp.requestURI().toString());
        this.setRemoteAddr(ajp.remoteAddr().toString());
        this.setRemoteHost(ajp.remoteHost().toString());
        this.setServerName(ajp.serverName().toString());
        this.setServerPort(ajp.getServerPort());
        String remoteUser = ajp.remoteUser().toString();
        if (remoteUser != null) {
            this.setUserPrincipal(new Ajp13Principal(remoteUser));
        }
        this.setAuthType(ajp.authType().toString());
        this.setAuthorization(ajp.authorization().toString());
        this.setQueryString(ajp.queryString().toString());
        this.setScheme(ajp.getScheme());
        this.setSecure(ajp.getSecure());
        this.setContentLength(ajp.getContentLength());
        String contentType = ajp.contentType().toString();
        if (contentType != null) {
            this.setContentType(contentType);
        }
        MimeHeaders mheaders = ajp.headers();
        int nheaders = mheaders.size();
        int i = 0;
        while (i < nheaders) {
            MessageBytes name = mheaders.getName(i);
            MessageBytes value = mheaders.getValue(i);
            this.addHeader(name.toString(), value.toString());
            ++i;
        }
        Iterator itr = ajp.getAttributeNames();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            this.setAttribute(name, ajp.getAttribute(name));
        }
        this.addCookies(ajp.cookies());
    }

    public void setRequestURI(String uri) {
        int semicolon = uri.indexOf(match);
        if (semicolon >= 0) {
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(";");
            if (semicolon2 >= 0) {
                this.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                this.setRequestedSessionId(rest);
                rest = "";
            }
            this.setRequestedSessionURL(true);
            uri = String.valueOf(uri.substring(0, semicolon)) + rest;
            if (this.debug >= 1) {
                this.logger.log(" Requested URL session id is " + ((HttpServletRequest)this.getRequest()).getRequestedSessionId());
            }
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
        super.setRequestURI(uri);
    }
}

