/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.examplebeans.fontchooser;

import de.netcomputing.examplebeans.fontchooser.NCFontChooserBeanGUI;
import de.netcomputing.examplebeans.fontchooser.NCFontChooserEvent;
import de.netcomputing.examplebeans.fontchooser.NCFontChooserListener;
import de.netcomputing.examplebeans.labelslider.NCLabeledSlider;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;

public class NCFontChooserBean
extends JPanel {
    NCLabeledSlider slider;
    JToggleButton italicBtn;
    JToggleButton boldButton;
    JComboBox fontsBox;
    String mySampleProperty = "Sample";
    Vector fontListeners = new Vector(7);

    public NCFontChooserBean() {
        this.initGui();
    }

    public void initGui() {
        new NCFontChooserBeanGUI().createGui(this);
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        int n = 0;
        while (n < fonts.length) {
            this.fontsBox.addItem(fonts[n]);
            ++n;
        }
    }

    public void addNCFontChooserListener(NCFontChooserListener l) {
        this.fontListeners.addElement(l);
    }

    public void removeNCFontChooserListener(NCFontChooserListener l) {
        this.fontListeners.removeElement(l);
    }

    public void fireNCFontChooserEvent() {
        NCFontChooserEvent e = new NCFontChooserEvent(this);
        int n = 0;
        while (n < this.fontListeners.size()) {
            ((NCFontChooserListener)this.fontListeners.elementAt(n)).fontChanged(e);
            ++n;
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void setMySampleProperty(String mySampleProperty) {
        this.mySampleProperty = mySampleProperty;
    }

    public String getMySampleProperty() {
        return this.mySampleProperty;
    }

    public Font getSelectedFont() {
        return new Font("" + this.fontsBox.getSelectedItem(), (this.boldButton.isSelected() ? 1 : 0) | (this.italicBtn.isSelected() ? 2 : 0), this.slider.getValue());
    }

    public void setSelectedFont(Font f) {
        this.fontsBox.setSelectedItem(f.getName());
        this.boldButton.setSelected(f.isBold());
        this.italicBtn.setSelected(f.isItalic());
        this.slider.setValue(f.getSize());
    }

    public void slider_stateChanged(ChangeEvent var0) {
        this.fireNCFontChooserEvent();
    }

    public void fontsBox_itemStateChanged(ItemEvent var0) {
        this.fireNCFontChooserEvent();
    }

    public void italicBtn_actionPerformed(ActionEvent var0) {
        this.fireNCFontChooserEvent();
    }

    public void boldButton_actionPerformed(ActionEvent var0) {
        this.fireNCFontChooserEvent();
    }
}

