/*
 * Decompiled with CFR 0.152.
 */
package Jack;

import Jack.Acceptor;
import Jack.AcceptorNode;
import Jack.ErrorHandler;
import Jack.InputObject;
import Jack.JackInputStream;
import Jack.RLGrammar;
import de.netcomputing.util.Tracer;
import java.io.Serializable;

public class Scanner
extends JackInputStream
implements Serializable {
    static final long serialVersionUID = 7162625886634845065L;
    transient JackInputStream input;
    transient ErrorHandler errorHandler;
    Acceptor acc;

    Scanner() {
    }

    public Scanner(String[][] rules, ErrorHandler err) {
        RLGrammar g = new RLGrammar();
        int n = 0;
        while (n < rules.length) {
            g.addOredRules(rules[n]);
            ++n;
        }
        this.acc = g.buildAcceptor();
        this.errorHandler = err;
    }

    public Scanner(RLGrammar g, ErrorHandler err) {
        this.acc = g.buildAcceptor();
        this.errorHandler = err;
    }

    public void setErrorHandler(ErrorHandler err) {
        this.errorHandler = err;
    }

    public int primitiveRead() {
        int[] le = new int[]{0};
        AcceptorNode an = this.acc.matchTokenFrom(this.input, le);
        if (an == null) {
            this.errorHandler.scannerError(this, this.input);
            return InputObject.NOINPUT.getIntVal();
        }
        return an.id;
    }

    public InputObject read() {
        AcceptorNode an = null;
        int[] le = new int[]{0};
        an = this.acc.matchTokenFrom(this.input, le);
        if (an == null) {
            this.errorHandler.scannerError(this, this.input);
            return InputObject.NOINPUT;
        }
        if (le[0] == 0) {
            InputObject[] result = new InputObject[le[0]];
            int n = 0;
            while (n < le[0]) {
                result[n] = this.input.read();
                ++n;
            }
            return new InputObject(an.id, result);
        }
        InputObject res = this.input.read();
        if (res.myString == null || res.myString.length < le[0]) {
            byte[] buf = new byte[le[0]];
            res.myString = buf;
        }
        res.myString[0] = (byte)res.i;
        res.i = an.id;
        int n = 1;
        while (n < le[0]) {
            res.myString[n] = (byte)this.input.primitiveRead();
            ++n;
        }
        res.myStringUsage = le[0];
        return res;
    }

    public String symbolFor(int id) {
        return (String)this.acc.idToString.get(new Integer(id));
    }

    public int idFor(String symbol) {
        Integer res = (Integer)this.acc.stringToId.get(symbol);
        if (res == null) {
            return -1;
        }
        return res;
    }

    public void setInput(JackInputStream jis) {
        this.input = jis;
        this.errorHandler.reset();
    }

    public int idBase() {
        return this.acc.idBase;
    }

    public void pushBack(int n) {
        Tracer.This.println("don't call pushback on Scanner");
        System.exit(-1);
    }

    public int position() {
        return this.input.position();
    }

    public int filePosition() {
        return this.input.filePosition();
    }

    public int linePosition() {
        return this.input.linePosition();
    }

    public int colPosition() {
        return this.input.linePosition();
    }
}

