/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import Jxe.AttributedTextLine;
import Jxe.CharAttr;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.JWColor;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class CollapsedTextLine
extends AttributedTextLine {
    ArrayList collapsed = new ArrayList(3);

    public static CollapsedTextLine Collapse(TextDocument doc, int from, int to) {
        if (to - from <= 1) {
            return null;
        }
        CollapsedTextLine res = doc.lineAt(from).createCopyCollapsed();
        res.collapse(doc, from, to);
        doc.setLineWithoutUndo(from, res);
        return res;
    }

    public CollapsedTextLine() {
    }

    public CollapsedTextLine(byte[] b, int offset, int length) {
        super(b, offset, length);
    }

    public CollapsedTextLine(StringBuffer s) {
        super(s);
    }

    public CollapsedTextLine(String s) {
        super(s);
    }

    public int drawOn(Graphics g, int pixY, int start, int end, int startInverse, int endInverse, CharAttr[] styles, int charW, int charH, int maxAsc, TextDocument doc, int[] charWidth, int docIndex) {
        int pixX = super.drawOn(g, pixY, start, end, startInverse, endInverse, styles, charW, charH, maxAsc, doc, charWidth, docIndex);
        Color lineCol = JWColor.For("popup.bg");
        g.setColor(lineCol);
        int xo = pixX;
        String li = "[..]";
        int fontW = g.getFontMetrics().stringWidth(li);
        int finalX = xo;
        g.fillRect(finalX, pixY - maxAsc, fontW, charH);
        g.setColor(Color.black);
        g.drawString(li, finalX, pixY);
        return pixX;
    }

    public void collapse(TextDocument doc, int from, int to) {
        int i = from + 1;
        while (i < to) {
            this.collapsed.add(doc.lineAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < to - from - 1) {
            doc.remLineWithoutUndoAt(from + 1);
            ++i2;
        }
    }

    public void expand(TextDocument doc, int from) {
        int i = this.collapsed.size() - 1;
        while (i >= 0) {
            doc.addLineWithoutUndoAt(from + 1, (AttributedTextLine)this.collapsed.get(i));
            --i;
        }
        this.collapsed.clear();
        AttributedTextLine line = this.createCopy();
        doc.setLineWithoutUndo(from, line);
    }
}

