/*
 * Decompiled with CFR 0.152.
 */
package Jxe.highlighters;

import Jxe.ISyntaxHighlighter;
import Jxe.TextDocument;
import de.netcomputing.util.Tracer;

public class BasicHilighter {
    TextDocument td;
    ISyntaxHighlighter symbolKnower;
    int initialX;
    int initialY;
    public final String[] keywords = new String[]{"double", "boolean", "byte", "int", "short", "void", "long", "char", "float", "volatile", "native", "abstract", "transient", "synchronized", "final", "static", "private", "protected", "public", "class", "interface", "extends", "implements", "throws", "package", "import", "default", "if", "throw", "do", "break", "else", "return", "try", "case", "catch", "finally", "super", "while", "switch", "const", "for", "continue", "goto", "this", "new", "instanceof"};
    protected Object[] scanbase = null;
    protected Object[] defaultTab;
    int bigCnt;
    int smallCnt;
    protected int[] infoBuffer = new int[1024];

    public Object[] newBigNode(Object next) {
        Object[] node = new Object[256];
        if (next != null) {
            this.fillScanNode(node, next);
        }
        ++this.bigCnt;
        return node;
    }

    public Object[] newSmallNode(int style, Object next, String str) {
        Object[] node = new Object[]{new Integer(style), next, str};
        ++this.smallCnt;
        return node;
    }

    public void fillScanNode(Object[] node, Object obj) {
        int idx = 0;
        while (idx < node.length) {
            node[idx] = obj;
            ++idx;
        }
    }

    public void fillScanNodeSpace(Object[] node, Object obj) {
        node[32] = obj;
        node[9] = obj;
        node[12] = obj;
        node[10] = obj;
        node[13] = obj;
    }

    public void fillScanNodeJavaLoD(Object[] node, Object obj, Object def) {
        int idx = 0;
        while (idx < node.length) {
            node[idx] = Character.isJavaLetterOrDigit((char)idx) ? obj : (def != null ? def : node[idx]);
            ++idx;
        }
    }

    public void fillScanNodeDigits(Object[] node, int cnt, Object obj) {
        int idx = 0;
        while (idx < cnt && idx < 10) {
            node[48 + idx] = obj;
            ++idx;
        }
        int idx2 = 10;
        while (idx2 < cnt && idx2 < 36) {
            Object object = obj;
            node[87 + idx2] = object;
            node[55 + idx2] = object;
            ++idx2;
        }
    }

    public boolean insertIdentifierToken(Object[] base, Object[] empty, Object[] back, String str, int style, int baseStyle) {
        Object[] tab = null;
        Object[] last = base;
        int idx = 0;
        while (idx < str.length()) {
            char b = str.charAt(idx);
            tab = (Object[])last[b];
            if (idx == 0) {
                if (tab.length > 10 || tab[1] == empty) {
                    tab = this.newSmallNode(baseStyle | 0x1000, this.newBigNode(null), "token entry: " + str);
                    this.fillScanNodeJavaLoD((Object[])tab[1], empty, back);
                    last[b] = tab;
                } else {
                    tab[2] = (String)tab[2] + ", " + str;
                }
                tab = (Object[])tab[1];
            }
            if (tab == empty) {
                tab = this.newBigNode(null);
                this.fillScanNodeJavaLoD(tab, empty, back);
                last[b] = tab;
            } else if (tab.length < 10 && idx > 0) {
                Tracer.This.println("identifier token collision for: " + str);
                return false;
            }
            last = tab;
            ++idx;
        }
        if (last != base) {
            tab = this.newSmallNode(style | 0x3000, base, "token exit: " + str);
            this.fillScanNodeJavaLoD(last, empty, tab);
        }
        return false;
    }

    public void insertJavaStringToken(Object[] base, Object[] back, int style, int baseStyle) {
        Object[] sna = this.newBigNode(null);
        Object[] snb = this.newBigNode(null);
        Object[] snc = this.newBigNode(null);
        Object[] snd = this.newBigNode(null);
        Object[] sne = this.newBigNode(null);
        Object[] snf = this.newBigNode(null);
        Object[] sng = this.newBigNode(null);
        Object[] snh = this.newBigNode(null);
        Object[] entry = this.newSmallNode(baseStyle | 0x1000, sna, "string token entry ");
        Object[] exit = this.newSmallNode(style, base, "string token exit ");
        base[34] = entry;
        this.fillScanNode(sna, sna);
        sna[34] = exit;
        sna[10] = back;
        sna[92] = snb;
        this.fillScanNode(snb, back);
        this.fillScanNodeDigits(snb, 8, snd);
        this.fillScanNodeDigits(snb, 4, snc);
        snb[98] = sna;
        snb[116] = sna;
        snb[110] = sna;
        snb[102] = sna;
        snb[114] = sna;
        snb[34] = sna;
        snb[39] = sna;
        snb[92] = sna;
        snb[117] = sne;
        this.fillScanNode(snc, sna);
        this.fillScanNodeDigits(snc, 8, snd);
        snc[10] = back;
        snc[34] = exit;
        this.fillScanNode(snd, sna);
        snd[10] = back;
        snd[34] = exit;
        this.fillScanNode(sne, back);
        this.fillScanNodeDigits(sne, 16, snf);
        this.fillScanNode(snf, back);
        this.fillScanNodeDigits(snf, 16, sng);
        this.fillScanNode(sng, back);
        this.fillScanNodeDigits(sng, 16, snh);
        this.fillScanNode(snh, back);
        this.fillScanNodeDigits(snh, 16, sna);
    }

    public void insertJavaCharacterToken(Object[] base, Object[] back, int style, int baseStyle) {
        Object[] sna = this.newBigNode(null);
        Object[] snb = this.newBigNode(null);
        Object[] snc = this.newBigNode(null);
        Object[] snd = this.newBigNode(null);
        Object[] sne = this.newBigNode(null);
        Object[] snf = this.newBigNode(null);
        Object[] sng = this.newBigNode(null);
        Object[] snh = this.newBigNode(null);
        Object[] sni = this.newBigNode(null);
        Object[] entry = this.newSmallNode(baseStyle | 0x1000, sna, "character token entry " + Integer.toHexString(style));
        Object[] exit = this.newSmallNode(style, base, "character token exit " + Integer.toHexString(style));
        base[39] = entry;
        this.fillScanNode(sna, sne);
        sna[39] = back;
        sna[10] = back;
        sna[92] = snb;
        this.fillScanNode(snb, back);
        this.fillScanNodeDigits(snb, 8, snd);
        this.fillScanNodeDigits(snb, 4, snc);
        snb[98] = sne;
        snb[116] = sne;
        snb[110] = sne;
        snb[102] = sne;
        snb[114] = sne;
        snb[34] = sne;
        snb[39] = sne;
        snb[92] = sne;
        snb[117] = snf;
        this.fillScanNode(snc, back);
        this.fillScanNodeDigits(snc, 8, snd);
        snc[39] = exit;
        this.fillScanNode(snd, back);
        this.fillScanNodeDigits(snd, 8, sne);
        snd[39] = exit;
        this.fillScanNode(sne, back);
        sne[39] = exit;
        this.fillScanNode(snf, back);
        this.fillScanNodeDigits(snf, 16, sng);
        this.fillScanNode(sng, back);
        this.fillScanNodeDigits(sng, 16, snh);
        this.fillScanNode(snh, back);
        this.fillScanNodeDigits(snh, 16, sna);
        this.fillScanNode(sni, back);
        this.fillScanNodeDigits(sni, 16, sne);
    }

    public void insertJavaCommentToken(Object[] base, Object[] back, int style, int docStyle, int docKeyStyle, int baseStyle) {
        Object[] sna = this.newBigNode(null);
        Object[] snb = this.newBigNode(null);
        Object[] snc = this.newBigNode(null);
        Object[] snd = this.newBigNode(null);
        Object[] sne = this.newBigNode(null);
        Object[] snf = this.newBigNode(null);
        Object[] sng = this.newBigNode(null);
        Object[] snh = this.newBigNode(null);
        Object[] sni = this.newBigNode(null);
        Object[] entry = this.newSmallNode(baseStyle | 0x1000, sna, "comment token entry ");
        Object[] exit = this.newSmallNode(style, base, "comment token exit ");
        Object[] docExit = this.newSmallNode(docStyle, base, "javadoc comment token exit ");
        Object[] docKeyEntry = this.newSmallNode(docStyle | 0x1000, sng, "javadoc comment keyword token entry ");
        Object[] docKeyExit = this.newSmallNode(docKeyStyle | 0x3000, sne, "javadoc comment keyword token exit ");
        base[47] = entry;
        this.fillScanNode(sna, back);
        sna[47] = snb;
        sna[42] = snc;
        this.fillScanNode(snb, snb);
        snb[10] = exit;
        this.fillScanNode(snc, snh);
        snc[42] = snd;
        this.fillScanNode(snd, sne);
        snd[42] = snd;
        snd[47] = exit;
        this.fillScanNode(sne, sne);
        sne[42] = snf;
        sne[64] = docKeyEntry;
        this.fillScanNode(snf, sne);
        snf[42] = snf;
        snf[47] = docExit;
        this.fillScanNodeJavaLoD(sng, sng, docKeyExit);
        sng[42] = snf;
        this.fillScanNode(snh, snh);
        snh[42] = sni;
        this.fillScanNode(sni, snh);
        sni[42] = sni;
        sni[47] = exit;
    }

    public void insertJavaNumericToken(Object[] base, Object[] back, Object[] miss, int intStyle, int longStyle, int floatStyle, int doubleStyle, int baseStyle) {
        Object[] sna = this.newBigNode(null);
        Object[] snb = this.newBigNode(null);
        Object[] snc = this.newBigNode(null);
        Object[] snd = this.newBigNode(null);
        Object[] sne = this.newBigNode(null);
        Object[] snf = this.newBigNode(null);
        Object[] sng = this.newBigNode(null);
        Object[] snh = this.newBigNode(null);
        Object[] sni = this.newBigNode(null);
        Object[] snj = this.newBigNode(null);
        Object[] octEntry = this.newSmallNode(baseStyle | 0x1000, sna, "numeric token entry ");
        Object[] numEntry = this.newSmallNode(baseStyle | 0x1000, sne, "numeric token entry ");
        Object[] dotEntry = this.newSmallNode(baseStyle | 0x1000, snj, "numeric token entry ");
        Object[] implIntExit = this.newSmallNode(intStyle | 0x3000, base, "(impl) integer token exit ");
        Object[] longExit = this.newSmallNode(longStyle, base, "long integer token exit ");
        Object[] floatExit = this.newSmallNode(floatStyle, base, "floating point token exit ");
        Object[] doubleExit = this.newSmallNode(doubleStyle, base, "double precision floating point token exit ");
        Object[] implDoubleExit = this.newSmallNode(doubleStyle | 0x3000, base, "(impl) double precision floating point token exit ");
        this.fillScanNodeDigits(base, 10, numEntry);
        base[48] = octEntry;
        base[46] = dotEntry;
        this.fillScanNodeJavaLoD(sna, back, implIntExit);
        this.fillScanNodeDigits(sna, 8, snb);
        sna[76] = longExit;
        sna[108] = longExit;
        sna[70] = floatExit;
        sna[102] = floatExit;
        sna[68] = doubleExit;
        sna[100] = doubleExit;
        sna[120] = snc;
        sna[69] = sng;
        sna[101] = sng;
        sna[46] = snf;
        this.fillScanNodeJavaLoD(snb, back, implIntExit);
        this.fillScanNodeDigits(snb, 8, snb);
        snb[76] = longExit;
        snb[108] = longExit;
        this.fillScanNode(snc, back);
        this.fillScanNodeDigits(snc, 16, snd);
        this.fillScanNodeJavaLoD(snd, back, implIntExit);
        this.fillScanNodeDigits(snd, 16, snd);
        snd[76] = longExit;
        snd[108] = longExit;
        this.fillScanNodeJavaLoD(sne, back, implIntExit);
        this.fillScanNodeDigits(sne, 10, sne);
        sne[76] = longExit;
        sne[108] = longExit;
        sne[70] = floatExit;
        sne[102] = floatExit;
        sne[68] = doubleExit;
        sne[100] = doubleExit;
        sne[69] = sng;
        sne[101] = sng;
        sne[46] = snf;
        this.fillScanNodeJavaLoD(snf, back, implDoubleExit);
        this.fillScanNodeDigits(snf, 10, snf);
        snf[70] = floatExit;
        snf[102] = floatExit;
        snf[68] = doubleExit;
        snf[100] = doubleExit;
        snf[69] = sng;
        snf[101] = sng;
        this.fillScanNode(sng, back);
        this.fillScanNodeDigits(sng, 10, sni);
        sng[43] = snh;
        sng[45] = snh;
        this.fillScanNode(snh, back);
        this.fillScanNodeDigits(snh, 10, sni);
        this.fillScanNodeJavaLoD(sni, back, implDoubleExit);
        this.fillScanNodeDigits(sni, 10, sni);
        sni[70] = floatExit;
        sni[102] = floatExit;
        sni[68] = doubleExit;
        sni[100] = doubleExit;
        this.fillScanNode(snj, miss);
        this.fillScanNodeDigits(snj, 10, snf);
    }

    public void createScanbase() {
        this.smallCnt = 0;
        this.bigCnt = 0;
        this.scanbase = this.newBigNode(null);
        Object[] emptyID = this.newBigNode(null);
        Object[] space = this.newBigNode(null);
        this.defaultTab = this.newSmallNode(16384, this.scanbase, "default mismatch (no push back)");
        Object[] idEntry = this.newSmallNode(4096, emptyID, "unrecognized identifier entry");
        Object[] idExit = this.newSmallNode(12294, this.scanbase, "unrecognized identifier exit");
        Object[] methodExit = this.newSmallNode(12290, this.scanbase, "method identifier exit");
        Object[] errorTab = this.newSmallNode(10, this.scanbase, "error mismatch (no push back)");
        Object[] defaultPbTab = this.newSmallNode(28672, this.scanbase, "default mismatch (with push back)");
        this.fillScanNodeJavaLoD(this.scanbase, idEntry, this.scanbase);
        this.fillScanNodeJavaLoD(emptyID, emptyID, idExit);
        this.fillScanNodeSpace(emptyID, space);
        emptyID[40] = methodExit;
        this.fillScanNode(space, idExit);
        space[40] = methodExit;
        this.insertJavaStringToken(this.scanbase, errorTab, 7, 0);
        this.insertJavaCharacterToken(this.scanbase, errorTab, 8, 0);
        this.insertJavaNumericToken(this.scanbase, errorTab, defaultPbTab, 3, 3, 3, 3, 0);
        this.insertIdentifierToken(this.scanbase, emptyID, idExit, "null", 4, 0);
        this.insertIdentifierToken(this.scanbase, emptyID, idExit, "true", 4, 0);
        this.insertIdentifierToken(this.scanbase, emptyID, idExit, "false", 4, 0);
        this.insertJavaCommentToken(this.scanbase, this.defaultTab, 5, 9, 4, 0);
        String[] keywords = this.getKeywords();
        int idx = 0;
        while (idx < keywords.length) {
            this.insertIdentifierToken(this.scanbase, emptyID, idExit, keywords[idx], 4, 0);
            ++idx;
        }
    }

    public int rawCreateJavaInfo(int from, int to) {
        return 0;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public BasicHilighter(TextDocument td, ISyntaxHighlighter _ish, int posX, int posY) {
        this.init(td, _ish, posX, posY);
    }

    public void init(TextDocument td, ISyntaxHighlighter _ish, int posX, int posY) {
        this.td = td;
        this.symbolKnower = _ish;
        this.initialX = posX;
        this.initialY = posY;
        if (this.initialX != 0 || this.initialY != 0) {
            Tracer.This.println("\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6\u00f6");
        }
    }

    public void processChange(int y, int yend, int length, boolean insert, boolean update) {
        int maxUpdate = this.rawCreateJavaInfo(y, yend + 1);
        if (update && this.td.getView() != this.td) {
            this.td.getView().updateView(y, maxUpdate + 1, 0, 1024);
        }
    }

    public void run() {
        throw new RuntimeException("deprecated");
    }

    public void start() {
        throw new RuntimeException("deprecated");
    }

    public void start(int x, int y) {
        throw new RuntimeException("deprecated");
    }

    public void startNewInstance(int x, int y) {
        this.rawCreateJavaInfo(0, this.td.size());
    }
}

