/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.JArray;
import JCollections.JOrderedCollection;
import de.netcomputing.anyj.AJFindTypeGUI;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AJFindType
extends NCPanel {
    NCButton browseBtn;
    NCButton browseFileBtn;
    JButton cancelBtn;
    JButton openBtn;
    NCTreeBean resList;
    JLabel titleLabel;
    JTextArea subTxt;
    JTextField searchTxt;
    boolean[] doStop;
    Thread searcher;

    public static void Open() {
        JDialog dg = new JDialog(EditApp.App.getMainWindow(), "Open Type", false);
        AJFindType ft = new AJFindType();
        dg.getContentPane().add(ft);
        dg.pack();
        JWidgetsUtil.CenterWindow(dg);
        dg.setDefaultCloseOperation(2);
        ft.getRootPane().setDefaultButton(ft.openBtn);
        ft.initWinListener();
        dg.show();
    }

    public AJFindType() {
        this.initGui();
        this.browseBtn.setMnemonic('c');
        this.browseFileBtn.setMnemonic('f');
        this.searchTxt.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                AJFindType.this.searchChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                AJFindType.this.searchChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                AJFindType.this.searchChanged();
            }
        });
        this.resList.binder().addTarget(this, "actionLClick");
        this.resList.binderDoubleClick().addTarget(this, "actionDClick");
        this.searchTxt.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    AJFindType.this.openBtn_actionPerformed(null);
                }
                if (ke.getKeyCode() == 40) {
                    AJFindType.this.resList.actionDown(null, null);
                }
                if (ke.getKeyCode() == 38) {
                    AJFindType.this.resList.actionUp(null, null);
                }
            }
        });
        this.openBtn.setEnabled(false);
        this.browseBtn.setEnabled(false);
        this.browseFileBtn.setEnabled(false);
    }

    public void initWinListener() {
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ((Window)AJFindType.this.getTopLevelAncestor()).dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public Object actionLClick(Object sen, Object arg) {
        this.openBtn.setEnabled(this.resList.getSelectedItem() != null);
        this.browseBtn.setEnabled(this.openBtn.isEnabled());
        this.browseFileBtn.setEnabled(this.openBtn.isEnabled());
        return null;
    }

    public Object actionDClick(Object sen, Object arg) {
        this.openBtn_actionPerformed(null);
        return null;
    }

    public void searchChanged() {
        if (this.searcher != null) {
            this.doStop[0] = true;
        }
        final boolean[] stop = this.doStop = new boolean[]{false};
        final String toSearch = this.searchTxt.getText();
        this.searcher = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String s = toSearch.trim();
                    AJFindType.this.resList.clear();
                    AJFindType.this.resList.setEnabled(false);
                    if (s.length() == 0) return;
                    if (s.equals("*")) return;
                    if (s.equals("**")) return;
                    if (s.equals("***")) return;
                    if (s.equals("****")) return;
                    if (s.equals("*****")) {
                        return;
                    }
                    s = NCStringUtilities.PrepareRegExp(s);
                    AJFindType.this.subTxt.setText("Use * as wildcard. [Current Expression:" + s + "]");
                    Pattern p = Pattern.compile(s, 2);
                    JOrderedCollection arr = AJFindType.this.getListToSearch();
                    JArray res = new JArray(arr.size());
                    int i = 0;
                    while (true) {
                        if (i >= arr.size()) {
                            res.sort();
                            AJFindType aJFindType = AJFindType.this;
                            synchronized (aJFindType) {
                                if (!stop[0]) break;
                            }
                            return;
                        }
                        if (stop[0]) {
                            return;
                        }
                        IndexEntry ie = (IndexEntry)arr.get(i);
                        String cls = AJFindType.this.getStringToMatch(ie);
                        if (cls != null && p.matcher(cls).matches()) {
                            res.add(ie);
                        }
                        ++i;
                    }
                    {
                        int i2 = 0;
                        while (true) {
                            if (i2 >= res.size()) {
                                if (AJFindType.this.resList.listSize() > 0) {
                                    AJFindType.this.resList.setSelectionIndex(0);
                                }
                                AJFindType.this.actionLClick(null, null);
                                AJFindType.this.resList.setEnabled(true);
                                AJFindType.this.resList.repaint();
                                AJFindType.this.searcher = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 10] lbl47 : MonitorExitStatement: MONITOREXIT : var6_11
                                return;
                            }
                            AJFindType.this.resList.addLine(res.get(i2));
                            ++i2;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_6 = null;
                    throw throwable;
                }
            }
        };
        this.searcher.start();
    }

    protected String getStringToMatch(IndexEntry ie) {
        String cls = ie.realClassName();
        return cls;
    }

    protected JOrderedCollection getListToSearch() {
        return SourceBase.This().getClassDefs();
    }

    public void initGui() {
        new AJFindTypeGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void browseFileBtn_actionPerformed(ActionEvent var0) {
        if (this.resList.getSelectedObject() != null) {
            ((Window)this.getTopLevelAncestor()).dispose();
            EditApp.App.browse(new File(((IndexEntry)this.resList.getSelectedObject()).fileString()));
        }
    }

    public void browseBtn_actionPerformed(ActionEvent var0) {
        if (this.resList.getSelectedObject() != null) {
            ((Window)this.getTopLevelAncestor()).dispose();
            EditApp.App.browse((IndexEntry)this.resList.getSelectedObject());
        }
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void openBtn_actionPerformed(ActionEvent var0) {
        if (this.resList.getSelectedObject() != null) {
            ((Window)this.getTopLevelAncestor()).dispose();
            EditApp.App.openOrShow((IndexEntry)this.resList.getSelectedObject());
        }
    }
}

