/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJFindPanel;
import de.netcomputing.anyj.AJSemanticFindGUI;
import de.netcomputing.anyj.application.SearchResultItem;
import de.netcomputing.anyj.parsing.FindSpec;
import de.netcomputing.anyj.parsing.SyntaxAnalyzer;
import de.netcomputing.anyj.parsing.SyntaxSearch;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.SourceBase;
import java.awt.Image;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;

public class AJSemanticFind
extends AJFindPanel {
    JCheckBox methodDeclChk;
    JCheckBox declfChk;
    JCheckBox varAsgnChk;
    JCheckBox varUsageChk;
    JCheckBox methCallChk;
    JCheckBox conCallChk;
    JCheckBox classRefChk;

    public void initGui() {
        new AJSemanticFindGUI().createGui(this);
        super.init();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void setSearchText(String s) {
        super.setSearchText(s);
        if (SourceBase.This().isClass(s)) {
            this.conCallChk.setSelected(true);
            return;
        }
        if (SourceBase.This().isMethodIdentifier(s)) {
            this.methCallChk.setSelected(true);
        } else if (SourceBase.This().isInstanceVarIdentifier(s)) {
            this.varAsgnChk.setSelected(true);
        } else {
            this.methodDeclChk.setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void internalRun() {
        Vector result = new Vector(50);
        this.resTree.clear();
        this.setButtonState(false);
        this.toSearch = this.searchField.getText();
        try {
            try {
                this.enableGUI(false);
                HashSet fileSet = SyntaxAnalyzer.FindString(this.txtField.getText(), this.toSearch, this.recurseChk.isPressed(), true);
                SyntaxSearch parser = new SyntaxSearch();
                FindSpec spec = new FindSpec();
                if (this.methodDeclChk != null) {
                    spec.methodDecl = this.methodDeclChk.isSelected();
                }
                if (this.classRefChk != null) {
                    spec.classRef = this.classRefChk.isSelected();
                }
                if (this.conCallChk != null) {
                    spec.constrCall = this.conCallChk.isSelected();
                }
                if (this.declfChk != null) {
                    spec.fieldDeclaration = this.declfChk.isSelected();
                }
                if (this.methCallChk != null) {
                    spec.methodCall = this.methCallChk.isSelected();
                }
                if (this.varAsgnChk != null) {
                    spec.varAsgn = this.varAsgnChk.isSelected();
                }
                if (this.varUsageChk != null) {
                    spec.varUsage = this.varUsageChk.isSelected();
                }
                spec.setToFind(this.toSearch);
                Iterator it = fileSet.iterator();
                int cnt = 0;
                while (it.hasNext()) {
                    this.resultLabel.setText("parsing " + ++cnt + " of " + fileSet.size() + " files ..");
                    parser.findSpec((String)it.next(), result, spec);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var8_9 = null;
                this.enableGUI(true);
                this.searchFinished(result);
                this.resTree.repaint();
                this.setLabels();
                this.setButtonState(true);
                this.thread = null;
                if (this.runAfterSearch == null) return;
                this.runAfterSearch.run();
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.enableGUI(true);
            this.searchFinished(result);
            this.resTree.repaint();
            this.setLabels();
            this.setButtonState(true);
            this.thread = null;
            if (this.runAfterSearch == null) throw throwable;
            this.runAfterSearch.run();
            throw throwable;
        }
        this.enableGUI(true);
        this.searchFinished(result);
        this.resTree.repaint();
        this.setLabels();
        this.setButtonState(true);
        this.thread = null;
        if (this.runAfterSearch == null) return;
        this.runAfterSearch.run();
    }

    protected void searchFinished(Vector result) {
        HashSet<String> filter = new HashSet<String>(result.size());
        int n = 0;
        while (n < result.size()) {
            String key;
            SearchResultItem item;
            Object[] resLine = (Object[])result.elementAt(n);
            if (resLine[0].toString().indexOf("Parse Error") >= 0) {
                item = new SearchResultItem((String)resLine[2], (Integer)resLine[4], (Integer)resLine[5], (Integer)resLine[4], (Integer)resLine[5], "(!) File contains Syntax Errors, ignored", "undefined");
                item.setIsError(true);
                item.setIsSel(false);
                key = item.getFile() + "#" + item.getLineStart() + "#" + item.getColStart();
                if (!filter.contains(key)) {
                    this.resTree.addItem(item);
                    filter.add(key);
                }
            } else {
                item = new SearchResultItem(resLine, this.toSearch.length(), this.toSearch);
                key = item.getFile() + "#" + item.getLineStart() + "#" + item.getColStart();
                if (!filter.contains(key)) {
                    this.resTree.addItem(item);
                    filter.add(key);
                }
            }
            ++n;
        }
    }
}

