/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.JOrderedCollection;
import JWVFile.VFile;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJSourceAssistantGUI;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.application.ICloseable;
import de.netcomputing.anyj.jwidgets.JWArrayTableModel;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTable;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.ClassTableModel;
import editapp.CodeGenerator;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JTabbedPane;

public class AJSourceAssistant
extends NCPanel
implements ICloseable {
    NCTable tableView;
    NCButton showBtn;
    NCTextField classTxt;
    NCCheckBox fieldsChk;
    NCCheckBox methodsChk;
    NCCheckBox privateChk;
    JTabbedPane cardPanel;
    NCTextField txtFld;
    NCCheckBox superChk;
    NCButton overrideBtn;
    NCCheckBox remFirstChk;
    NCCheckBox gettersChk;
    NCCheckBox settersChk;
    NCButton accessorBtn;
    TextDocument document;
    ClassTableModel tableModel;

    public void initGui() {
        new AJSourceAssistantGUI().createGui(this);
        this.init();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    TextDocument getDocument() {
        if (this.document == null) {
            this.document = EditFrame.Host().getCurrentEditFrame().getDocument();
        }
        return this.document;
    }

    public void init() {
        this.privateChk.addTarget(this, "actionFilterChanged");
        this.methodsChk.addTarget(this, "actionFilterChanged");
        this.fieldsChk.addTarget(this, "actionFilterChanged");
        this.classTxt.addKeyListener(new KeyFilter(10, this, "actionFilterChanged"));
        this.showBtn.addTarget(this, "actionFilterChanged");
        this.freeMem();
        this.classTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent k) {
                AJSourceAssistant.this.setEnableState();
            }
        });
        this.setEnableState();
        this.tableView.binderRowSelection().addTarget(this, "actionRowSelChanged");
        this.overrideBtn.addTarget(this, "actionOveride");
        this.accessorBtn.addTarget(this, "actionGenAccessor");
        this.remFirstChk.setSelected(false);
    }

    public Object actionRowSelChanged(Object arg, Object sen) {
        this.setEnableState();
        return null;
    }

    void setEnableState() {
        String clazz = this.classTxt.getText();
        if (SourceBase.This().isClass(clazz) && this.tableModel != null) {
            boolean b = this.fieldsChk.isPressed() && !this.methodsChk.isPressed();
            boolean sel = this.tableView.getRowSelection() >= 0;
            int[] sr = this.tableView.getRowSelections();
            if (sr == null) {
                sr = new int[]{};
            }
            boolean onlyFieldsSelected = sel;
            boolean onlyMethodsSelected = sel;
            JOrderedCollection sels = this.tableModel.getSelectedIndexEntries(sr);
            int n = 0;
            while (n < sels.size()) {
                if (((IndexEntry)sels.at(n)).isMethod()) {
                    onlyFieldsSelected = false;
                }
                if (((IndexEntry)sels.at(n)).isField()) {
                    onlyMethodsSelected = false;
                }
                ++n;
            }
            this.accessorBtn.setEnabled(onlyFieldsSelected);
            this.overrideBtn.setEnabled(onlyMethodsSelected);
            this.superChk.setEnabled(onlyMethodsSelected);
            this.txtFld.setEnabled(onlyMethodsSelected);
            this.showBtn.setEnabled(true);
        } else {
            this.accessorBtn.setEnabled(false);
            this.overrideBtn.setEnabled(false);
            this.superChk.setEnabled(false);
            this.txtFld.setEnabled(false);
            this.showBtn.setEnabled(SourceBase.This().isClass(clazz));
        }
    }

    public Object actionFilterChanged(Object a, Object s) {
        this.fillTable();
        this.setEnableState();
        return null;
    }

    public Object actionGenAccessor(Object arg, Object sen) {
        int[] sel = this.tableView.getRowSelections();
        if (sel.length > 0) {
            CodeGenerator.GenerateAccessors(this.tableModel.getSelectedIndexEntries(sel), this.getDocument(), this.settersChk.isSelected(), this.gettersChk.isSelected(), this.remFirstChk.isSelected());
        }
        return null;
    }

    public Object actionOveride(Object arg, Object sen) {
        int[] sel = this.tableView.getRowSelections();
        if (sel.length > 0) {
            CodeGenerator.GenerateFunctions(this.tableModel.getSelectedIndexEntries(sel), this.getDocument(), this.superChk.isPressed() ? this.txtFld.getText() : null);
        }
        return null;
    }

    int getFilter() {
        return (this.privateChk.isPressed() ? 0 : 2) | (this.methodsChk.isPressed() ? 0 : 1024) | (this.fieldsChk.isPressed() ? 0 : 2048) | 0x80;
    }

    void fillTable() {
        SourceBase sb = SourceBase.This();
        IndexEntry ieMain = null;
        if (this.getDocument() != null) {
            ieMain = sb.getPossibleClassDefFor(this.classTxt.getText(), this.getDocument().getFile().getAbsolutePath());
        }
        if (ieMain == null) {
            ieMain = sb.getPossibleClassDefFor(this.classTxt.getText(), null);
        }
        if (ieMain == null) {
            return;
        }
        IndexEntry[] line = sb.deriveLineFor(ieMain);
        this.tableView.clearRowSelections();
        try {
            this.cursorWait();
            boolean mustUpdate = false;
            int n = 0;
            while (n < line.length) {
                if (SourceBase.This().shouldUpdate(new File(line[n].fileString()))) {
                    mustUpdate = true;
                    break;
                }
                ++n;
            }
            if (mustUpdate) {
                int n2 = 0;
                while (n2 < line.length) {
                    SourceBase.This().update(line[n2].fileString());
                    ++n2;
                }
            }
            int filter = this.getFilter();
            this.tableModel = this.getDocument() != null ? new ClassTableModel(this.getDocument().getFile().getAbsolutePath(), this.classTxt.getText(), this.getFilter()) : new ClassTableModel(null, this.classTxt.getText(), this.getFilter());
            this.tableView.setModel(this.tableModel);
            this.tableView.fitColumnsToView(300);
            this.tableView.setHeaderMinWidth(150);
            this.tableView.repaintImmediate();
            this.setEnableState();
            this.cursorDefault();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cursorDefault();
    }

    public void setModelOveride(TextDocument _doc) {
        this.document = _doc;
        this.privateChk.setPressed(false);
        this.methodsChk.setPressed(true);
        this.fieldsChk.setPressed(false);
        String clazz = VFile.NameWithoutExtension(this.getDocument().getFile().getName());
        this.classTxt.setText(clazz);
        this.fillTable();
        this.cardPanel.setSelectedIndex(0);
    }

    public void setModelAccessor(TextDocument _doc) {
        this.document = _doc;
        this.privateChk.setPressed(true);
        this.methodsChk.setPressed(false);
        this.fieldsChk.setPressed(true);
        String clazz = VFile.NameWithoutExtension(this.getDocument().getFile().getName());
        this.classTxt.setText(clazz);
        this.fillTable();
        this.cardPanel.setSelectedIndex(1);
    }

    public void setModelInterface(TextDocument _doc, IndexEntry ie) {
        this.document = _doc;
        this.privateChk.setPressed(true);
        this.methodsChk.setPressed(true);
        this.fieldsChk.setPressed(false);
        String clazz = "Object";
        clazz = this.getDocument() != null && ie == null ? VFile.NameWithoutExtension(this.getDocument().getFile().getName()) : ie.realPackage() + "." + ie.realClassName();
        this.classTxt.setText(clazz);
        this.tableView.setModel(new JWArrayTableModel());
        if (ie != null) {
            this.fillTable();
        }
        this.cardPanel.setSelectedIndex(0);
    }

    static class FileItem {
        String fullPath;

        FileItem(String fi) {
            this.fullPath = fi;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof FileItem) {
                return ((FileItem)o).fullPath.equals(this.fullPath);
            }
            return o.toString().equals(this.fullPath);
        }

        public String toString() {
            return VFile.NameWithExtension(this.fullPath);
        }
    }
}

