/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import de.netcomputing.anyj.debugger.DebuggerItem;

public class FieldItem
extends DebuggerItem {
    Field field;
    ObjectReference val;
    Value cachedValue;
    String cachedDisplay;

    public FieldItem(Field ref, ObjectReference where) {
        this.field = ref;
        this.val = where;
    }

    protected Value getValue() {
        if (this.cachedValue == null) {
            try {
                this.cachedValue = this.val.getValue(this.field);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        return this.cachedValue;
    }

    public String getDisplayString() {
        try {
            if (this.cachedDisplay == null) {
                this.cachedDisplay = this.createDisplayString();
            }
            return this.cachedDisplay;
        }
        catch (Throwable ex) {
            return "invalid";
        }
    }

    public String createDisplayString() {
        try {
            return this.field.name() + " (" + this.field.typeName() + ") = " + this.val.getValue(this.field);
        }
        catch (Exception ex) {
            try {
                return this.field.name() + " (" + this.field.type().name() + ") = " + this.val.getValue(this.field);
            }
            catch (Exception ex1) {
                return "Exc:" + ex1.getClass().getName() + " " + ex1.getMessage();
            }
        }
    }

    public String getVarName() {
        return this.field.name();
    }
}

