/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.application.NCFrame;
import de.netcomputing.anyj.jwidgets.BorderingCanvas;
import de.netcomputing.anyj.jwidgets.JSplitLayout;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWOptions;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import netcomputing.tools.Platforms;

public class JTilerCanvas
extends BorderingCanvas {
    boolean popupEnabled = false;
    int sY;
    boolean isDown = false;
    boolean isHorizontal = true;
    boolean isIn = false;

    public JTilerCanvas() {
        ML ml = new ML();
        this.addMouseMotionListener(ml);
        this.addMouseListener(ml);
        this.setBackground(JWColor.For("background"));
        this.init();
    }

    public boolean wantsFocusTraversal() {
        return false;
    }

    public void jwPaint(Graphics g) {
        if (this.isDown || this.isIn) {
            g.setColor(JWColor.For("background.-"));
        } else {
            g.setColor(JWColor.For("background"));
        }
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.popupEnabled) {
            JWidgetsUtil.DrawButton(g, 52, 2, -2, JSplitLayout.tilerSize + 4, JSplitLayout.tilerSize + 4);
        }
    }

    public void setPopupEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public boolean getPopupEnabled() {
        return this.popupEnabled;
    }

    class ML
    extends MouseAdapter
    implements MouseMotionListener {
        ML() {
        }

        public void mouseMoved(MouseEvent e) {
            if (JTilerCanvas.this.isDown) {
                JTilerCanvas.this.isDown = false;
                JTilerCanvas.this.repaint();
            }
            if (!JTilerCanvas.this.popupEnabled) {
                return;
            }
            if (JWOptions.DO_SET_CURSOR && JTilerCanvas.this.getFrame() instanceof NCFrame && ((NCFrame)JTilerCanvas.this.getFrame()).isActive() && (e.getX() > 12 || e.getX() < 4)) {
                JTilerCanvas.this.setCursor(Cursor.getPredefinedCursor(JTilerCanvas.this.isHorizontal ? 8 : 10));
            } else {
                JTilerCanvas.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (JTilerCanvas.this.sY != (JTilerCanvas.this.isHorizontal ? e.getY() : e.getX())) {
                if (JTilerCanvas.this.isHorizontal) {
                    JTilerCanvas.this.setLocation(JTilerCanvas.this.getLocation().x, JTilerCanvas.this.getLocation().y + e.getY() - JTilerCanvas.this.sY);
                } else {
                    JTilerCanvas.this.setLocation(JTilerCanvas.this.getLocation().x + e.getX() - JTilerCanvas.this.sY, JTilerCanvas.this.getLocation().y);
                }
                JTilerCanvas.this.validate();
            }
            JTilerCanvas.this.repaint();
            if (Platforms.IsLinux()) {
                Toolkit.getDefaultToolkit().sync();
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (JWOptions.DO_SET_CURSOR && JTilerCanvas.this.getFrame() instanceof NCFrame) {
                JTilerCanvas.this.setCursor(Cursor.getPredefinedCursor(JTilerCanvas.this.isHorizontal ? 8 : 10));
                JTilerCanvas.this.isIn = true;
                JTilerCanvas.this.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (JWOptions.DO_SET_CURSOR && JTilerCanvas.this.getFrame() instanceof NCFrame) {
                JTilerCanvas.this.setCursor(Cursor.getDefaultCursor());
                JTilerCanvas.this.isIn = false;
                JTilerCanvas.this.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            JTilerCanvas.this.isDown = true;
            JTilerCanvas.this.sY = JTilerCanvas.this.isHorizontal ? e.getY() : e.getX();
        }

        public void mouseReleased(MouseEvent e) {
            JTilerCanvas.this.isDown = false;
            JTilerCanvas.this.repaintImmediate();
            if ((e.getClickCount() > 1 || e.getX() > 12 || e.getX() < 4) && JTilerCanvas.this.popupEnabled) {
                JTilerCanvas.this.binder().notifyTargets(this);
                return;
            }
            JSplitLayout spl = (JSplitLayout)JTilerCanvas.this.getParent().getLayout();
            int newY = e.getClickCount() >= 2 ? (JTilerCanvas.this.isHorizontal ? (JTilerCanvas.this.getLocation().y + JTilerCanvas.this.size().height / 2 > JTilerCanvas.this.getParent().size().height / 2 ? JTilerCanvas.this.getParent().size().height : 0) : (JTilerCanvas.this.getLocation().x + JTilerCanvas.this.size().width / 2 > JTilerCanvas.this.getParent().size().width / 2 ? JTilerCanvas.this.getParent().size().width : 0)) : (JTilerCanvas.this.isHorizontal ? JTilerCanvas.this.getLocation().y + JTilerCanvas.this.size().height / 2 : JTilerCanvas.this.getLocation().x + JTilerCanvas.this.size().width / 2);
            int newFac = newY * 10000 / (JTilerCanvas.this.isHorizontal ? JTilerCanvas.this.getParent().size().height : JTilerCanvas.this.getParent().size().width);
            spl.setFac(newFac);
            JTilerCanvas.this.getParent().doLayout();
            JTilerCanvas.this.repaint();
        }
    }
}

