/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import Jack.InputObject;
import de.netcomputing.anyj.parsing.SyntaxSearch;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.SortedStringSet;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class ImportGuesser
extends SyntaxSearch {
    ArrayList importList;
    SortedStringSet newimportList = new SortedStringSet();
    HashSet alreadyDone = new HashSet();
    String pack;
    boolean hadErrors = false;
    int firstImportLine = -1;
    int lastImportLine = -1;
    int packEndLine = 0;

    public static ImportGuesser GetFullQualifiedImportList(String file2) {
        ImportGuesser analyzer = new ImportGuesser();
        try {
            Vector v = analyzer.pureParse(EditApp.App.getStreamFor(new File(file2)), false, true);
            if (analyzer.hadErrors()) {
                return null;
            }
            analyzer.walkRecursiveNoScope((InputObject)v.elementAt(0), null, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return analyzer;
    }

    public ImportGuesser() {
        this.importList = new ArrayList();
        this.importList.add("java.lang");
    }

    public String[] getNewImportsAsArray() {
        String[] s = new String[this.getNewimportList().size()];
        int n = 0;
        while (n < this.getNewimportList().size()) {
            s[n] = this.getNewimportList().get(n);
            ++n;
        }
        return s;
    }

    public int getFirstImportLine() {
        if (this.firstImportLine >= 0) {
            return this.firstImportLine;
        }
        return this.getPackEndLine() + 1;
    }

    public int getLastImportLine() {
        if (this.lastImportLine >= 0) {
            return this.lastImportLine;
        }
        return this.getPackEndLine() + 1;
    }

    public int getPackEndLine() {
        return this.packEndLine;
    }

    public void walkRecursiveNoScope(InputObject act, InputObject parent, int parentIndex) {
        if (this.parseNode(parent, act, parentIndex)) {
            InputObject[] obj = act.getContent();
            int n = 0;
            while (obj != null && n < obj.length) {
                this.walkRecursiveNoScope(obj[n], act, n);
                ++n;
            }
        }
    }

    public boolean parseNode(InputObject parent, InputObject current, int index) {
        switch (current.getIntVal()) {
            case 65601: {
                this.pack = current.toString();
                this.pack = this.pack.substring("package".length(), this.pack.length() - 1);
                this.packEndLine = current.lineEndPosition();
                return false;
            }
            case 65600: {
                if (this.firstImportLine < 0) {
                    this.firstImportLine = current.lineStartPosition();
                }
                this.lastImportLine = current.lineStartPosition();
                String imp = current.toString();
                if (!imp.endsWith(".*;")) {
                    String pk = imp.substring("import".length(), imp.length() - 1);
                    if (!pk.equals(this.pack) && !"java.lang".equals(pk)) {
                        this.importList.add(pk);
                    }
                    imp = "import " + imp.substring("import".length());
                } else {
                    String pk = imp.substring("import".length(), imp.length() - 3);
                    if (!pk.equals(this.pack) && !"java.lang".equals(pk)) {
                        this.importList.add(pk);
                    }
                }
                Tracer.This.println("IMPORT:" + this.importList.get(this.importList.size() - 1));
                return false;
            }
            case 65537: {
                String clz = current.toString();
                clz = ("." + clz).substring(("." + clz).lastIndexOf(46) + 1);
                if (!this.alreadyDone.contains(clz) && SourceBase.This().isClass(clz)) {
                    IndexEntry ie;
                    this.alreadyDone.add(clz);
                    boolean added = false;
                    int n = 0;
                    while (n < this.importList.size()) {
                        if (this.importList.get(n).toString().endsWith("." + clz)) {
                            added = true;
                            this.newimportList.put(this.importList.get(n) + ";FQ");
                            break;
                        }
                        ++n;
                    }
                    if (!added) {
                        int n2 = 0;
                        while (n2 < this.importList.size()) {
                            IndexEntry ie2 = SourceBase.This().getClassDef(clz, this.importList.get(n2).toString());
                            if (ie2 != null && (ie2.isClass() || ie2.isInterface()) && ie2.getName().equals(clz) && ie2.getPackageName().equals(this.importList.get(n2).toString()) && !ie2.getPackageName().equals(this.pack)) {
                                if (!"java.lang".equals(ie2.getPackageName())) {
                                    this.newimportList.put(ie2.getPackageName() + "." + ie2.getName() + ";");
                                }
                                added = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!added && (ie = SourceBase.This().getPossibleClassDefFor(clz, null)) != null && (ie.isClass() || ie.isInterface()) && ie.getName().equals(clz) && !ie.getPackageName().equals(this.pack) && !"java.lang".equals(ie.getPackageName())) {
                        this.newimportList.put(ie.getPackageName() + "." + ie.getName() + ";");
                    }
                }
                return false;
            }
        }
        return true;
    }

    public SortedStringSet getNewimportList() {
        return this.newimportList;
    }

    public ArrayList getimportList() {
        return this.importList;
    }
}

