/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import Jack.InputObject;
import Jxe.DocumentStream;
import Jxe.JXEOptions;
import Jxe.TextDocument;
import Jxe.TextView;
import JxeExtensions.ExtBeautifyCode;
import de.netcomputing.anyj.parsing.ExpressionEvaluator;
import de.netcomputing.anyj.parsing.Scope;
import de.netcomputing.anyj.parsing.ScopeRegistry;
import de.netcomputing.anyj.parsing.SyntaxAnalyzer;
import editapp.EditApp;
import editapp.JWJavaParser;
import java.util.Vector;

public class IntroduceLocal
extends SyntaxAnalyzer {
    TextDocument doc;
    TextDocument methodDoc;
    int lastMethodLine = -1;
    int lastMethodEndLine = -1;
    InputObject lastMethod;
    InputObject resultParent;
    InputObject[] result = new InputObject[100];
    InputObject resultObject;
    int resultIndex = 0;
    String resultString;
    TextDocument selection;
    int resultParentIndex;
    String type;
    String varName;
    int cX;
    int cY;
    int scopeIdx;
    int declIdx;
    Scope[] scopeHier = new Scope[100];
    int posXOff;
    int posYOff;
    int lastReplaceLine;
    int lastReplaceCol;
    int firstReplaceLine;

    public IntroduceLocal(TextDocument aDoc) {
        this.doc = aDoc;
    }

    public void parseAndInit(String sourcePath) throws Exception {
        int i;
        InputObject[] resCnt;
        this.doc.trimSelection();
        this.cX = this.doc.selStartX();
        this.cY = this.doc.selStartY();
        Scope tmpScop = new Scope("root", null);
        tmpScop.setScopeRegistry(ScopeRegistry.New(sourcePath));
        Vector v = this.parseBuildingScope(new DocumentStream(this.doc, 0, 0), tmpScop);
        if (v.size() != 1) {
            int[] i2 = JWJavaParser.GuessErrorRange(v);
            if (i2 != null) {
                EditApp.App.markErrorInDoc(this.doc.getFile(), i2);
            }
            throw new RuntimeException("Parse Failure, file must not contain syntax errors");
        }
        this.findSelection(null, 0, (InputObject)v.get(0), this.rootScope, null);
        this.selection = this.doc.getSelection();
        ExpressionEvaluator expr = new ExpressionEvaluator(this.clone);
        String res = null;
        if (this.resultIndex > 1) {
            resCnt = new InputObject[this.resultIndex];
            i = 0;
            while (i < this.resultIndex) {
                resCnt[i] = this.result[i];
                ++i;
            }
            this.resultObject = new InputObject(65602, resCnt);
            res = expr.parseTreeCallback(this.scopeHier[this.scopeIdx - 1], this.resultParent, this.resultObject, this.resultParentIndex);
        } else {
            this.resultObject = this.result[0];
            resCnt = this.resultObject.getContent();
            i = 0;
            while (i < resCnt.length) {
                this.result[i] = resCnt[i];
                ++i;
            }
            this.resultIndex = resCnt.length;
            res = expr.parseTreeCallback(this.scopeHier[this.scopeIdx - 1], this.resultParent, this.resultObject, this.resultParentIndex);
        }
        this.type = res == null || "integral".equals(res) ? "Object" : res;
        this.resultString = this.resultObject.toString();
        String tmpType = this.type;
        int idx = tmpType.lastIndexOf(".");
        if (idx >= 0) {
            tmpType = tmpType.substring(idx + 1);
        }
        this.varName = "tmp" + tmpType.substring(0, 1).toUpperCase() + tmpType.substring(1);
        this.methodDoc = this.doc.createCopy(this.lastMethod.lineStartPosition(), this.lastMethod.lineEndPosition(), this.lastMethod.colStartPosition(), this.lastMethod.colEndPosition());
    }

    public String getResultString() {
        return this.resultString;
    }

    public void doInsert(boolean replace) {
        TextView tv = this.doc.getView();
        this.doc.setView(null);
        this.doc.setSelection(this.lastMethod.colStartPosition(), this.lastMethod.lineStartPosition(), this.lastMethod.colEndPosition(), this.lastMethod.lineEndPosition());
        this.doc.cutSelection();
        this.doc.pasteDoc(this.getPreview(replace, false));
        this.doc.moveCursorAbs(this.cX, this.cY);
        this.doc.setView(tv);
        this.doc.repaint();
    }

    public TextDocument getPreview(boolean replace, boolean format) {
        String selString = this.selection.toString();
        TextDocument res = this.methodDoc.createCopy();
        this.posYOff = 0;
        this.posXOff = 0;
        this.firstReplaceLine = -1;
        this.lastReplaceCol = 0;
        this.lastReplaceLine = 0;
        InputObject scPar = this.findScopeParent(this.scopeHier[this.declIdx], this.lastMethod, null);
        this.replaceAndFindScope(-this.lastMethod.lineStartPosition(), scPar, null, res, replace);
        int declInsertLine = this.scopeHier[this.declIdx].getStartLine() + 1 - this.lastMethod.lineStartPosition();
        declInsertLine = this.findInsertLine(this.firstReplaceLine, scPar, declInsertLine + this.lastMethod.lineStartPosition(), null, this.scopeHier[this.declIdx]) - this.lastMethod.lineStartPosition();
        if (format) {
            res.insertTabInternal(0, JXEOptions.INDENT);
        }
        int pos = res.lineAt(declInsertLine - 1).translateX(res.lineAt(declInsertLine - 1).getFirstChar());
        res.insertLine(declInsertLine, this.type + " " + this.varName + " = ;");
        ExtBeautifyCode.Format1(res, declInsertLine, declInsertLine);
        if (declInsertLine < 3) {
            res.insert(res.constructSpace(JXEOptions.INDENT).toString(), 0, declInsertLine, 0);
        }
        res.moveCursorAbs(res.lineAt(declInsertLine).size() - 1, declInsertLine);
        res.pasteDoc(this.selection);
        res.moveCursorAbs(this.cX, this.cY);
        res.setHiLightWord(this.varName);
        this.doc.setHilightWordMatchCase(true);
        res.moveCursorAbs(0, declInsertLine);
        return res;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getVarName() {
        return this.varName;
    }

    Scope joinedScope(Scope a, Scope b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        Scope act = a;
        while (act != null) {
            Scope actB = b;
            while (actB != null) {
                if (act == actB) {
                    return act;
                }
                actB = actB.supScope;
            }
            act = act.supScope;
        }
        return b;
    }

    int findInsertLine(int firstReplaceLine, InputObject obj, int currResult, Scope scop, Scope toFindIn) {
        return this.findInsertLineInternal(firstReplaceLine, obj, currResult, scop, toFindIn);
    }

    int findInsertLineInternal(int firstReplaceLine, InputObject obj, int currResult, Scope scop, Scope toFindIn) {
        InputObject[] cnt = obj.getContent();
        int n = 0;
        while (cnt != null && n < cnt.length) {
            if (cnt[n].getIntVal() == 65632 && toFindIn == scop && cnt[n].lineEndPosition() <= firstReplaceLine && cnt[n].lineEndPosition() > currResult && (n <= 0 || cnt[n - 1].getIntVal() != 65586)) {
                currResult = n == cnt.length - 1 ? cnt[n].lineEndPosition() : cnt[n + 1].lineStartPosition();
            }
            if (cnt[n].getIntVal() == 65597) {
                scop = (Scope)this.scopeMap.get(cnt[n]);
            } else if (cnt[n].getIntVal() == 65598) {
                scop = this.currentScope;
            }
            currResult = this.findInsertLineInternal(firstReplaceLine, cnt[n], currResult, scop, toFindIn);
            ++n;
        }
        return currResult;
    }

    void replaceAndFindScope(int lineOffset, InputObject obj, Scope currentScope, TextDocument resBuf, boolean replace) {
        Scope scop = currentScope;
        InputObject[] cnt = obj.getContent();
        int compareIndex = 0;
        int n = 0;
        while (cnt != null && n < cnt.length) {
            if (this.result[compareIndex].toString().equals(cnt[n].toString())) {
                if (compareIndex == this.resultIndex - 1) {
                    InputObject matchStart = cnt[n - this.resultIndex + 1];
                    int matchStartLine = matchStart.lineStartPosition();
                    int matchStartCol = matchStart.colStartPosition();
                    int oldSize = resBuf.size();
                    int oldLen = resBuf.lineAt(matchStartLine + lineOffset).size();
                    if (this.lastReplaceLine != matchStartLine) {
                        this.posXOff = 0;
                    }
                    if (replace && (matchStartLine != this.lastReplaceLine || this.lastReplaceCol != matchStartCol)) {
                        resBuf.setSelection(matchStartCol + this.posXOff, matchStartLine + this.posYOff + lineOffset, cnt[n].colEndPosition() + this.posXOff, this.posYOff + cnt[n].lineEndPosition() + lineOffset);
                        resBuf.cutSelection();
                        resBuf.moveCursorAbs(matchStartCol + this.posXOff, matchStartLine + this.posYOff + lineOffset);
                        resBuf.insertAndMove(this.varName);
                        this.posXOff += resBuf.lineAt(matchStartLine + this.posYOff + lineOffset).size() - oldLen;
                        this.posYOff += resBuf.size() - oldSize;
                        this.lastReplaceCol = matchStartCol;
                    }
                    if (this.firstReplaceLine == -1) {
                        this.firstReplaceLine = matchStartLine;
                    }
                    this.lastReplaceLine = matchStartLine;
                    compareIndex = 0;
                } else {
                    ++compareIndex;
                }
            } else {
                compareIndex = 0;
            }
            if (cnt[n].getIntVal() == 65597) {
                scop = (Scope)this.scopeMap.get(cnt[n]);
            } else if (cnt[n].getIntVal() == 65598) {
                scop = currentScope;
            }
            this.replaceAndFindScope(lineOffset, cnt[n], scop, resBuf, replace);
            ++n;
        }
    }

    public boolean canScopeUp() {
        return this.scopeHier[this.declIdx + 1] != null;
    }

    public boolean canScopeDown() {
        return this.declIdx > 0;
    }

    public void scopeUp() {
        ++this.declIdx;
    }

    public void scopeDown() {
        --this.declIdx;
    }

    boolean findSelection(InputObject parent, int index, InputObject obj, Scope currentScope, InputObject scopeParent) {
        InputObject[] parcont = null;
        int actLineStart = obj.lineStartPosition();
        if (parent != null) {
            parcont = parent.getContent();
        }
        if (actLineStart > this.doc.selEndY() + 2) {
            return false;
        }
        int actLineEnd = obj.lineEndPosition();
        int actColStart = obj.colStartPosition();
        switch (obj.getIntVal()) {
            case 65626: 
            case 65627: {
                this.lastMethod = obj;
                this.lastMethodLine = actLineStart;
                this.lastMethodEndLine = actLineEnd;
            }
        }
        if ((actLineStart > this.doc.selStartY() || actLineStart == this.doc.selStartY() && actColStart >= this.doc.selStartX()) && (actLineEnd < this.doc.selEndY() || actLineEnd == this.doc.selEndY() && obj.colEndPosition() <= this.doc.selEndX())) {
            this.result[this.resultIndex++] = obj;
            if (this.resultIndex == 1) {
                this.scopeHier[this.scopeIdx++] = currentScope;
                do {
                    currentScope = currentScope.supScope;
                    this.scopeHier[this.scopeIdx++] = currentScope;
                } while (!currentScope.getIsFunScope() && !currentScope.getIsClazzScope() && currentScope != this.rootScope);
                this.resultParentIndex = index;
                this.declIdx = 0;
                this.resultParent = parent;
            }
            return true;
        }
        Scope scop = currentScope;
        InputObject actScopPar = scopeParent;
        InputObject[] cnt = obj.getContent();
        int n = 0;
        while (cnt != null && n < cnt.length) {
            if (cnt[n].getIntVal() == 65597) {
                scop = (Scope)this.scopeMap.get(cnt[n]);
                actScopPar = obj;
            } else if (cnt[n].getIntVal() == 65598) {
                scop = currentScope;
                actScopPar = scopeParent;
            }
            if (!this.findSelection(obj, n, cnt[n], scop, actScopPar)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    InputObject findScopeParent(Scope toFind, InputObject obj, Scope currentScope) {
        Scope scop = currentScope;
        InputObject[] cnt = obj.getContent();
        int n = 0;
        while (cnt != null && n < cnt.length) {
            InputObject result;
            if (cnt[n].getIntVal() == 65597) {
                scop = (Scope)this.scopeMap.get(cnt[n]);
                if (scop == toFind) {
                    return obj;
                }
            } else if (cnt[n].getIntVal() == 65598) {
                scop = currentScope;
            }
            if ((result = this.findScopeParent(toFind, cnt[n], scop)) != null) {
                return result;
            }
            ++n;
        }
        return null;
    }
}

