/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.services;

import de.netcomputing.anyj.services.ProfileEntry;
import de.netcomputing.anyj.services.SampleEntry;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import jxeplugins.JEBasicService;

public class AJProfilingServices {
    public static void RegisterServices() {
        JEBasicService ser = new JEBasicService("Tools", "Read Heap Dump", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && !((File)selection).isDirectory();
            }

            public void doProcess(Object selection, Object selector) {
                File file2 = (File)selection;
            }
        };
        EditApp.ServReg.addService(ser);
    }

    public static void readHeap(File f) throws Exception {
        FileInputStream in = new FileInputStream(f);
        DataInputStream din = new DataInputStream(new BufferedInputStream(in, 500000));
        String line = "";
        int liCount = 0;
        HashSet<String> neededTraces = new HashSet<String>();
        HashMap traces = new HashMap(1000);
        boolean parseSites = false;
        boolean parseSamples = false;
        Vector<ProfileEntry> sites = new Vector<ProfileEntry>();
        Vector<SampleEntry> samples = new Vector<SampleEntry>();
        while ((line = din.readLine()) != null) {
            Vector v;
            if (line.startsWith("CPU SAMPLES END")) {
                parseSamples = false;
            } else if (line.startsWith("SITES END")) {
                parseSites = false;
            } else if (parseSamples) {
                v = NCStringUtilities.SplitSeparatedString(" ", line);
                SampleEntry se = new SampleEntry();
                se.rank = v.elementAt(0).toString();
                se.perc = v.elementAt(1).toString();
                se.accum = v.elementAt(2).toString();
                se.count = v.elementAt(3).toString();
                se.traceNo = v.elementAt(4).toString();
                se.method = v.elementAt(5).toString();
                samples.add(se);
                neededTraces.add(se.traceNo);
            } else if (parseSites) {
                v = NCStringUtilities.SplitSeparatedString(" ", line);
                ProfileEntry pe = new ProfileEntry();
                pe.rank = v.elementAt(0).toString();
                pe.perc = v.elementAt(1).toString();
                pe.accum = v.elementAt(2).toString();
                pe.liveBytes = v.elementAt(3).toString();
                pe.liveObj = v.elementAt(4).toString();
                pe.allocBytes = v.elementAt(5).toString();
                pe.allocObj = v.elementAt(6).toString();
                pe.traceNo = v.elementAt(7).toString();
                pe.type = v.elementAt(8).toString();
                sites.add(pe);
                neededTraces.add(pe.traceNo);
            } else if (!line.startsWith("TRACE ")) {
                if (line.startsWith(" rank")) {
                    parseSites = true;
                } else if (line.startsWith("rank")) {
                    parseSamples = true;
                }
            }
            ++liCount;
        }
        in.close();
        in = new FileInputStream(f);
        din = new DataInputStream(new BufferedInputStream(in, 500000));
        Vector<String> traceLines = null;
        boolean inTrace = false;
        liCount = 0;
        while ((line = din.readLine()) != null) {
            if (line.startsWith("TRACE ")) {
                traceLines = new Vector<String>();
                inTrace = true;
                try {
                    String nrString = line.substring(line.indexOf(" ") + 1, line.indexOf(":"));
                    if (neededTraces.contains(nrString)) {
                        traces.put(nrString, traceLines);
                    }
                }
                catch (Exception ex) {}
            } else {
                if (line.startsWith(" rank")) break;
                if (inTrace) {
                    traceLines.add(line);
                }
            }
            ++liCount;
        }
        int i = 0;
        while (i < sites.size()) {
            ProfileEntry pe = (ProfileEntry)sites.get(i);
            System.out.println("HEAP:" + pe.type + " -----------------------------------------------------");
            System.out.println("rank     :" + pe.rank);
            System.out.println("perc     :" + pe.perc);
            System.out.println("accumperc:" + pe.accum);
            System.out.println("bytes    :" + pe.liveBytes);
            System.out.println("objects  :" + pe.liveObj);
            Vector lis = (Vector)traces.get(pe.traceNo);
            int ii = 0;
            while (ii < lis.size()) {
                System.out.println(lis.get(ii));
                ++ii;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < samples.size()) {
            SampleEntry se = (SampleEntry)samples.get(i2);
            System.out.println("SAMPLE:" + se.method + " -----------------------------------------------------");
            System.out.println("rank     :" + se.rank);
            System.out.println("perc     :" + se.perc);
            System.out.println("accumperc:" + se.accum);
            System.out.println("count    :" + se.count);
            Vector lis = (Vector)traces.get(se.traceNo);
            int ii = 0;
            while (ii < lis.size()) {
                System.out.println(lis.get(ii));
                ++ii;
            }
            ++i2;
        }
    }

    public static void main(String[] args) throws Exception {
        AJProfilingServices.readHeap(new File(args[0]));
    }
}

