/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.communication;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.communication.INCCommunicationCallback;
import de.netcomputing.communication.INCCommunicationCalls;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Frame;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Vector;

public class NCBroadcaster
implements Runnable,
INCCommunicationCalls {
    int[] ports = new int[]{1038, 2879, 9876, 14553, 18765, 33875, 47623, 55123};
    INCCommunicationCallback callback;
    boolean initialized = false;
    DatagramSocket sendSocket;
    DatagramSocket receiveSocket;
    int receivePort;
    int packetSize = Short.MAX_VALUE;
    Thread thread;
    Object startLock = new Object();
    boolean doRun = true;
    int ackIdCount = 0;
    HashMap haltedThreadLocks = new HashMap();
    public static String localIp = null;

    public NCBroadcaster(INCCommunicationCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SocketException {
        this.initialized = false;
        this.doRun = true;
        try {
            this.sendSocket = new DatagramSocket();
            System.out.println("SENDER BOUND");
        }
        catch (SocketException ex) {
            ex.printStackTrace(Tracer.This);
            return;
        }
        int i = 0;
        while (i < this.ports.length) {
            try {
                this.receiveSocket = new DatagramSocket(this.ports[i]);
                System.out.println("RECEIVER BOUND:" + this.ports[i]);
                this.receivePort = this.ports[i];
                break;
            }
            catch (SocketException ex) {
                System.out.println("PORT FAILED:" + this.ports[i]);
                ++i;
            }
        }
        if (this.sendSocket != null && this.receiveSocket != null) {
            this.initialized = true;
            this.thread = new Thread(this);
            this.thread.start();
            Object object = this.startLock;
            synchronized (object) {
                try {
                    this.startLock.wait(1000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isRunning() {
        return this.doRun;
    }

    public boolean send(InetAddress ip, int port, String s) {
        if (!this.initialized || !this.isRunning()) {
            return false;
        }
        try {
            byte[] b = s.getBytes();
            this.sendSocket.send(new DatagramPacket(b, b.length, ip, port));
        }
        catch (Exception e) {
            Tracer.This.println(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean sendMulti(InetAddress ip, String s) {
        if (!this.initialized || !this.isRunning()) {
            return false;
        }
        int i = 0;
        while (i < this.ports.length) {
            this.send(ip, this.ports[i], s);
            ++i;
        }
        return true;
    }

    String quote(String s) {
        s = NCStringUtilities.Replace(s, "&", "&&");
        s = NCStringUtilities.Replace(s, ";", "1&2");
        return s;
    }

    String unquote(String s) {
        s = NCStringUtilities.Replace(s, "1&2", ";");
        s = NCStringUtilities.Replace(s, "&&", "&");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForAck(int waitMillis, String ackId) throws Exception {
        Object lock = new Object();
        HashMap hashMap = this.haltedThreadLocks;
        synchronized (hashMap) {
            this.haltedThreadLocks.put(ackId, lock);
        }
        Object object = lock;
        synchronized (object) {
            lock.wait(waitMillis);
        }
        HashMap hashMap2 = this.haltedThreadLocks;
        synchronized (hashMap2) {
            block14: {
                block13: {
                    block12: {
                        if (this.haltedThreadLocks.get(ackId) != null) break block12;
                        String string = "OK";
                        return string;
                    }
                    if (this.haltedThreadLocks.get(ackId) != lock) break block13;
                    String string = "TIMEOUT";
                    return string;
                }
                if (!("" + this.haltedThreadLocks.get(ackId)).startsWith("VETO:")) break block14;
                String string = ((String)this.haltedThreadLocks.get(ackId)).substring(5);
                return string;
            }
            String string = "UNDEFINED";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForVeto(int waitMillis, String ackId) throws Exception {
        Object lock = new Object();
        HashMap hashMap = this.haltedThreadLocks;
        synchronized (hashMap) {
            this.haltedThreadLocks.put(ackId, lock);
        }
        Object object = lock;
        synchronized (object) {
            lock.wait(waitMillis);
        }
        HashMap hashMap2 = this.haltedThreadLocks;
        synchronized (hashMap2) {
            block14: {
                block13: {
                    block12: {
                        if (this.haltedThreadLocks.get(ackId) != null) break block12;
                        boolean bl = false;
                        return bl;
                    }
                    if (this.haltedThreadLocks.get(ackId) != lock) break block13;
                    boolean bl = true;
                    return bl;
                }
                if (!("" + this.haltedThreadLocks.get(ackId)).startsWith("VETO:")) break block14;
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DatagramPacket p = new DatagramPacket(new byte[this.packetSize], this.packetSize);
        while (this.doRun) {
            byte[] b = p.getData();
            int i = 0;
            while (i < b.length) {
                b[i] = 0;
                ++i;
            }
            try {
                Object msg;
                String ackId;
                Object object = this.startLock;
                synchronized (object) {
                    try {
                        this.startLock.notifyAll();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.receiveSocket.receive(p);
                String s = new String(p.getData());
                Vector v = NCStringUtilities.SplitSeparatedString(";", s, true);
                String command = v.get(0).toString();
                String sender = v.get(1).toString();
                String senderHost = v.get(2).toString();
                int senderPort = Integer.parseInt(v.get(3).toString());
                this.println("COMMAND:" + command);
                this.println("SENDER:" + sender);
                this.println("HOST:" + senderHost);
                this.println("PORT:" + senderPort);
                if (senderHost.equals(NCBroadcaster.getLocaHostAddress()) && senderPort == this.receivePort) continue;
                if (command.equals("GUCKU") || command.equals("HALLO")) {
                    this.println("RECEIVED " + command + " FROM:" + sender);
                    if (command.equals("GUCKU")) {
                        this.send(InetAddress.getByName(senderHost), senderPort, this.getSignature("HALLO"));
                    }
                    this.userReceived(command, sender, senderHost, senderPort);
                    if (!command.equals("GUCKU")) continue;
                    this.send(InetAddress.getByName(senderHost), senderPort, this.getSignature("HALLO"));
                    continue;
                }
                if (command.startsWith("RA_")) {
                    ackId = (String)v.get(4);
                    msg = (String)v.get(5);
                    String res = this.reqAckReceived(command.substring(3), sender, senderHost, senderPort, (String)msg, ackId);
                    if (res.equals("OK")) {
                        this.send(InetAddress.getByName(senderHost), senderPort, this.getSignature("ACK_") + ";" + ackId);
                        continue;
                    }
                    if (!res.startsWith("VETO:")) continue;
                    this.send(InetAddress.getByName(senderHost), senderPort, this.getSignature("VETO_") + ";" + ackId + ";" + res.substring(5));
                    continue;
                }
                if (command.startsWith("ACK_")) {
                    ackId = (String)v.get(4);
                    msg = this.haltedThreadLocks;
                    synchronized (msg) {
                        Object lock = this.haltedThreadLocks.get(ackId);
                        this.haltedThreadLocks.remove(ackId);
                        if (lock != null) {
                            Object v2 = lock;
                            synchronized (v2) {
                                lock.notifyAll();
                            }
                        }
                        continue;
                    }
                }
                if (command.startsWith("VETO_")) {
                    ackId = (String)v.get(4);
                    msg = (String)v.get(5);
                    HashMap hashMap = this.haltedThreadLocks;
                    synchronized (hashMap) {
                        Object lock = this.haltedThreadLocks.get(ackId);
                        this.haltedThreadLocks.put(ackId, "VETO:" + (String)msg);
                        if (lock != null) {
                            Object v3 = lock;
                            synchronized (v3) {
                                lock.notifyAll();
                            }
                        }
                        continue;
                    }
                }
                String msg2 = (String)v.get(4);
                this.dataReceived(command, sender, senderHost, senderPort, this.unquote(msg2));
            }
            catch (Exception e) {
                e.printStackTrace(Tracer.This);
            }
        }
    }

    public String getBCastAdressB(String caddr) throws Exception {
        int i = caddr.lastIndexOf(".255");
        i = caddr.lastIndexOf(".", i - 1);
        caddr = caddr.substring(0, i) + ".255.255";
        return caddr;
    }

    public String getBCastAdressA(String baddr) throws Exception {
        int i = baddr.lastIndexOf(".255.255");
        i = baddr.lastIndexOf(".", i - 1);
        baddr = baddr.substring(0, i) + ".255.255.255";
        return baddr;
    }

    public String getBCastAdress() throws Exception {
        String addr = NCBroadcaster.getLocaHostAddress();
        System.out.println("IP:" + addr);
        int i = addr.lastIndexOf(".");
        addr = addr.substring(0, i) + ".255";
        System.out.println("BCAST:" + addr);
        return addr;
    }

    public static String getLocaHostAddress() {
        if (localIp != null) {
            return localIp;
        }
        String addr = null;
        try {
            addr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (addr.equals("127.0.0.1")) {
            Frame w = EditApp.App == null ? new Frame() : EditApp.App.getMainWindow();
            addr = Confirm.GetText(w, null, "Unable to ressolve IP", new String[]{"AnyJ was unable to get the localhost", "IP (127.0.0.1 was returned, wrong).", "Please specify the ip address of your", "Machine."});
            if (addr == null) {
                addr = "127.0.0.1";
            }
            localIp = addr;
        }
        return addr;
    }

    public String getSignature(String command) throws Exception {
        return command + ";" + System.getProperty("user.name") + ";" + NCBroadcaster.getLocaHostAddress() + ";" + this.receivePort;
    }

    public void println(String s) {
    }

    public void userReceived(String command, String sender, String senderHost, int senderPort) {
        this.callback.userReceived(command, sender, senderHost, senderPort);
    }

    public void dataReceived(String command, String sender, String senderHost, int senderPort, String data) {
        this.callback.dataReceived(command, sender, senderHost, senderPort, this.unquote(data));
    }

    public String reqAckReceived(String command, String sender, String senderHost, int senderPort, String data, String ackId) {
        return this.callback.reqAckReceived(command, sender, senderHost, senderPort, data, ackId);
    }

    public void pingUsers() throws Exception {
        this.println("XX:ping users:");
        this.sendMulti("GUCKU", "");
    }

    public void stopNetwork() throws Exception {
        localIp = null;
        this.doRun = false;
        try {
            this.receiveSocket.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.sendSocket.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendMulti(String command, String data) throws Exception {
        String s = this.getBCastAdress();
        InetAddress iAddress = InetAddress.getByName(s);
        this.sendMulti(InetAddress.getByName(s), this.getSignature(command) + ";" + this.quote(data));
        s = this.getBCastAdressB(s);
        iAddress = InetAddress.getByName(s);
        this.sendMulti(iAddress, this.getSignature(command) + ";" + this.quote(data));
        this.sendMulti(InetAddress.getByName(this.getBCastAdressA(s)), this.getSignature(command) + ";" + this.quote(data));
    }

    public void sendSingle(String ip, int port, String command, String data) throws Exception {
        this.send(InetAddress.getByName(ip), port, this.getSignature(command) + ";" + this.quote(data));
    }

    public boolean sendCheckVetoMulti(String command, String data) throws Exception {
        ++this.ackIdCount;
        this.sendMulti("RA_" + command, this.getSignature(command) + ";" + this.ackIdCount + ";" + this.quote(data));
        return this.waitForVeto(1000, "" + this.ackIdCount);
    }

    public String sendRequestAck(String ip, int port, String command, String data) throws Exception {
        this.sendMulti(InetAddress.getByName(this.getBCastAdress()), this.getSignature("RA_" + command) + ";" + this.quote(data));
        return this.waitForAck(1000, "" + this.ackIdCount);
    }
}

