/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import JWVFile.VVolume;
import de.netcomputing.cvswrap.commands.CVSCommand;
import de.netcomputing.cvswrap.commands.DiffEntry;
import de.netcomputing.util.Tracer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class DiffWrapper
extends CVSCommand {
    Vector diffEntries;
    Vector revFile;
    boolean ignoreWS = false;

    public DiffWrapper(String repository) {
        super(repository);
    }

    public Vector getRevFile() {
        return this.revFile;
    }

    public void setIgnoreWS(boolean ignoreWS) {
        this.ignoreWS = ignoreWS;
    }

    public boolean getIgnoreWS() {
        return this.ignoreWS;
    }

    public String runDiff(String wdir, String revision, String revision1, String actfile) {
        DataInputStream din;
        FileInputStream in;
        String opt;
        File tmp = CVSCommand.getTmpFile();
        File revTmp = null;
        String cline = null;
        String string = opt = this.ignoreWS ? " -w " : "";
        if (revision1 == null) {
            cline = CVSCommand.CVS + CVSCommand.DIFF + opt + "-r" + revision + " " + actfile;
            this.execute(wdir, cline, tmp.getAbsolutePath());
        } else {
            cline = CVSCommand.CVS + "-q -n " + CVSCommand.UPDATE + "-p -r" + revision + " " + actfile;
            this.execute(wdir, cline, tmp.getAbsolutePath());
            revTmp = tmp;
            tmp = CVSCommand.getTmpFile();
            try {
                in = new FileInputStream(revTmp);
                din = new DataInputStream(in);
                this.revFile = new Vector(1000);
                String line = null;
                while ((line = din.readLine()) != null) {
                    this.revFile.addElement(line);
                }
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "error reading command output of " + cline + " " + actfile;
            }
            cline = CVSCommand.CVS + CVSCommand.DIFF + " " + opt + "-r" + revision1 + " -r" + revision + " " + actfile;
            this.execute(wdir, cline, tmp.getAbsolutePath());
        }
        try {
            in = new FileInputStream(tmp);
            din = new DataInputStream(in);
            if (!this.parseDiff(din)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline + " " + actfile;
        }
        return null;
    }

    public void parseDiffHead(String line, DiffEntry toInsertIn) {
        line = line.trim();
        String type = "a";
        int i = line.indexOf("a");
        if (i <= 0) {
            i = line.indexOf("d");
            type = "d";
        }
        if (i <= 0) {
            i = line.indexOf("c");
            type = "c";
        }
        if (i <= 0) {
            throw new RuntimeException("unknown difftype:" + line);
        }
        String pre = line.substring(0, i);
        String past = line.substring(i + 1, line.length());
        toInsertIn.setType(type);
        if (pre.indexOf(",") >= 0) {
            toInsertIn.setLineNoAt(0, Integer.parseInt(pre.substring(0, pre.indexOf(","))));
            toInsertIn.setLineNoAt(1, Integer.parseInt(pre.substring(pre.indexOf(",") + 1)));
        } else {
            toInsertIn.setLineNoAt(0, Integer.parseInt(pre));
        }
        if (past.indexOf(",") >= 0) {
            toInsertIn.setLineNoAt(2, Integer.parseInt(past.substring(0, past.indexOf(","))));
            toInsertIn.setLineNoAt(3, Integer.parseInt(past.substring(past.indexOf(",") + 1)));
        } else {
            toInsertIn.setLineNoAt(2, Integer.parseInt(past));
        }
    }

    public Vector getDiffEntries() {
        return this.diffEntries;
    }

    public boolean parseDiff(DataInputStream din) throws Exception {
        String line = null;
        DiffEntry act = null;
        this.diffEntries = new Vector();
        boolean started = false;
        while ((line = din.readLine()) != null) {
            if (line.startsWith("===================================================================")) {
                act = new DiffEntry();
                this.diffEntries.addElement(act);
                while (!(line = din.readLine()).startsWith("diff ")) {
                }
                line = din.readLine();
                this.parseDiffHead(line, act);
                started = true;
                continue;
            }
            if (!started) continue;
            if (line.startsWith(">") || line.startsWith("<") || line.startsWith("-")) {
                if (line.startsWith("-")) continue;
                act.getLines().addElement(line);
                continue;
            }
            act = new DiffEntry();
            try {
                this.parseDiffHead(line, act);
                this.diffEntries.addElement(act);
            }
            catch (NumberFormatException ex) {
                Tracer.This.println("NumberFormatException:" + line);
            }
        }
        return true;
    }

    public static void main(String[] args) {
        DiffWrapper wrapper = new DiffWrapper("\\\\MARS\\D\\cvsroot");
        VVolume.New("process", "c:\\temp");
        Tracer.This.println(wrapper.runDiff("D:\\ruedi_home\\projects\\anyj\\source\\plugins", "1.1", null, "JavacPlugin.java"));
        Vector logEntries = wrapper.diffEntries;
        int n = 0;
        while (n < logEntries.size()) {
            DiffEntry ent = (DiffEntry)logEntries.elementAt(n);
            ent.dump(System.out);
            ++n;
        }
    }
}

