/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.gui;

import JWVFile.VVolume;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.cvswrap.commands.DiffWrapper;
import de.netcomputing.cvswrap.commands.StatusWrapper;
import de.netcomputing.cvswrap.components.DiffView;
import de.netcomputing.cvswrap.components.RevisionChooser;
import de.netcomputing.cvswrap.gui.CVSCommit;
import de.netcomputing.cvswrap.gui.CVSDiffGUI;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CVSDiff
extends NCPanel {
    JLabel fileLabel;
    RevisionChooser revA;
    JButton diffBtn;
    JCheckBox ignoreWSChk;
    JLabel titleLabel;
    DiffView diffView;
    String wdir;
    String finam;

    public CVSDiff() {
        this.initGui();
    }

    public void initGui() {
        new CVSDiffGUI().createGui(this);
        this.diffBtn.setMnemonic('d');
    }

    public void setFile(File f) {
        this.setEnabled(false);
        StatusWrapper wrp = new StatusWrapper(null);
        this.wdir = f.getParent();
        this.finam = f.getName();
        String error = wrp.runLog(this.wdir, this.finam);
        this.setEnabled(true);
        if (error == null) {
            this.revA.setStatusWrapper(wrp);
            this.fileLabel.setText(f.getAbsolutePath());
        } else {
            this.fileLabel.setText(error);
        }
        this.setDocEnabled(false);
        this.diffBtn.setEnabled(true);
        this.titleLabel.setText("");
        this.revA.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CVSDiff.this.diffBtn.setEnabled(CVSDiff.this.revA.getSelectedRevisions() != null);
            }
        });
        this.repaint();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    void setDocEnabled(boolean b) {
        this.diffView.setDocsVisible(b);
        if (!b) {
            this.titleLabel.setText("");
            this.diffView.reset();
        }
        this.diffView.enablePrevNext(b);
    }

    public void diffBtn_actionPerformed(ActionEvent var0) {
        JWidgetsUtil.AddJob(new Runnable(){

            public void run() {
                CVSDiff.this.setEnabled(false);
                CVSDiff.this.setDocEnabled(false);
                CVSDiff.this.repaint();
                String[] revs = CVSDiff.this.revA.getSelectedRevisions();
                if (revs == null) {
                    return;
                }
                String rev = revs[0];
                String revB = null;
                if (revs.length > 1) {
                    revB = revs[1];
                }
                DiffWrapper diff = new DiffWrapper(null);
                diff.setIgnoreWS(CVSDiff.this.ignoreWSChk.isSelected());
                String res = diff.runDiff(CVSDiff.this.wdir, rev, revB, CVSDiff.this.finam);
                if (res != null) {
                    CVSDiff.this.titleLabel.setText(res);
                    CVSDiff.this.setDocEnabled(false);
                    return;
                }
                if (revB == null) {
                    CVSDiff.this.titleLabel.setText("local version against rev " + rev);
                } else {
                    CVSDiff.this.titleLabel.setText("rev " + rev + " against rev" + revB);
                }
                Vector v = diff.getDiffEntries();
                Vector oldRev = diff.getRevFile();
                if (oldRev == null) {
                    CVSDiff.this.diffView.applyDiffEntries(null, new File(CVSDiff.this.wdir, CVSDiff.this.finam), v, null);
                } else {
                    CVSDiff.this.diffView.applyDiffEntries(oldRev, null, v, null);
                }
                CVSDiff.this.diffBtn.setEnabled(true);
                CVSDiff.this.setDocEnabled(true);
                CVSDiff.this.setEnabled(true);
            }
        });
    }

    public static void main(String[] args) {
        VVolume.New("process", "c:\\temp");
        CVSCommit cvsCommit = new CVSCommit();
        JFrame fr = ApplicationHelper.Singleton().createFrameOn(cvsCommit);
        fr.pack();
        fr.show();
        cvsCommit.initFromUpdate("D:\\work\\anyj\\source");
    }
}

