/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import de.netcomputing.modeller.DefaultSaver;
import de.netcomputing.modeller.IModellerContext;
import de.netcomputing.modeller.model.IDataModel;
import de.netcomputing.modeller.model.IDataModelEntity;
import de.netcomputing.modeller.model.IDataModelNode;
import de.netcomputing.modeller.model.MetaModel;
import de.netcomputing.modeller.model.ModelUtilities;
import de.netcomputing.util.stringpersistance.NCStringMapper;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetaModelSaver
extends DefaultSaver {
    int saveIdCount = 0;
    static /* synthetic */ Class class$java$awt$Rectangle;

    public void saveModel(IDataModel model, OutputStream outs) throws Exception {
        PrintStream out = new PrintStream(outs);
        out.println("<MetaModel>");
        Rectangle bounds = null;
        List l = model.getDataEntities();
        int i = 0;
        while (i < l.size()) {
            Map attprops;
            IDataModelEntity conEnt;
            int ii;
            List conected;
            Iterator it;
            Map props;
            IDataModelEntity assoc = (IDataModelEntity)l.get(i);
            assoc.setID(this.saveIdCount++);
            String entityType = assoc.getMetaSpec().getField("name");
            bounds = assoc.getModelBounds();
            if ("AttributeSpec".equals(entityType)) {
                props = assoc.getProperties();
                if ("ModelAttributes".equals(props.get("Name"))) {
                    it = assoc.getAttributes().iterator();
                    out.println("    <Properties>");
                    this.storeProperty("        ", out, it);
                    out.println("    </Properties>");
                }
            } else if ("ModelEntity".equals(entityType)) {
                props = assoc.getProperties();
                out.println("    <Entity name=\"" + props.get("Name") + "\" shape=\"" + props.get("Shape") + "\" labelproperty=\"" + props.get("LabelPropertyName") + "\" ImageClassPath=\"" + this.getDef(props, "ImagePath", "") + "\" bounds=\"" + NCStringMapper.This().encode(bounds) + "\" >");
                out.print("        <Comment>");
                out.print(this.getDef(props, "Comment", ""));
                out.println("</Comment>");
                it = assoc.getAttributes().iterator();
                out.println("        <Properties>");
                this.storeProperty("        ", out, it);
                out.println("        </Properties>");
                conected = ModelUtilities.This.findConnectectedEntities(model, assoc, "Contains");
                ii = 0;
                while (ii < conected.size()) {
                    conEnt = (IDataModelEntity)conected.get(ii);
                    attprops = conEnt.getProperties();
                    if ("AttributeSpec".equals(conEnt.getMetaSpec().getField("name"))) {
                        out.println("        <Attribute name=\"" + this.getDef(attprops, "Name", "") + "\" labelproperty=\"" + this.getDef(attprops, "LabelPropertyName", "") + "\" bounds=\"" + NCStringMapper.This().encode(conEnt.getModelBounds()) + "\" >");
                        out.print("            <Comment>");
                        out.print(this.getDef(attprops, "Description", ""));
                        out.println("</Comment>");
                        it = conEnt.getAttributes().iterator();
                        this.storeProperty("            ", out, it);
                        out.println("        </Attribute>");
                    } else if ("MethodSpec".equals(conEnt.getMetaSpec().getField("name"))) {
                        out.println("        <Method name=\"" + this.getDef(attprops, "Name", "") + "\" labelproperty=\"" + this.getDef(attprops, "LabelPropertyName", "") + "\" bounds=\"" + NCStringMapper.This().encode(conEnt.getModelBounds()) + "\" >");
                        out.print("            <Comment>");
                        out.print(this.getDef(attprops, "Description", ""));
                        out.println("</Comment>");
                        it = conEnt.getAttributes().iterator();
                        this.storeProperty("            ", out, it);
                        out.println("        </Method>");
                    }
                    ++ii;
                }
                out.println("    </Entity>");
            } else if ("ModelConnection".equals(entityType)) {
                props = assoc.getProperties();
                out.println("    <Connection name=\"" + props.get("Name") + "\" shape=\"" + props.get("Shape") + "\" labelproperty=\"" + props.get("LabelPropertyName") + "\" bounds=\"" + NCStringMapper.This().encode(assoc.getModelBounds()) + "\" >");
                out.print("        <Description>");
                out.print(this.getDef(props, "Description", ""));
                out.println("</Description>");
                out.println("        <Left unique=\"" + this.getDef(props, "LeftUnique", "false") + "\">");
                out.println("            <Allow>" + this.getDef(props, "AllowLeft", "false") + "</Allow>");
                out.println("        </Left>");
                out.println("        <Right unique=\"" + this.getDef(props, "RightUnique", "false") + "\">");
                out.println("            <Allow>" + this.getDef(props, "AllowRight", "false") + "</Allow>");
                out.println("        </Right>");
                Iterator conAtt = assoc.getAttributes().iterator();
                while (conAtt.hasNext()) {
                    IDataModelNode node = (IDataModelNode)conAtt.next();
                    this.writeProp("        ", node, out);
                }
                conected = ModelUtilities.This.findConnectectedEntities(model, assoc, "Contains");
                ii = 0;
                while (ii < conected.size()) {
                    conEnt = (IDataModelEntity)conected.get(ii);
                    attprops = conEnt.getProperties();
                    if ("AttributeSpec".equals(conEnt.getMetaSpec().getField("name"))) {
                        out.println("        <Properties    labelproperty=\"" + this.getDef(attprops, "LabelPropertyName", "") + "\" bounds=\"" + NCStringMapper.This().encode(conEnt.getModelBounds()) + "\" >");
                        out.print("            <Comment>");
                        out.print(this.getDef(attprops, "Description", ""));
                        out.println("</Comment>");
                        out.println("        </Properties>");
                        Iterator it2 = conEnt.getAttributes().iterator();
                        while (it2.hasNext()) {
                            IDataModelNode prop = (IDataModelNode)it2.next();
                            this.writeProp("        ", prop, out);
                        }
                    }
                    ++ii;
                }
                out.println("    </Connection>");
            }
            ++i;
        }
        out.println("</MetaModel>");
    }

    protected void storeProperty(String space, PrintStream out, Iterator it) {
        while (it.hasNext()) {
            IDataModelNode prop = (IDataModelNode)it.next();
            this.writeProp(space, prop, out);
        }
    }

    protected void writeProp(String space, IDataModelNode prop, PrintStream out) {
        out.println(space + "<Property name=\"" + prop.getProperties().get("Name") + "\" type=\"" + prop.getProperties().get("EditorType") + "\">");
        out.println(space + "    <Description>" + this.getDef(prop.getProperties(), "Description", "") + "</Description>");
        out.println(space + "    <Values>" + this.getDef(prop.getProperties(), "Values", "") + "</Values>");
        out.println(space + "    <EntityType>" + this.getDef(prop.getProperties(), "EntityType", "") + "</EntityType>");
        out.println(space + "</Property>");
    }

    private Object getDef(Map mp, String key, String def) {
        Object r = mp.get(key);
        if (r == null) {
            return def;
        }
        return r;
    }

    public void loadModel(IModellerContext modeller, Node dataFile) throws Exception {
        HashMap<Integer, IDataModelEntity> linkIdToModel = new HashMap<Integer, IDataModelEntity>();
        MetaModel model = modeller.getMetaModel();
        int i = 0;
        while (i < dataFile.getSubnodeCount()) {
            Node n = (Node)dataFile.getSubnode(i);
            String entityType = n.getName();
            if (entityType.equals("Link")) {
                int leftID = n.getIntField("leftid.content");
                int rightID = n.getIntField("rightid.content");
                String metaNodeName = n.getField("name");
                Node entity = model.findConnection(metaNodeName);
                HashMap props = this.nodeToHMap(n.getSubnodes(), n);
                String shape = entity.getField("shape");
                IDataModelEntity left = (IDataModelEntity)linkIdToModel.get(new Integer(leftID));
                IDataModelEntity right = (IDataModelEntity)linkIdToModel.get(new Integer(rightID));
                modeller.addConnection(entity, shape, right, left, props);
            } else {
                Node entity = model.findEntity(entityType);
                if (entity == null) {
                    throw new RuntimeException("Unknown Entity:" + entityType + " File does not match meta information");
                }
                Rectangle bounds = (Rectangle)NCStringMapper.This().decode(class$java$awt$Rectangle == null ? MetaModelSaver.class$("java.awt.Rectangle") : class$java$awt$Rectangle, n.getField("bounds", "0,0,100,100"));
                String label = n.getField(entity.getField("labelproperty", "Name"));
                HashMap props = this.nodeToHMap(n.getSubnode("Properties").getSubnodes(), n);
                props.remove("linkid");
                props.remove("bounds");
                IDataModelEntity ass = modeller.addEntity(entity, label, bounds, props);
                ass.setID(n.getIntField("linkid"));
                linkIdToModel.put(new Integer(ass.getID()), ass);
                XMLIterator attributes = n.getSubnodes("Attribute");
                while (attributes.hasMoreElements()) {
                    Node attNode = (Node)attributes.nextElement();
                    modeller.addAttribute(ass, this.nodeToHMap(attNode.getSubnodes(), attNode));
                }
                XMLIterator methods = n.getSubnodes("Method");
                while (methods.hasMoreElements()) {
                    Node methNode = (Node)methods.nextElement();
                    modeller.addMethod(ass, this.nodeToHMap(methNode.getSubnodes(), methNode));
                }
                modeller.updateView(ass);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

