/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import de.netcomputing.util.xml.DataNode;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import java.util.Map;

public class NodeEvaluator {
    Map props;

    public NodeEvaluator(Map p) {
        this.props = p;
    }

    public boolean evaluateAnd(DataNode n) {
        XMLIterator it = n.getSubnodes();
        while (it.hasMoreElements()) {
            Node sub = (Node)it.nextElement();
            if (this.evaluateNode(sub)) continue;
            return false;
        }
        return true;
    }

    public boolean evaluateOr(DataNode n) {
        XMLIterator it = n.getSubnodes();
        while (it.hasMoreElements()) {
            Node sub = (Node)it.nextElement();
            if (!this.evaluateNode(sub)) continue;
            return true;
        }
        return false;
    }

    public String evaluateValue(DataNode n) {
        if (n.getName().equals("prop")) {
            String key = "" + n.getField("name");
            String res = (String)this.props.get(key);
            if (res == null) {
                return "null";
            }
            return res;
        }
        if (n.getName().equals("const")) {
            String res = "" + n.getField("val");
            if (res == null) {
                return "null";
            }
            return res;
        }
        return "null";
    }

    public boolean evaluateNode(DataNode n) {
        String name = n.getName();
        if (name.equals("or")) {
            return this.evaluateOr(n);
        }
        if (name.equals("and")) {
            return this.evaluateAnd(n);
        }
        if (name.equals("not")) {
            return !this.evaluateNode(n.getSubnode(0));
        }
        if (name.equals("equals")) {
            String left = this.evaluateValue(n.getSubnode(0));
            String right = this.evaluateValue(n.getSubnode(1));
            return left.equals(right);
        }
        if (name.equals("contains")) {
            String right;
            String left = this.evaluateValue(n.getSubnode(0));
            return left.indexOf(right = this.evaluateValue(n.getSubnode(1))) >= 0;
        }
        if (name.equals("greater")) {
            String right;
            String left = this.evaluateValue(n.getSubnode(0));
            return left.compareTo(right = this.evaluateValue(n.getSubnode(1))) > 0;
        }
        if (name.equals("lesser")) {
            String right;
            String left = this.evaluateValue(n.getSubnode(0));
            return left.compareTo(right = this.evaluateValue(n.getSubnode(1))) < 0;
        }
        return true;
    }
}

