/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.propertystore;

import de.netcomputing.propertystore.AbstractPropertyNode;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class PropertyNode
extends AbstractPropertyNode
implements Serializable {
    Hashtable subNodes;
    String name;
    String value;
    String description;
    private static final long serialVersionUID = 1421746759512286394L;

    public PropertyNode(String name, String value) {
        this.name = name;
        this.value = value;
        this.subNodes = new Hashtable(17);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void remChildren() {
        this.subNodes.clear();
    }

    public void setValue(String val) {
        this.value = val;
    }

    public AbstractPropertyNode getNode(String name) {
        return (AbstractPropertyNode)this.subNodes.get(name);
    }

    void addNode(String name, AbstractPropertyNode node) {
        this.subNodes.put(name, node);
    }

    public void addNode(AbstractPropertyNode node) {
        this.subNodes.put(node.getName(), node);
    }

    public void clear() {
        this.subNodes.clear();
    }

    public void remNode(AbstractPropertyNode node) {
        this.subNodes.remove(node.getName());
    }

    public Enumeration getSubnodes() {
        return this.subNodes.elements();
    }

    public AbstractPropertyNode copyDeep() {
        PropertyNode result = new PropertyNode(this.getName(), this.getValue());
        result.setDescription(this.getDescription());
        Enumeration en = this.getSubnodes();
        while (en.hasMoreElements()) {
            AbstractPropertyNode next = (AbstractPropertyNode)en.nextElement();
            result.addNode(next.copyDeep());
        }
        return result;
    }

    public int getSubnodesSize() {
        return this.subNodes.size();
    }
}

