/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.runtime;

import de.netcomputing.runtime.SmallMemTable;
import de.netcomputing.runtime.SwingInstantiator;
import de.netcomputing.runtime.XMLInstantiator;
import de.netcomputing.runtime.XMLNode;
import de.netcomputing.util.Tracer;
import java.io.PrintStream;

public class XMLTag
extends XMLNode {
    String name;
    SmallMemTable attributes;
    XMLNode children;
    XMLNode last;

    public XMLTag(String n) {
        super(null);
        this.name = n;
    }

    public void setAttributes(SmallMemTable att) {
        this.attributes = att;
    }

    public SmallMemTable getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SmallMemTable(13);
        }
        return this.attributes;
    }

    public void setChildren(XMLNode children) {
        this.children = children;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public XMLNode getChildren() {
        return this.children;
    }

    public void add(XMLTag toAdd) {
        if (this.last == null) {
            this.last = toAdd;
        }
        if (this.children == null) {
            this.children = toAdd;
            return;
        }
        this.last.next = toAdd;
        this.last = toAdd;
    }

    public String getString(String val) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.getAttributes().get(val);
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public void remAttr(String val) {
        this.getAttributes().remove(val);
    }

    public String getSaveString(String val) {
        if (this.attributes == null) {
            return "";
        }
        Object tmp = this.getAttributes().get(val);
        if (tmp == null) {
            return "";
        }
        return tmp.toString();
    }

    public void dump(PrintStream out, int hl) {
        XMLNode act = this.children;
        int n = 0;
        while (n < hl) {
            out.print("\t");
            ++n;
        }
        out.println("<" + this.name + ">");
        while (act != null) {
            ((XMLTag)act).dump(out, hl + 1);
            act = act.getNext();
        }
        int n2 = 0;
        while (n2 < hl) {
            out.print("\t");
            ++n2;
        }
        out.println("</" + this.name + ">");
    }

    public int[] getMultiInt(String key, int length) {
        String s = this.getString(key);
        return XMLInstantiator.ParseMultiInt(s, length);
    }

    public int getHexInt(String key) {
        String s = null;
        try {
            s = this.getString(key);
            if (s == null || s.length() == 0) {
                return Integer.MAX_VALUE;
            }
            s = s.trim().toUpperCase();
            int res = 0;
            int pot = 1;
            int n = s.length() - 1;
            while (n >= 0) {
                int c = s.charAt(n) - 48;
                if (c > 9) {
                    c -= 7;
                }
                if (c > 15) break;
                res += c * pot;
                pot *= 16;
                --n;
            }
            return res;
        }
        catch (Exception e) {
            if (SwingInstantiator.DEBUG) {
                e.printStackTrace();
                Tracer.This.println(key + "'" + s + "'");
            }
            return Integer.MAX_VALUE;
        }
    }

    public int getInt(String key) {
        Object o = this.attributes.get(key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String s = null;
        try {
            s = this.getString(key);
            if (s == null || s.length() == 0) {
                return Integer.MAX_VALUE;
            }
            int i = Integer.parseInt(s.trim());
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
            Tracer.This.println(key + "'" + s + "'");
            return Integer.MAX_VALUE;
        }
    }
}

