/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.CollapsedPanelBarListener;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.DockingComponentWrapper;
import de.netcomputing.swingx.DockingContainer;
import de.netcomputing.swingx.PanelEntry;
import de.netcomputing.swingx.SplitButton;
import de.netcomputing.swingx.ToolBumps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CollapsedPanelBar
extends JPanel {
    ArrayList components = new ArrayList();
    boolean allowCollapse = true;
    boolean lookLikeWindoze = true;
    Vector listeners = new Vector(7);
    JToggleButton startBtn;
    JPopupMenu startMenu;

    public CollapsedPanelBar() {
        this(false);
    }

    public CollapsedPanelBar(boolean windozeAlike) {
        this.lookLikeWindoze = windozeAlike;
        this.setLayout(new FlowLayout(0, 1, 1));
        if (this.lookLikeWindoze) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
        }
    }

    public CollapsedPanelBar(JPopupMenu menu, String startButtonTitle, Icon icon) {
        this(true);
        this.setStartMenu(menu);
        this.startBtn = this.createStartButton(startButtonTitle, icon);
        this.add(this.startBtn);
        this.startBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    CollapsedPanelBar.this.openStartMenu();
                }
            }
        });
    }

    public boolean isCollapsed(JComponent comp) {
        PanelEntry pEntry;
        if (comp instanceof DockingComponentWrapper) {
            comp = ((DockingComponentWrapper)comp).getContentPanel();
        }
        return (pEntry = this.panelFor(comp)) != null && pEntry.openButton != null && pEntry.openButton.getParent() == this;
    }

    public void setStartMenu(JPopupMenu aStartMenu) {
        if (aStartMenu == null) {
            return;
        }
        this.startMenu = aStartMenu;
        this.startMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (2.access$000(this.this$1).startBtn.isSelected()) {
                            2.access$000(this.this$1).startBtn.setSelected(false);
                        }
                    }
                });
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            static /* synthetic */ CollapsedPanelBar access$000(2 x0) {
                return x0.CollapsedPanelBar.this;
            }
        });
    }

    public JPopupMenu getStartMenu() {
        return this.startMenu;
    }

    public void openStartMenu() {
        if (this.startMenu == null) {
            return;
        }
        int x = this.startBtn.getX();
        int y = -this.startMenu.getPreferredSize().height + this.startBtn.getY();
        this.startMenu.show(this, x, y);
    }

    public void addCollapedPanelBarListener(CollapsedPanelBarListener li) {
        if (!this.listeners.contains(li)) {
            this.listeners.add(li);
        }
    }

    public void removeCollapedPanelBarListener(CollapsedPanelBarListener li) {
        this.listeners.remove(li);
    }

    void fireCollaped(DockingComponentWrapper wrapper) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((CollapsedPanelBarListener)this.listeners.get(i)).componentMinimized(wrapper);
            ++i;
        }
    }

    void fireUnCollaped(DockingComponentWrapper wrapper) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((CollapsedPanelBarListener)this.listeners.get(i)).componentDeMinimized(wrapper);
            ++i;
        }
    }

    public DockingComponentWrapper addDockedComponent(JComponent comp, DockingComponentInfo info) {
        if (comp instanceof DockingComponentWrapper) {
            throw new RuntimeException("Can't add this");
        }
        return this.addDockedComponent(comp, info, false);
    }

    DockingComponentWrapper addDockedComponent(JComponent comp, DockingComponentInfo info, boolean horizontal) {
        if (comp instanceof DockingComponentWrapper) {
            throw new RuntimeException("Can't add this");
        }
        JButton closeBtn = this.createCloseButton(comp.getMinimumSize().width, horizontal, info);
        DockingComponentWrapper intermediate = new DockingComponentWrapper(closeBtn, comp, info, horizontal);
        PanelEntry pe = new PanelEntry(comp, closeBtn);
        MyMouseListener myml = new MyMouseListener(pe, info);
        if (info.getShowTitleBar()) {
            intermediate.getTitleBar().getMinimizeBtn().addMouseListener(myml);
        } else {
            closeBtn.addMouseListener(myml);
        }
        closeBtn.addMouseMotionListener(myml);
        if (!this.lookLikeWindoze) {
            closeBtn.setToolTipText(info.getTitle());
        }
        this.components.add(pe);
        return intermediate;
    }

    public void setAllowCollapse(boolean allowCollapse) {
        this.allowCollapse = allowCollapse;
    }

    public boolean getAllowCollapse() {
        return this.allowCollapse;
    }

    protected void closeComponent(JComponent comp, DockingComponentInfo info) {
        JButton opnBtn;
        PanelEntry en;
        if (comp instanceof DockingComponentWrapper) {
            comp = ((DockingComponentWrapper)comp).getContentPanel();
        }
        if ((en = this.panelFor(comp)) == null) {
            return;
        }
        en.getDockingWrapper().setVisible(false);
        en.closeButton.setVisible(false);
        DockingComponentWrapper dcWrapper = DockingContainer.findDockingWrapper(en.getDockingWrapper());
        en.openButton = opnBtn = this.createOpenButton(en.closeButton.getHeight(), info);
        this.add(opnBtn);
        if (!this.lookLikeWindoze) {
            opnBtn.setToolTipText(en.getDockingWrapper().getInfo().getTitle());
        }
        opnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CollapsedPanelBar.this.openComponent(en.comp);
            }
        });
        en.getDockingWrapper().getParent().invalidate();
        this.invalidate();
        Frame w = (Frame)this.getTopLevelAncestor();
        if (w != null && !w.isResizable()) {
            w.setResizable(true);
            w.pack();
            w.setResizable(false);
        } else {
            this.repaint();
            en.getDockingWrapper().getParent().repaint();
        }
        this.fireCollaped(en.getDockingWrapper());
    }

    public void collapseComponent(JComponent comp) {
        if (comp instanceof DockingComponentWrapper) {
            comp = ((DockingComponentWrapper)comp).getContentPanel();
        }
        if (this.isCollapsed(comp)) {
            return;
        }
        PanelEntry pEntry = this.panelFor(comp);
        if (pEntry != null) {
            this.closeComponent(comp, pEntry.getDockingWrapper().getInfo());
        }
    }

    public void updateInfo(JComponent oldcomp, DockingComponentWrapper dcWrapper) {
        PanelEntry pEntry = this.panelFor(oldcomp);
        if (pEntry != null) {
            pEntry.comp = dcWrapper.getContentPanel();
            if (pEntry.openButton != null) {
                pEntry.openButton.setText(dcWrapper.getInfo().getTitle());
            }
        }
    }

    public void openComponent(JComponent comp) {
        PanelEntry en = this.panelFor(comp);
        if (en == null) {
            return;
        }
        en.getDockingWrapper().setVisible(true);
        en.closeButton.setVisible(true);
        this.remove(en.openButton);
        en.openButton = null;
        en.getDockingWrapper().getParent().invalidate();
        en.getDockingWrapper().getParent().repaint();
        this.invalidate();
        Frame w = (Frame)this.getTopLevelAncestor();
        if (!w.isResizable()) {
            w.setResizable(true);
            w.pack();
            w.setResizable(false);
        } else {
            this.repaint();
        }
        this.fireUnCollaped(en.getDockingWrapper());
    }

    public void clear() {
        this.removeAll();
        this.components.clear();
        if (this.startBtn != null) {
            this.add(this.startBtn);
        }
        this.repaint();
    }

    public void remove(Component comp) {
        if (comp instanceof DockingComponentWrapper) {
            comp = ((DockingComponentWrapper)comp).getContentPanel();
        }
        if (comp == null) {
            return;
        }
        int i = this.components.size() - 1;
        while (i >= 0) {
            PanelEntry pe = (PanelEntry)this.components.get(i);
            if (pe.comp == comp) {
                if (pe.openButton != null) {
                    super.remove(pe.openButton);
                }
                this.components.remove(i);
                break;
            }
            --i;
        }
        super.remove(comp);
    }

    PanelEntry panelFor(JComponent comp) {
        int i = this.indexOf(comp);
        if (i >= 0) {
            return (PanelEntry)this.components.get(i);
        }
        return null;
    }

    int indexOf(JComponent comp) {
        int i = 0;
        while (i < this.components.size()) {
            PanelEntry en = (PanelEntry)this.components.get(i);
            if (en.comp == comp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JButton createCloseButton(int widthWhenCollapsed, boolean horizontal, DockingComponentInfo info) {
        if (horizontal) {
            JButton btn = null;
            switch (info.getButtonType()) {
                default: {
                    btn = new ToolBumps(false, true, 0);
                    btn.setMargin(new Insets(0, 0, 0, 0));
                    break;
                }
                case 2: {
                    btn = new SplitButton(horizontal);
                    btn.setMargin(new Insets(0, 0, 0, 0));
                }
            }
            btn.setBorderPainted(false);
            btn.setFocusPainted(false);
            return btn;
        }
        JButton btn = null;
        switch (info.getButtonType()) {
            default: {
                btn = new SplitButton(horizontal);
                btn.setMargin(new Insets(0, 0, 0, 0));
                break;
            }
            case 1: {
                btn = new ToolBumps(false, horizontal, 0);
                btn.setMargin(new Insets(1, 1, 1, 1));
            }
        }
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setOpaque(false);
        return btn;
    }

    protected JToggleButton createStartButton(String title, Icon icon) {
        JToggleButton btn = new JToggleButton(title);
        btn.setFocusPainted(false);
        btn.setMargin(new Insets(1, 1, 2, 4));
        if (icon != null) {
            btn.setIcon(icon);
        }
        return btn;
    }

    protected JButton createOpenButton(int width, DockingComponentInfo info) {
        if (this.lookLikeWindoze) {
            JButton btn = new JButton(info.getTitle());
            btn.setFocusPainted(false);
            btn.setMargin(new Insets(0, 2, 0, 2));
            return btn;
        }
        ToolBumps btn = new ToolBumps(true, true, Math.max(35, Math.min(width, this.getWidth() / this.components.size())));
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        return btn;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.getContentPane().setLayout(new BorderLayout(0, 0));
        CollapsedPanelBar sbs = new CollapsedPanelBar(null, "Start", null);
        jf.getContentPane().add("South", sbs);
        JButton south = new JButton("South");
        JButton center = new JButton("Center");
        JButton west = new JButton("West");
        JButton east = new JButton("East");
        DockingComponentInfo sp = new DockingComponentInfo("FELIX");
        sp.setButtonType(2);
        jf.getContentPane().add("North", sbs.addDockedComponent(south, sp));
        sp = new DockingComponentInfo("MOELLER");
        sp.setButtonType(2);
        jf.getContentPane().add("Center", sbs.addDockedComponent(center, sp));
        sp = new DockingComponentInfo("XILEF");
        sp.setButtonType(2);
        jf.getContentPane().add("West", sbs.addDockedComponent(west, sp));
        sp = new DockingComponentInfo("RELLEOM");
        sp.setButtonType(2);
        jf.getContentPane().add("East", sbs.addDockedComponent(east, sp));
        jf.pack();
        jf.show();
    }

    class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        DockingComponentInfo info;
        PanelEntry pe;
        boolean dragging = false;

        public MyMouseListener(PanelEntry c, DockingComponentInfo spInfo) {
            this.pe = c;
            this.info = spInfo;
        }

        public void mouseDragged(MouseEvent e) {
            this.dragging = true;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent ev) {
            if (CollapsedPanelBar.this.allowCollapse && this.info.getCanHide() && (!this.dragging || this.info.getShowTitleBar())) {
                CollapsedPanelBar.this.closeComponent(this.pe.comp, this.info);
            }
            this.dragging = false;
        }
    }
}

