/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.swingx.CollapsedPanelBar;
import de.netcomputing.swingx.CollapsedPanelBarListener;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.DockingComponentWrapper;
import de.netcomputing.swingx.DockingContainer;
import de.netcomputing.swingx.DockingContainerListener;
import de.netcomputing.swingx.DockingDesktopListener;
import de.netcomputing.swingx.IDockingContainer;
import de.netcomputing.util.Tracer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DockingDesktop
extends JPanel {
    CollapsedPanelBar subPanelStack;
    CollapsedPanelBar superBar;
    DockingContainer centerDock;
    Vector listeners = new Vector(7);
    boolean isVert = false;
    int defaultMaxComps = 0;
    boolean ignoreRepaint = false;
    protected final int selHistoryLen = 3;
    protected DockingComponentWrapper[] lastSelection = new DockingComponentWrapper[3];
    protected int selHistoryPointer = 0;
    int titleCount = 0;

    public static void SetWindowFocus(JComponent active) {
        DockingDesktop dt = DockingContainer.findDockingDesktop(active);
        if (dt != null) {
            DockingComponentWrapper dcWrapper = DockingContainer.findWindowedDockingWrapper(active);
            DockingContainer dContainer = DockingContainer.findDockingContainer(active);
            if (dcWrapper != null && dContainer != null) {
                dt.handleActivation(dContainer, dcWrapper);
            }
        }
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.ignoreRepaint = ignoreRepaint;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public void paintAll(Graphics graphics) {
        if (!this.ignoreRepaint) {
            super.paintAll(graphics);
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (!this.ignoreRepaint) {
            super.repaint(tm, x, y, width, height);
        }
    }

    public void init() {
        this.init(null, null, null);
        this.subPanelStack.setStartMenu(this.createStartMenu());
        this.subPanelStack.setBorder(BorderFactory.createEtchedBorder());
    }

    public void init(JPopupMenu menu, String startButtonTitle, Icon icon) {
        Image im;
        this.setLayout(new BorderLayout());
        if (icon == null && (im = this.getStartButtonImage()) != null) {
            icon = new ImageIcon(im);
        }
        if (startButtonTitle == null) {
            startButtonTitle = this.getStartMenuTitle();
        }
        this.subPanelStack = new CollapsedPanelBar(menu, startButtonTitle, icon);
        this.centerDock = (DockingContainer)this.createNewDockingContainer(null, new DockingComponentInfo[]{null}, this.isVert, 0, true);
        if (this.superBar != null) {
            this.add("South", this.superBar.addDockedComponent(this.subPanelStack, DockingComponentInfo.CollBar("Task Bar")));
        } else {
            this.add("South", this.subPanelStack);
        }
        this.add("Center", this.centerDock);
        this.subPanelStack.addCollapedPanelBarListener(new CollapsedPanelBarListener(){

            public void componentMinimized(DockingComponentWrapper wrapper) {
                DockingDesktop.this.panelHasBeenMinimized(DockingContainer.findDockingContainer(wrapper), wrapper);
            }

            public void componentDeMinimized(DockingComponentWrapper wrapper) {
                DockingDesktop.this.panelHasBeenDeMinimized(DockingContainer.findDockingContainer(wrapper), wrapper);
            }
        });
    }

    public DockingContainer getCenterDock() {
        return this.centerDock;
    }

    public void setSuperBar(CollapsedPanelBar cpBar) {
        this.superBar = cpBar;
    }

    public void setIsVert(boolean isVert) {
        this.isVert = isVert;
    }

    public boolean getIsVert() {
        return this.isVert;
    }

    public void clear() {
        List l = this.findWindowedDockingWrappers();
        int i = 0;
        while (i < l.size()) {
            DockingComponentWrapper dcWrapper = (DockingComponentWrapper)l.get(i);
            this.fireComponentClosed(dcWrapper);
            ++i;
        }
        this.remove(this.centerDock);
        this.subPanelStack.clear();
        this.centerDock = (DockingContainer)this.createNewDockingContainer(null, new DockingComponentInfo[]{null}, this.isVert, 0, true);
        this.add("Center", this.centerDock);
        this.repaint();
    }

    public CollapsedPanelBar getCollapsedPanelBar() {
        return this.subPanelStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList setLayoutConfiguration(String config, final Object userContext) {
        try {
            DockingContainer.disableLayoutRecalling = true;
            System.out.println("SETCONFIG:" + config);
            this.clear();
            DockingContainer currentVContainer = this.centerDock;
            DockingContainer currentHContainer = (DockingContainer)this.centerDock.getDockedComponent(0).getContentPanel();
            boolean isFirstVEmptyPanel = true;
            boolean isFirstHEmptyPanel = true;
            int sizeIdx = config.indexOf(":");
            int widthIdx = config.indexOf(",");
            Dimension winSize = new Dimension(Integer.parseInt(config.substring(0, widthIdx)), Integer.parseInt(config.substring(widthIdx + 1, sizeIdx)));
            if (this.getTopLevelAncestor() == null || winSize.width > 0) {
                // empty if block
            }
            ArrayList<Runnable> doThisStuffLater = new ArrayList<Runnable>(15);
            int i = 0;
            while (i < config.length()) {
                if (config.charAt(i) == '-') {
                    int numEndIdx = config.indexOf(44, i);
                    int saveIdEndIdx = config.indexOf(58, numEndIdx);
                    String saveId = config.substring(numEndIdx + 1, saveIdEndIdx);
                    String num = config.substring(i + 1, numEndIdx);
                    int height = Integer.parseInt(num);
                    i = numEndIdx;
                    if (!isFirstVEmptyPanel) {
                        currentVContainer.addEmptyComponent();
                        currentHContainer = (DockingContainer)this.centerDock.getDockedComponent(0).getContentPanel();
                        isFirstHEmptyPanel = true;
                    }
                    final DockingComponentWrapper toResize = this.centerDock.getDockedComponent(0);
                    final int finalHeight = height;
                    doThisStuffLater.add(new Runnable(){

                        public void run() {
                            toResize.setSize(5, finalHeight);
                        }
                    });
                    isFirstVEmptyPanel = false;
                } else if (config.charAt(i) == '|') {
                    boolean minimized = false;
                    if (config.charAt(i + 1) == 'm') {
                        ++i;
                        minimized = true;
                    }
                    int numEndIdx = config.indexOf(44, i);
                    String num = config.substring(i + 1, numEndIdx);
                    int saveIdEndIdx = config.indexOf(58, numEndIdx);
                    final String saveId = config.substring(numEndIdx + 1, saveIdEndIdx);
                    int width = Integer.parseInt(num);
                    i = numEndIdx;
                    if (!isFirstHEmptyPanel) {
                        currentHContainer.addEmptyComponent();
                    }
                    final DockingComponentWrapper toResize = currentHContainer.getDockedComponent(0);
                    if (minimized) {
                        this.setMinimized(toResize.getContentPanel(), true);
                    }
                    final int finalWidth = width;
                    boolean finalMini = minimized;
                    doThisStuffLater.add(new Runnable(){

                        public void run() {
                            toResize.setSize(finalWidth, 5);
                            JComponent prevComp = toResize.getContentPanel();
                            JComponent comp = DockingDesktop.this.createFromSaveId(saveId, userContext, toResize.getInfo());
                            if (comp instanceof DockingComponentWrapper) {
                                DockingComponentWrapper dcWrapper = (DockingComponentWrapper)comp;
                                JComponent prevComponent = dcWrapper.getContentPanel();
                                toResize.setInfo(dcWrapper.getInfo());
                                toResize.setContentPanel(dcWrapper.getContentPanel(), DockingDesktop.this.subPanelStack);
                            } else if (comp != null) {
                                toResize.setContentPanel(comp, DockingDesktop.this.subPanelStack);
                            } else {
                                throw new RuntimeException("do this later");
                            }
                        }
                    });
                    isFirstHEmptyPanel = false;
                }
                ++i;
            }
            int i2 = doThisStuffLater.size() - 1;
            while (i2 >= 0) {
                try {
                    ((Runnable)doThisStuffLater.get(i2)).run();
                    doThisStuffLater.remove(i2);
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace(Tracer.This);
                }
                --i2;
            }
            this.invalidate();
            System.out.println("GETCONFIG:" + this.getLayoutConfiguration(null));
            ArrayList<Runnable> arrayList = doThisStuffLater;
            Object var22_28 = null;
            DockingContainer.disableLayoutRecalling = false;
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var22_29 = null;
            DockingContainer.disableLayoutRecalling = false;
            throw throwable;
        }
    }

    protected JComponent createFromSaveId(String saveId, Object userContext, DockingComponentInfo info) {
        return null;
    }

    public String getLayoutConfiguration(Object userContext) {
        StringBuffer result = new StringBuffer(400);
        Dimension size = ((Window)this.getTopLevelAncestor()).getSize();
        result.append(size.width + "," + size.height + ":");
        int i = this.centerDock.getDockedComponentCount() - 1;
        while (i >= 0) {
            DockingContainer dContainer;
            DockingComponentWrapper component = this.centerDock.getDockedComponent(i);
            if (component.getContentPanel() instanceof IDockingContainer && !(dContainer = (DockingContainer)component.getContentPanel()).isEmpty()) {
                result.append("-" + component.getHeight() + ",");
                int ii = dContainer.getDockedComponentCount() - 1;
                while (ii >= 0) {
                    DockingComponentWrapper subComp = dContainer.getDockedComponent(ii);
                    this.prepareForSave(subComp, userContext);
                    if (subComp.getSaveId() != null) {
                        if (subComp.isVisible()) {
                            result.append("|");
                        } else {
                            result.append("|m");
                        }
                        result.append(subComp.getWidth() + "," + subComp.getSaveId() + ":");
                    }
                    --ii;
                }
            }
            --i;
        }
        return result.toString();
    }

    protected void prepareForSave(DockingComponentWrapper dcWrapper, Object userContext) {
    }

    public List findWindowedDockingWrappers() {
        Vector result = new Vector();
        JWidgetsUtil.AllComponents(result, this.centerDock);
        int i = result.size() - 1;
        while (i >= 0) {
            if (!(result.get(i) instanceof DockingComponentWrapper)) {
                result.remove(i);
            } else {
                DockingComponentWrapper dcWrapper = (DockingComponentWrapper)result.get(i);
                if (!dcWrapper.getInfo().getShowTitleBar()) {
                    result.remove(i);
                }
            }
            --i;
        }
        return result;
    }

    protected String getStartMenuTitle() {
        return "Demo";
    }

    protected Image getStartButtonImage() {
        return NCApplication.GetImage("/de/netcomputing/swingx/images/startdefault.gif");
    }

    public JPopupMenu createStartMenu() {
        JMenu men = new JMenu("Test");
        men.add(new JMenuItem("One"));
        men.add(new JMenuItem("Two"));
        men.add(new JMenuItem("Three"));
        men.add(new JMenuItem("One"));
        men.add(new JMenuItem("Two"));
        men.add(new JMenuItem("Three"));
        men.add(new JMenuItem("One"));
        men.add(new JMenuItem("Two"));
        men.add(new JMenuItem("Three"));
        final Image im = this.getMenuImage();
        JPopupMenu popMenu = new JPopupMenu(){

            public Insets getInsets() {
                return new Insets(2, im.getWidth(this), 2, 2);
            }

            public void paint(Graphics g) {
                super.paint(g);
                int imh = im.getHeight(this);
                g.drawImage(im, 0, this.getHeight() - imh, this);
                g.setColor(Color.black);
                g.drawRect(0, 0, im.getWidth(this) - 1, this.getHeight() - 1);
            }
        };
        popMenu.add(men);
        popMenu.add("Eins");
        popMenu.add("Zwei");
        popMenu.add("Drei");
        popMenu.add("Eins");
        popMenu.add("Zwei");
        popMenu.add("Drei");
        return popMenu;
    }

    protected Image getMenuImage() {
        return NCApplication.GetImage("/de/netcomputing/swingx/images/menudef.gif");
    }

    public void addDockingDesktopListener(DockingDesktopListener li) {
        if (!this.listeners.contains(li)) {
            this.listeners.add(li);
        }
    }

    public void removeDockingDesktopListener(DockingDesktopListener li) {
        this.listeners.remove(li);
    }

    public void fireComponentAdded(DockingComponentWrapper dcWrapper) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingDesktopListener)this.listeners.get(i)).componentCreated(dcWrapper);
            ++i;
        }
    }

    protected void fireSelectionChanged(DockingComponentWrapper dcOldWrapperPrimary, DockingComponentWrapper dcOldWrapperSecondary) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingDesktopListener)this.listeners.get(i)).selectionChanged(dcOldWrapperPrimary, dcOldWrapperSecondary);
            ++i;
        }
    }

    protected void fireComponentClosed(DockingComponentWrapper dcWrapper) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingDesktopListener)this.listeners.get(i)).componentClosed(dcWrapper);
            ++i;
        }
    }

    protected void fireComponentMinimized(DockingComponentWrapper dcWrapper) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingDesktopListener)this.listeners.get(i)).componentMinimized(dcWrapper);
            ++i;
        }
    }

    protected void fireComponentDeMinimized(DockingComponentWrapper dcWrapper) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((DockingDesktopListener)this.listeners.get(i)).componentDeMinimized(dcWrapper);
            ++i;
        }
    }

    private JComponent createNewDockingContainer(IDockingContainer parent, DockingComponentInfo[] resultInfo, final boolean horiz, final int depth, boolean createInitial) {
        if (depth < 2) {
            resultInfo[0] = new DockingComponentInfo("");
            resultInfo[0].setShowTitleBar(false);
            resultInfo[0].setCanHide(false);
            resultInfo[0].setButtonType(2);
            final DockingContainer[] newDockingContainer = new DockingContainer[]{null};
            newDockingContainer[0] = new DockingContainer(this.subPanelStack, horiz){

                public JComponent createNewComponent(DockingComponentInfo[] resultInfo) {
                    return DockingDesktop.this.createNewDockingContainer(newDockingContainer[0], resultInfo, !horiz, depth + 1, true);
                }

                protected void wrapperAdded(DockingComponentWrapper dcWrapper) {
                    DockingDesktop.this.initDCWrapper(newDockingContainer[0], dcWrapper);
                }

                public DockingContainer createAutoWrapDockingContainer(DockingComponentWrapper sp) {
                    if (depth == 0) {
                        DockingContainer dContainer = (DockingContainer)DockingDesktop.this.createNewDockingContainer(newDockingContainer[0], new DockingComponentInfo[]{null}, !horiz, depth + 1, false);
                        return dContainer;
                    }
                    return null;
                }
            };
            newDockingContainer[0].setMaxComponents(this.defaultMaxComps);
            newDockingContainer[0].addDockingContainerListener(new DockingContainerListener(){

                public void componentRemovedToOtherContainer(IDockingContainer oldCont, DockingComponentWrapper dcWrapper) {
                    DockingDesktop.this.panelHasMovedFromContainer(oldCont, dcWrapper);
                }

                public void componentDroppedFromOtherContainer(DockingComponentWrapper dcWrapper) {
                    DockingDesktop.this.panelHasDroppedFromOtherContainer(newDockingContainer[0], dcWrapper);
                }
            });
            if (parent == null) {
                DockingComponentWrapper dcWrapper = newDockingContainer[0].addComponent(this.createNewDockingContainer(newDockingContainer[0], resultInfo, !horiz, depth + 1, true), resultInfo[0], !horiz);
                return newDockingContainer[0];
            }
            if (createInitial) {
                DockingComponentInfo[] emptyInfo = new DockingComponentInfo[]{null};
                JComponent emptyPanel = this.createEmptyPanel(emptyInfo);
                if (depth == 0) {
                    emptyInfo[0].setTitle(null);
                }
                DockingComponentWrapper dcWrapper = newDockingContainer[0].addComponent(emptyPanel, emptyInfo[0], !horiz);
            }
            return newDockingContainer[0];
        }
        JComponent emptyPanel = this.createEmptyPanel(resultInfo);
        return emptyPanel;
    }

    public void setMinimized(JComponent contentComponent, boolean min) {
        DockingComponentWrapper dcWrapper = null;
        if (contentComponent instanceof DockingComponentWrapper) {
            dcWrapper = (DockingComponentWrapper)contentComponent;
            contentComponent = dcWrapper.getContentPanel();
        } else {
            dcWrapper = DockingContainer.findDockingWrapper(contentComponent);
        }
        if (dcWrapper != null) {
            if (min) {
                this.subPanelStack.collapseComponent(contentComponent);
            } else {
                this.subPanelStack.openComponent(contentComponent);
            }
        }
    }

    protected void initDCWrapper(final IDockingContainer parent, final DockingComponentWrapper dcWrapper) {
        if (dcWrapper.getTitleBar() != null) {
            dcWrapper.getTitleBar().getCloseBtn().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    DockingDesktop.this.closePanel(parent, dcWrapper);
                }
            });
            dcWrapper.getTitleBar().addTitleMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseevent) {
                    DockingDesktop.this.handleActivation(parent, dcWrapper);
                }
            });
        }
    }

    public DockingComponentWrapper getPrimarySelection() {
        return this.lastSelection[(this.selHistoryPointer + 3 - 1) % 3];
    }

    public DockingComponentWrapper getSecondarySelection() {
        return this.lastSelection[(this.selHistoryPointer + 3 - 2) % 3];
    }

    protected void setPrimarySelection(DockingComponentWrapper dcWrapper) {
        this.lastSelection[(this.selHistoryPointer + 3 - 1) % 3] = dcWrapper;
    }

    protected void setSecondarySelection(DockingComponentWrapper dcWrapper) {
        this.lastSelection[(this.selHistoryPointer + 3 - 2) % 3] = dcWrapper;
    }

    protected void panelHasDroppedFromOtherContainer(IDockingContainer dockingParent, DockingComponentWrapper dcWrapper) {
        if (dockingParent instanceof DockingContainer) {
            ((DockingContainer)dockingParent).recallCurrentLayout();
        }
    }

    protected void panelHasMovedFromContainer(IDockingContainer dockingParent, DockingComponentWrapper dcWrapper) {
        IDockingContainer parent = dockingParent;
        if (dockingParent instanceof DockingContainer) {
            ((DockingContainer)dockingParent).recallCurrentLayout();
        }
        if (!parent.isAnyComponentVisible()) {
            ((JComponent)((Object)parent)).setVisible(false);
            IDockingContainer idcContainer = parent.getDockingParent();
            if (idcContainer != null) {
                ((JComponent)((Object)idcContainer)).invalidate();
                ((JComponent)((Object)idcContainer)).validate();
                ((JComponent)((Object)idcContainer)).repaint();
            }
        }
    }

    protected void panelHasBeenMinimized(IDockingContainer dockingParent, DockingComponentWrapper dcWrapper) {
        IDockingContainer parent = dockingParent;
        if (dockingParent instanceof DockingContainer) {
            ((DockingContainer)dockingParent).recallCurrentLayout();
        }
        if (!parent.isAnyComponentVisible()) {
            ((JComponent)((Object)parent)).setVisible(false);
            IDockingContainer idcContainer = parent.getDockingParent();
            if (idcContainer != null) {
                ((JComponent)((Object)idcContainer)).invalidate();
                ((JComponent)((Object)idcContainer)).validate();
                ((JComponent)((Object)idcContainer)).repaint();
            }
        }
        this.fireComponentMinimized(dcWrapper);
    }

    protected void panelHasBeenDeMinimized(IDockingContainer dockingParent, DockingComponentWrapper dcWrapper) {
        IDockingContainer parent = dockingParent;
        if (dockingParent instanceof DockingContainer) {
            ((DockingContainer)dockingParent).recallCurrentLayout();
        }
        if (parent.isAnyComponentVisible()) {
            ((JComponent)((Object)parent)).setVisible(true);
            IDockingContainer idcContainer = parent.getDockingParent();
            if (idcContainer != null) {
                ((JComponent)((Object)idcContainer)).invalidate();
                ((JComponent)((Object)idcContainer)).validate();
                ((JComponent)((Object)idcContainer)).repaint();
            }
        }
        this.fireComponentDeMinimized(dcWrapper);
    }

    public void handleActivation(IDockingContainer parent, DockingComponentWrapper dcWrapper) {
        if (dcWrapper == this.getPrimarySelection() || dcWrapper.getTitleBar() == null) {
            return;
        }
        DockingComponentWrapper oldPrimary = this.getPrimarySelection();
        DockingComponentWrapper oldSecondary = this.getSecondarySelection();
        if (this.getPrimarySelection() != null) {
            this.getPrimarySelection().getTitleBar().setActivationState(2);
        }
        if (this.getSecondarySelection() != null) {
            this.getSecondarySelection().getTitleBar().setActivationState(0);
        }
        this.lastSelection[this.selHistoryPointer] = dcWrapper;
        this.selHistoryPointer = (this.selHistoryPointer + 1) % 3;
        dcWrapper.getTitleBar().setActivationState(1);
        this.fireSelectionChanged(oldPrimary, oldSecondary);
    }

    protected void closePanel(IDockingContainer parent, DockingComponentWrapper dcWrapper) {
        IDockingContainer idcContainer;
        parent.removeDockingComponent(dcWrapper);
        ((JComponent)((Object)parent)).invalidate();
        ((JComponent)((Object)parent)).validate();
        ((JComponent)((Object)parent)).repaint();
        if (parent.isEmpty() && (idcContainer = parent.getDockingParent()) != null) {
            idcContainer.removeDockingComponent((JComponent)((Object)parent));
            this.invalidate();
            this.validate();
            this.repaint();
        }
        this.removeFromSelection(dcWrapper);
        this.fireComponentClosed(dcWrapper);
        if (this.findWindowedDockingWrappers().size() == 0) {
            this.clear();
            this.invalidate();
            this.validate();
            this.repaint();
        }
        if (parent instanceof DockingContainer) {
            ((DockingContainer)parent).recallCurrentLayout();
        }
    }

    void removeFromSelection(DockingComponentWrapper dw) {
        int i = 0;
        while (i < this.lastSelection.length) {
            if (this.lastSelection[i] == dw) {
                this.lastSelection[i] = null;
            }
            ++i;
        }
    }

    protected JComponent createEmptyPanel(DockingComponentInfo[] resultInfo) {
        resultInfo[0] = new DockingComponentInfo("Empty Panel");
        return new JLabel("[Empty]");
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        DockingDesktop dt = new DockingDesktop();
        dt.init();
        jf.getContentPane().add(dt);
        jf.pack();
        dt.setLayoutConfiguration("1369,1121:-209,|749,de.exchange.eurex.trading.component.fastorderentry.FastOrderEntryScreen:|612,de.exchange.eurex.trading.component.quoteentry.QuoteEntryScreen:-391,|653,de.exchange.eurex.trading.component.marketoverview.MarketOverviewScreen:|708,de.exchange.eurex.trading.component.ownorderoverview.OwnOrderOverviewScreen:-439,|851,de.exchange.eurex.trading.component.onlinetimeandsalessheet.OnlineTimeAndSalesSheetScreen:|510,de.exchange.eurex.common.component.docking.EurexDockingEmptyPanel:", null);
        jf.show();
    }
}

