/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.anyj.application.DockingEditorHost;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.swingx.CollapsedPanelBar;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.DockingComponentWrapper;
import de.netcomputing.swingx.DockingContainer;
import de.netcomputing.swingx.DockingContainerListener;
import de.netcomputing.swingx.DockingDesktop;
import de.netcomputing.swingx.DockingDesktopAdapter;
import de.netcomputing.swingx.DragHelper;
import de.netcomputing.swingx.DragHelperListener;
import de.netcomputing.swingx.IDockingContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NCButtonTabbedPane
extends JPanel
implements IDockingContainer {
    JPanel contentPanel;
    JPanel buttonBar;
    CollapsedPanelBar cpBar;
    ArrayList entries = new ArrayList();
    ArrayList flownOutEntries = new ArrayList();
    int orderCount = 0;
    ArrayList listeners = new ArrayList();
    static Insets ins = new Insets(4, 4, 4, 4);
    ArrayList dContlisteners = new ArrayList();

    public NCButtonTabbedPane() {
        this.setLayout(new BorderLayout(0, 0));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.buttonBar = new JPanel();
        this.add("West", this.buttonBar);
        this.add("Center", this.contentPanel);
        this.buttonBar.setLayout(new BoxLayout(this.buttonBar, 1));
    }

    public void setCpBar(CollapsedPanelBar cpBar) {
        this.cpBar = cpBar;
    }

    public CollapsedPanelBar getCpBar() {
        return this.cpBar;
    }

    public String getTitleAt(int i) {
        return this.entryAt((int)i).title;
    }

    public int getSelectedIndex() {
        int i = 0;
        while (i < this.entries.size()) {
            if (this.entryAt((int)i).button.isSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setIconAt(int index, Icon ic) {
        this.entryAt(index).setIcon(ic);
        this.repaint();
    }

    public void setToolTipTextAt(int i, String t) {
        this.entryAt(i).setTTip(t);
    }

    public void addTab(String title, String ttip, JComponent comp, Icon icon) {
        TabEntry en = new TabEntry(title, ttip, icon, comp);
        this.createDragHelper(en.button, en.comp, en);
        en.order = this.orderCount++;
        this.entries.add(en);
        this.buttonBar.add(en.button);
        en.comp.setVisible(false);
        this.contentPanel.add("Center", en.comp);
        if (this.entries.size() == 1) {
            en.button.setSelected(true);
            this.hideAll();
            en.comp.setVisible(true);
            this.contentPanel.validate();
        }
    }

    void reAdd(TabEntry tab) {
        int i = 0;
        while (i < this.entries.size()) {
            if (this.entryAt(i) == tab) {
                this.buttonBar.add((Component)tab.button, i);
                this.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public void addTab(String title, String ttip, JComponent comp, Image icon) {
        this.addTab(title, ttip, comp, icon == null ? (Icon)null : new ImageIcon(icon));
    }

    public void addTab(String title, String ttip, JComponent comp, Icon icon, int index) {
        TabEntry en = null;
        if (this.entryAt((int)index).title.equals(title)) {
            en = this.entryAt(index);
            if (icon != null) {
                this.entryAt(index).setIcon(icon);
            }
            this.entryAt(index).setTitle(title);
            this.entryAt(index).setTTip(ttip);
            if (comp != null) {
                this.contentPanel.remove(this.entryAt((int)index).comp);
                this.entryAt((int)index).comp = comp;
                comp.setVisible(this.entryAt((int)index).button.isSelected());
                this.contentPanel.add("Center", en.comp);
            }
            this.hideAll();
            if (en.comp != null) {
                en.comp.setVisible(true);
            }
            this.contentPanel.validate();
            this.repaint();
        } else {
            en = new TabEntry(title, ttip, icon, comp);
            this.entries.add(index, en);
            this.buttonBar.add((Component)en.button, index);
            en.comp.setVisible(false);
            en.order = this.orderCount++;
            this.contentPanel.add("Center", en.comp);
            this.createDragHelper(en.button, en.comp, en);
            int i = index + 1;
            while (i < this.entries.size()) {
                ++this.entryAt((int)i).order;
                ++i;
            }
        }
        if (this.entries.size() == 1) {
            en.button.setSelected(true);
            this.hideAll();
            en.comp.setVisible(true);
            this.contentPanel.add("Center", en.comp);
            this.contentPanel.validate();
        }
    }

    void hideAll() {
        int i = 0;
        while (i < this.contentPanel.getComponentCount()) {
            Component comp = this.contentPanel.getComponent(i);
            comp.setVisible(false);
            ++i;
        }
    }

    public JComponent getTab(int i) {
        return this.entryAt((int)i).comp;
    }

    public void addChangeListener(ChangeListener li) {
        this.listeners.add(li);
    }

    public void fireChangeEvent() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ChangeListener)this.listeners.get(i)).stateChanged(new ChangeEvent(this));
            ++i;
        }
    }

    public JComponent getSelectedComponent() {
        return this.getTab(this.getSelectedIndex());
    }

    public void setSelectedIndex(int ii) {
        this.hideAll();
        int i = 0;
        while (i < this.entries.size()) {
            if (i != ii) {
                this.entryAt((int)i).button.setSelected(false);
            } else {
                TabEntry en = this.entryAt(i);
                en.comp.setVisible(true);
                en.comp.validate();
                this.contentPanel.add("Center", en.comp);
                en.button.setSelected(true);
            }
            ++i;
        }
        this.contentPanel.repaint();
        this.fireChangeEvent();
    }

    public int getTabCount() {
        return this.entries.size();
    }

    public void setSelectedTab(String title) {
        int idx = this.indexOf(title);
        if (idx < 0) {
            int i = 0;
            while (i < this.flownOutEntries.size()) {
                DockingDesktop dDesktop;
                TabEntry tEntry = (TabEntry)this.flownOutEntries.get(i);
                if (tEntry.title.equals(title) && (dDesktop = DockingContainer.findDockingDesktop(tEntry.comp)) != null) {
                    dDesktop.setMinimized(tEntry.comp, false);
                    tEntry.comp.requestFocusInWindow();
                }
                ++i;
            }
            if (this.getSelectedIndex() < 0) {
                this.setSelectedIndex(0);
            }
        } else {
            this.setSelectedIndex(idx);
        }
    }

    public void remTab(String title) {
        int i = this.indexOf(title);
        if (i >= 0) {
            this.buttonBar.remove(this.entryAt((int)i).button);
            this.entries.remove(i);
            this.setSelectedIndex(Math.min(i, this.entries.size() - 1));
        }
        this.fireChangeEvent();
    }

    public void remTab(int i) {
        if (i >= 0) {
            this.buttonBar.remove(this.entryAt((int)i).button);
            this.entries.remove(i);
            this.setSelectedIndex(Math.min(i, this.entries.size() - 1));
        }
        this.fireChangeEvent();
    }

    TabEntry entryAt(int i) {
        return (TabEntry)this.entries.get(i);
    }

    public int indexOf(String title) {
        int i = 0;
        while (i < this.entries.size()) {
            TabEntry en = (TabEntry)this.entries.get(i);
            if (en.title.equals(title)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfFlownOut(String title) {
        int i = 0;
        while (i < this.flownOutEntries.size()) {
            TabEntry en = (TabEntry)this.flownOutEntries.get(i);
            if (en.title.equals(title)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(JComponent comp) {
        int i = 0;
        while (i < this.entries.size()) {
            TabEntry en = (TabEntry)this.entries.get(i);
            if (en.comp == comp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void selectionChanged(TabEntry en, ActionEvent ev) {
        if (en.button.isSelected()) {
            this.hideAll();
            en.comp.setVisible(true);
            this.contentPanel.add(en.comp);
            this.contentPanel.validate();
            this.contentPanel.repaint();
            int i = 0;
            while (i < this.entries.size()) {
                if (this.entryAt(i) != en) {
                    this.entryAt((int)i).button.setSelected(false);
                }
                ++i;
            }
            this.fireChangeEvent();
        } else {
            en.button.setSelected(true);
        }
    }

    public void flyInAll(DockingDesktop dDesktop) {
        this.flownOutEntries.clear();
    }

    public DockingComponentWrapper flyOut(int i, DockingDesktop dDesktop) {
        TabEntry tEntry = this.entryAt(i);
        if (dDesktop != null) {
            DockingComponentWrapper dcWrapper = this.cpBar.addDockedComponent(tEntry.comp, new DockingComponentInfo(tEntry.title));
            dDesktop.addDockingDesktopListener(this.createDDAdapter(dDesktop, dcWrapper, tEntry, tEntry.comp));
            this.entries.remove(tEntry);
            this.flownOutEntries.add(tEntry);
            this.buttonBar.remove(tEntry.button);
            this.contentPanel.remove(tEntry.comp);
            return dcWrapper;
        }
        return null;
    }

    DragHelper createDragHelper(final JComponent button, final JComponent content, final TabEntry entry) {
        return new DragHelper(new DragHelperListener(){
            JPanel dragPanel = new JPanel(new BorderLayout(0, 0));
            DockingComponentWrapper wrapper;

            public JComponent getShapeOnStartDragging(MouseEvent ev) {
                if (NCButtonTabbedPane.this.entries.size() == 1 || NCButtonTabbedPane.this.cpBar == null) {
                    return null;
                }
                this.wrapper = NCButtonTabbedPane.this.cpBar.addDockedComponent(content, new DockingComponentInfo(entry.title));
                this.dragPanel.removeAll();
                this.dragPanel.add("West", button);
                this.dragPanel.add("Center", content);
                if (!content.isVisible()) {
                    content.setVisible(true);
                    content.setSize(NCButtonTabbedPane.this.getSize());
                    content.doLayout();
                }
                this.dragPanel.setSize(button.getWidth() + content.getWidth(), content.getHeight());
                return this.dragPanel;
            }

            public void notifyStopDragging(IDockingContainer dc, JComponent dragHandle, int screenX, int screenY, boolean componentExited) {
                if (NCButtonTabbedPane.this.cpBar == null) {
                    return;
                }
                if (!componentExited) {
                    NCButtonTabbedPane.this.cpBar.remove(this.wrapper);
                    this.dragPanel.removeAll();
                    NCButtonTabbedPane.this.reAdd(entry);
                } else {
                    DockingDesktop dDesktop = DockingContainer.findDockingDesktop((JComponent)((Object)dc));
                    if (dDesktop != null) {
                        dDesktop.addDockingDesktopListener(NCButtonTabbedPane.this.createDDAdapter(dDesktop, this.wrapper, entry, content));
                    }
                    this.dragPanel.removeAll();
                    dc.componentDropped(screenX, screenY, DockingContainer.findDockingContainer(NCButtonTabbedPane.this), this.wrapper);
                    NCButtonTabbedPane.this.entries.remove(entry);
                    NCButtonTabbedPane.this.flownOutEntries.add(entry);
                    NCButtonTabbedPane.this.setSelectedIndex(0);
                }
            }

            public void fireDragEnter(IDockingContainer target, int targetX, int targetY) {
                target.dragEnter(targetX, targetY, this.wrapper);
            }

            public void fireDragOver(IDockingContainer target, int targetX, int targetY) {
                target.dragOver(targetX, targetY, this.wrapper);
            }

            public void fireDragExit(IDockingContainer target) {
                if (target != null) {
                    target.dragExit();
                }
            }
        }, button, this);
    }

    void addEntryWithOrder(TabEntry entry) {
        int idx = 0;
        int i = 0;
        while (i < this.entries.size() && this.entryAt((int)i).order < entry.order) {
            idx = i + 1;
            ++i;
        }
        idx = Math.min(idx, this.entries.size());
        this.entries.add(idx, entry);
    }

    DockingDesktopAdapter createDDAdapter(final DockingDesktop dDesktop, DockingComponentWrapper dcWrapper, final TabEntry entry, final JComponent content) {
        DockingDesktopAdapter dDdapter = new DockingDesktopAdapter(){

            public void componentClosed(DockingComponentWrapper dcWrapper) {
                if (dcWrapper.getContentPanel() == content) {
                    NCButtonTabbedPane.this.flownOutEntries.remove(entry);
                    NCButtonTabbedPane.this.addEntryWithOrder(entry);
                    NCButtonTabbedPane.this.reAdd(entry);
                    dDesktop.removeDockingDesktopListener(this);
                    entry.anonListener = null;
                }
            }
        };
        entry.anonListener = dDdapter;
        return dDdapter;
    }

    public void addDockingContainerListener(DockingContainerListener li) {
        if (!this.dContlisteners.contains(li)) {
            this.dContlisteners.add(li);
        }
    }

    public void removeDockingContainerListener(DockingContainerListener li) {
        this.dContlisteners.remove(li);
    }

    public void fireComponentRemovedToOtherContainer(IDockingContainer oldCont, DockingComponentWrapper dragged) {
        int i = 0;
        while (i < this.dContlisteners.size()) {
            ((DockingContainerListener)this.dContlisteners.get(i)).componentRemovedToOtherContainer(oldCont, dragged);
            ++i;
        }
    }

    public void fireComponentDroppedFromOtherContainer(DockingComponentWrapper dragged) {
        int i = 0;
        while (i < this.dContlisteners.size()) {
            ((DockingContainerListener)this.dContlisteners.get(i)).componentDroppedFromOtherContainer(dragged);
            ++i;
        }
    }

    public DockingComponentWrapper addComponent(JComponent comp, DockingComponentInfo title) {
        return null;
    }

    public void removeDockingComponent(JComponent contentComponent) {
    }

    public void removeDockingComponent(DockingComponentWrapper dc) {
    }

    public boolean isEmpty() {
        return this.entries.size() > 0;
    }

    public IDockingContainer getDockingParent() {
        return DockingContainer.findDockingContainer((JComponent)this.getParent());
    }

    public boolean isAnyComponentVisible() {
        return !this.isEmpty();
    }

    public void addEmptyComponent() {
        throw new RuntimeException("UNIMPLEMENTED");
    }

    public void addEmptyComponent(int index) {
        throw new RuntimeException("UNIMPLEMENTED");
    }

    public boolean canDrop(int x, int y, JComponent sp) {
        return false;
    }

    public void dragOver(int x, int y, DockingComponentWrapper sp) {
    }

    public void dragEnter(int x, int y, DockingComponentWrapper sp) {
    }

    public void dragExit() {
    }

    public void componentDropped(int x, int y, DockingContainer oldDock, DockingComponentWrapper sp) {
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        NCButtonTabbedPane tp = new NCButtonTabbedPane();
        jf.getContentPane().add(tp);
        int i = 0;
        while (i < 10) {
            tp.addTab("" + i, "TIP", (JComponent)new JLabel("COMP " + i), (Image)null);
            ++i;
        }
        jf.pack();
        jf.show();
    }

    public class TabEntry {
        Icon icon;
        String title;
        String ttip;
        JComponent comp;
        JToggleButton button;
        int order;
        Object anonListener;

        public TabEntry(String title, String ttip, Icon icon, JComponent comp) {
            this.title = title;
            this.ttip = ttip;
            this.comp = comp;
            this.button = new JToggleButton(this){
                private final /* synthetic */ TabEntry this$1;
                {
                    this.this$1 = this$1;
                }

                public Color getBackground() {
                    if (!this.isSelected()) {
                        return super.getBackground();
                    }
                    return JWColor.BBARBG;
                }

                public boolean isBorderPainted() {
                    if (!this.isSelected()) {
                        return super.isBorderPainted();
                    }
                    return true;
                }

                public Insets getInsets(Insets s) {
                    return ins;
                }

                public Insets getInsets() {
                    return ins;
                }
            };
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ TabEntry this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ev) {
                    TabEntry.access$000(this.this$1).selectionChanged(this.this$1, ev);
                }
            });
            this.button.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ TabEntry this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseEntered(MouseEvent e) {
                    if (EditFrame.Host() instanceof DockingEditorHost) {
                        this.this$1.button.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }

                public void mouseExited(MouseEvent e) {
                    this.this$1.button.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.button.setBorder(new LineBorder(Color.black));
            this.button.setBorderPainted(false);
            this.button.setFocusPainted(false);
            this.setTTip(ttip);
            this.setIcon(icon);
        }

        public void setTTip(String t) {
            this.ttip = t;
            this.button.setToolTipText(this.title + " - " + (this.ttip == null ? "" : this.ttip));
        }

        public void setTitle(String t) {
            this.title = t;
            this.button.setToolTipText(this.title + " - " + this.ttip);
        }

        public void setIcon(Icon ic) {
            this.icon = ic;
            if (this.icon == null) {
                this.button.setText(this.title);
            } else {
                this.button.setText("");
                this.button.setIcon(this.icon);
            }
        }

        static /* synthetic */ NCButtonTabbedPane access$000(TabEntry x0) {
            return x0.NCButtonTabbedPane.this;
        }
    }
}

