/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.StringUnifier;
import java.io.File;

public class FileUtil {
    public static int[] NOURLweak = null;
    public static int[] NOURLsafe = null;
    static /* synthetic */ Class class$java$lang$String;

    public static String urlify(String str) {
        return FileUtil.urlify(str, true);
    }

    public static String urlify(String str, boolean weak) {
        if (NOURLsafe == null) {
            FileUtil.initNOURL();
        }
        int[] NOURL = weak ? NOURLweak : NOURLsafe;
        StringBuffer buf = new StringBuffer(str);
        char sep = File.separatorChar;
        int idx = 0;
        while (idx < buf.length()) {
            char ch = buf.charAt(idx);
            if ((NOURL[ch >> 5 & 7] & 1 << (ch & 0x1F)) == 0) {
                buf.setCharAt(idx, '%');
                int nibble = ch >> 4 & 0xF;
                buf.insert(++idx, (char)(nibble + (nibble > 9 ? 55 : 48)));
                nibble = ch & 0xF;
                buf.insert(++idx, (char)(nibble + (nibble > 9 ? 55 : 48)));
            }
            ++idx;
        }
        return new String(buf);
    }

    public static String deurlify(String str) {
        return FileUtil.deurlify(null, str);
    }

    public static String deurlify(StringUnifier unifier, String str) {
        char[] chrs = new char[str.length()];
        int pos = 0;
        int idx = 0;
        while (idx < str.length()) {
            chrs[pos] = str.charAt(idx);
            if (chrs[pos] == '%') {
                int val;
                val = (val = str.charAt(++idx)) < 65 ? (val -= 48) : (val & 0xEF) - 65;
                chrs[pos] = (char)(val << 4);
                char c = str.charAt(++idx);
                val = c;
                val = c < 'A' ? (val -= 48) : (val & 0xEF) - 65;
                int n = pos;
                chrs[n] = (char)(chrs[n] | (char)val);
            }
            ++pos;
            ++idx;
        }
        return unifier != null ? unifier.getString(chrs, 0, pos) : new String(chrs, 0, pos);
    }

    public static String deurlify(byte[] str, int offs, int len) {
        return FileUtil.deurlify(null, str, offs, len);
    }

    public static String deurlify(StringUnifier unifier, byte[] str, int offs, int len) {
        char[] chrs = new char[len];
        int pos = 0;
        int idx = offs;
        int end = offs + len;
        while (idx < end) {
            chrs[pos] = (char)(str[idx] & 0xFF);
            if (chrs[pos] == '%') {
                int val;
                val = (val = str[++idx] & 0xFF) < 65 ? (val -= 48) : (val & 0xEF) - 65;
                chrs[pos] = (char)(val << 4);
                val = str[++idx] & 0xFF;
                val = val < 65 ? (val -= 48) : (val & 0xEF) - 65;
                int n = pos;
                chrs[n] = (char)(chrs[n] | (char)val);
            }
            ++pos;
            ++idx;
        }
        return unifier != null ? unifier.getString(chrs, 0, pos) : new String(chrs, 0, pos);
    }

    public static void initNOURL() {
        NOURLsafe = new int[8];
        int ch = 65;
        while (ch <= 90) {
            int n = ch >> 5 & 7;
            NOURLsafe[n] = NOURLsafe[n] | 1 << (ch & 0x1F);
            ch = (char)(ch + 1);
        }
        ch = 97;
        while (ch <= 122) {
            int n = ch >> 5 & 7;
            NOURLsafe[n] = NOURLsafe[n] | 1 << (ch & 0x1F);
            ch = (char)(ch + 1);
        }
        ch = 48;
        while (ch <= 57) {
            int n = ch >> 5 & 7;
            NOURLsafe[n] = NOURLsafe[n] | 1 << (ch & 0x1F);
            ch = (char)(ch + 1);
        }
        String chars = "$-_.+!*(),'";
        int idx = 0;
        while (idx < chars.length()) {
            ch = chars.charAt(idx);
            int n = ch >> 5 & 7;
            NOURLsafe[n] = NOURLsafe[n] | 1 << (ch & 0x1F);
            ++idx;
        }
        NOURLweak = new int[8];
        System.arraycopy(NOURLsafe, 0, NOURLweak, 0, 8);
        chars = "~/:=|;?@&{}^[[]\\#";
        int idx2 = 0;
        while (idx2 < chars.length()) {
            ch = chars.charAt(idx2);
            int n = ch >> 5 & 7;
            NOURLweak[n] = NOURLweak[n] | 1 << (ch & 0x1F);
            ++idx2;
        }
    }

    public static String getLocalURL(String filename) {
        String local = null;
        if ((filename.indexOf(":") & Integer.MAX_VALUE) < 3) {
            if (filename.charAt(0) == '\\') {
                filename = filename.substring(1, filename.length());
            }
            local = "file:";
        } else {
            local = System.getProperty("user.dir", ".");
        }
        if (local.startsWith("url:")) {
            local = local.substring(4, local.length());
        }
        StringBuffer buf = new StringBuffer(100);
        if (!local.startsWith("http:") && !local.startsWith("file:")) {
            buf.append("file:/");
        }
        buf.append(local);
        buf.append("/");
        if (filename != null) {
            buf.append(filename);
        }
        if (!(local = buf.toString()).startsWith("file:")) {
            local = FileUtil.urlify(local);
        }
        return local;
    }

    public static String[] getFilesRecursivly(String[] files, String ext) {
        return FileUtil.getFilesRecursivly(files, ext, 0, 0);
    }

    public static String[] getFilesRecursivly(String dirname, String ext) {
        File dir = new File(dirname);
        String[] list = dir.list();
        if (list == null || list.length == 0) {
            return new String[0];
        }
        Object[] files = new Object[list.length];
        int cnt = 0;
        int idx = 0;
        while (idx < files.length) {
            String name = dirname + File.separatorChar + list[idx];
            if (new File(name).isDirectory()) {
                String[] sub;
                files[idx] = sub = FileUtil.getFilesRecursivly(name, ext);
                cnt += sub.length;
            } else if (ext == null || name.endsWith(ext)) {
                files[idx] = name;
                ++cnt;
            }
            ++idx;
        }
        String[] res = new String[cnt];
        int pos = 0;
        int idx2 = 0;
        while (idx2 < files.length) {
            if (files[idx2] != null) {
                if (files[idx2].getClass() == (class$java$lang$String == null ? FileUtil.class$("java.lang.String") : class$java$lang$String)) {
                    res[pos++] = (String)files[idx2];
                } else {
                    String[] sub = (String[])files[idx2];
                    int idy = 0;
                    while (idy < sub.length) {
                        res[pos++] = sub[idy];
                        ++idy;
                    }
                }
            }
            ++idx2;
        }
        return res;
    }

    protected static String[] getFilesRecursivly(String[] args, String ext, int pos, int cnt) {
        String name = null;
        while (pos < args.length) {
            name = args[pos];
            if (name != null) {
                if (name.indexOf("*.") < 0) break;
                if (name.endsWith("*" + ext)) {
                    name = name.substring(0, name.length() - 1 - ext.length());
                    break;
                }
                if (name.endsWith("*." + ext)) {
                    name = name.substring(0, name.length() - 2 - ext.length());
                    break;
                }
            }
            ++pos;
        }
        if (pos >= args.length) {
            return new String[cnt];
        }
        File file2 = new File(name);
        String[] res = null;
        if (!file2.exists()) {
            throw new RuntimeException(file2.getAbsolutePath() + ": no such file/directory");
        }
        if (file2.isDirectory()) {
            String[] cont = FileUtil.getFilesRecursivly(name, ext);
            res = FileUtil.getFilesRecursivly(args, ext, pos + 1, cnt + cont.length);
            System.arraycopy(cont, 0, res, cnt, cont.length);
        } else if (ext == null || name.endsWith(ext)) {
            res = FileUtil.getFilesRecursivly(args, ext, pos + 1, cnt + 1);
            res[cnt] = name;
        } else {
            throw new RuntimeException(file2.getAbsolutePath() + " : input files must end with \"" + ext + "\"");
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

