/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.Array;
import de.netcomputing.util.xml.ByteArrayBuffer;
import de.netcomputing.util.xml.Hashtable;
import de.netcomputing.util.xml.XMLIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MultipartEntry {
    protected Hashtable fields;
    protected ByteArrayBuffer buf;
    protected int from;
    protected int offs;
    protected int length;

    public static Array getEntries(InputStream in, String boundary, int length) throws IOException {
        ByteArrayBuffer buf = new ByteArrayBuffer();
        buf.rawappend(in, length);
        boundary = boundary.charAt(0) == '\"' ? "--" + boundary.substring(1, boundary.length() - 2) : "--" + boundary;
        int pos = 0;
        int blen = boundary.length();
        byte[] bytes = buf.getInternal();
        Array entries = new Array();
        int idx = 0;
        while ((idx = buf.indexOf(boundary, idx)) >= 0) {
            if (pos > 0) {
                entries.add(new MultipartEntry(buf, pos, idx - pos - 2));
            }
            idx += blen;
            if (bytes[idx++] != 13 || bytes[idx++] != 10) break;
            pos = idx;
        }
        return entries;
    }

    public MultipartEntry(ByteArrayBuffer buf, int from, int length) {
        this.buf = buf;
        int idx = this.from = from;
        while ((idx = buf.indexOf("\r\n", idx)) >= 0 && buf.getInternal()[idx += 2] != 13) {
        }
        this.offs = idx + 2;
        this.length = length - this.offs + from;
    }

    protected void parseFields() {
        this.fields = new Hashtable();
        boolean typeSpec = false;
        int idx = this.from;
        while (idx < this.offs) {
            if (this.buf.getInternal()[idx] == 13) break;
            int pos = this.buf.indexOf(':', idx);
            String key = this.buf.toString(idx, pos - idx);
            if (key.equals("Content-Type")) {
                typeSpec = true;
            }
            idx = this.buf.indexOf('\r', pos);
            String val = this.buf.toString(pos + 2, idx - pos - 2);
            this.fields.put(key, val);
            idx += 2;
        }
        if (!typeSpec) {
            this.fields.put("Content-Type", "text/plain; charset=us-ascii");
        }
    }

    public XMLIterator getFieldNames() {
        if (this.fields == null) {
            this.parseFields();
        }
        return this.fields.keys();
    }

    public String getField(String name) {
        if (this.fields == null) {
            this.parseFields();
        }
        return (String)this.fields.get(name);
    }

    public String getContentString() {
        return this.buf.toString(this.offs, this.length);
    }

    public byte[] getContentBytes() {
        return this.buf.getBytes(this.offs, this.length);
    }

    public void writeContentTo(OutputStream out) throws IOException {
        this.buf.writeTo(out, this.offs, this.length);
    }

    public int getContentLength() {
        return this.length;
    }
}

