/*
 * Decompiled with CFR 0.152.
 */
package editapp.templates;

import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.application.PropertyDispatcher;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ISelectedContext;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import editapp.templates.ITemplateEngine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netcomputing.file.RecursiveFileCopier;
import plugins.DebuggerPlugin;
import plugins.JavacPlugin;

public class TemplateEngine
implements ITemplateEngine {
    Vector newFiles = new Vector(10);

    public static ISelectedContext CreateContext(final Object obj) {
        return new ISelectedContext(){

            public int size() {
                return 1;
            }

            public Object at(int n) {
                return obj;
            }
        };
    }

    public static ISelectedContext CreateContext(final Object obj, final Object obj1) {
        return new ISelectedContext(){

            public int size() {
                return 2;
            }

            public Object at(int n) {
                return n == 0 ? obj : obj1;
            }
        };
    }

    public String[] getAvailableEnvVars() {
        return null;
    }

    public String instantiateTemplateDir(String tplDir, String newDir) {
        return this.instantiateTemplateDir(tplDir, newDir, null);
    }

    public String instantiateTemplateDir(String tplDir, String newDir, String objectName) {
        String name;
        this.newFiles = new Vector(11);
        String string = name = objectName == null ? Confirm.GetText(EditApp.App.getMainWindow(), null, "Please enter a Name for the Template instance", new String[]{"The name determines the name of the generated files.", "E.g. 'MyMain' may result in 'MyMain.java' to be created."}) : objectName;
        if (name != null) {
            MyCopier copier = new MyCopier(name, "__name__");
            try {
                copier.copyRecursive(tplDir, newDir);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
            File cfg = new File(newDir + File.separator + "conf.txt");
            if (cfg.exists()) {
                try {
                    ((RecursiveFileCopier)copier).replace(cfg, null, null);
                    PropertyDispatcher.This().processConf(cfg.getAbsolutePath());
                    cfg.delete();
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            if ((cfg = new File(newDir + File.separator + "conf.ajpr")).exists()) {
                try {
                    ((RecursiveFileCopier)copier).replace(cfg, null, null);
                    EditApp.App.jol.xmlImport(cfg);
                    cfg.delete();
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            EditApp.App.updateSourceBase(this.newFiles);
            EditApp.App.updateDirTree();
        }
        return name;
    }

    public Hashtable getDefaultTemplateValues(String templateSourceName, String templateDestName) {
        Hashtable<Object, String> values = new Hashtable<Object, String>();
        values.put("sourcename", VFile.NameWithoutExtension(templateSourceName));
        values.put("sourcefullname", templateSourceName);
        values.put("tplname", VFile.NameWithoutExtension(templateDestName));
        values.put("tplfullname", templateDestName);
        Enumeration<Object> en = System.getProperties().keys();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            values.put(o, System.getProperty("" + o));
        }
        values.put("date", new Date().toLocaleString());
        return values;
    }

    public void instantiateTemplateFile(File target, Hashtable values) {
        TextDocument doc = new TextDocument(target);
        doc.load(target);
        String s = doc.toString();
        ISelectedContext sel = this.dummyContext(target);
        Hashtable newValues = this.buildEnvironment(sel);
        Enumeration en = values.keys();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            newValues.put(o, values.get(o));
        }
        s = this.insertEnvVars(s, newValues, sel);
        try {
            FileOutputStream fout = new FileOutputStream(target);
            PrintStream pout = new PrintStream(fout);
            pout.print(s);
            fout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.ModalMsg(EditApp.App.getMainWindow(), "Failed to create File", new String[]{"could not instantiate Template", ex.getMessage()});
        }
    }

    ISelectedContext dummyContext() {
        return new ISelectedContext(){

            public int size() {
                return 0;
            }

            public Object at(int n) {
                return null;
            }
        };
    }

    ISelectedContext dummyContext(final File f) {
        return new ISelectedContext(){

            public int size() {
                return 1;
            }

            public Object at(int n) {
                return f;
            }
        };
    }

    public String insertEnvVars(String s, Hashtable values) {
        if (s == null) {
            return null;
        }
        if (values == null && s.indexOf("($") >= 0) {
            values = this.buildEnvironment(this.dummyContext());
        }
        return this.insertEnvVars(s, values, this.dummyContext());
    }

    public Hashtable buildEnvironment(ISelectedContext selection) {
        JavacPlugin jcpin = (JavacPlugin)EditApp.App.getPluginNamed("CompilerPlugin");
        Hashtable env = EditApp.App.getMergedUserProperties();
        env.put("SystemClasses", EditApp.App.getWorkspaceProperty("Library.Classes"));
        env.put("Swing", EditApp.App.getWorkspaceProperty("Library.Swing"));
        env.put("ServletSDK", EditApp.App.getWorkspaceProperty("Library.ServletSDK"));
        env.put("Tools", EditApp.App.getWorkspaceProperty("Library.Tools"));
        env.put("AnyJUserHome", VFile.ResolveName("#userdata"));
        env.put("Source.SystemClasses", EditApp.App.getLibraryRepository().getLibrarySourcePath("classes"));
        env.put("Source.Swing", EditApp.App.getLibraryRepository().getLibrarySourcePath("swing"));
        env.put("Source.ServletSDK", EditApp.App.getLibraryRepository().getLibrarySourcePath("servlet"));
        try {
            env.put("SourcePath", AJCompileAndBuild.This.getSourcepathFld().getText());
        }
        catch (NullPointerException ex) {
            env.put("SourcePath", "");
            env.put("LibrariesAndSourcePath", "");
        }
        try {
            env.put("Source.Tools", EditApp.App.getWorkspaceProperty("Library.Source.Tools"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        env.put("jdkhome", "" + EditApp.App.getGlobalProperty("Directory.jdkHome"));
        env.put("anyjbin", new File("").getAbsolutePath());
        try {
            env.put("anyjbase", new File(".." + File.separator).getCanonicalPath());
        }
        catch (Exception ex) {
            env.put("anyjbase", "");
            ex.printStackTrace();
        }
        env.put("workspaceDir", EditApp.App.getCurrentProjectDir());
        String cp = EditApp.App.getCompileClasspath();
        env.put("classpath", "" + cp);
        try {
            DebuggerPlugin pin = DebuggerPlugin.This();
            String dbgcp = pin.getClasspath();
            env.put("runtimeclasspath", "" + dbgcp);
        }
        catch (Exception ex) {
            env.put("runtimeclasspath", "");
        }
        try {
            String output = jcpin.getOutputDir();
            env.put("outputdir", "" + output);
        }
        catch (Exception ex) {
            env.put("outputdir", "");
            ex.printStackTrace(Tracer.This);
        }
        boolean hadDoc = false;
        int n = selection.size() - 1;
        while (n >= 0) {
            if (selection.at(n) instanceof TextDocument) {
                hadDoc = true;
            }
            --n;
        }
        env.put("currentClass", "");
        env.put("currentName", "");
        env.put("currentParentDir", "");
        env.put("currentFile", "");
        env.put("currentDir", "");
        env.put("currentName", "");
        env.put("currentParentDir", "");
        env.put("currentLineNr", "");
        env.put("currentColNr", "");
        env.put("currentTextSel", "");
        int n2 = selection.size() - 1;
        while (n2 >= 0) {
            Object sel = selection.at(n2);
            if (sel instanceof IndexEntry && ((IndexEntry)sel).isClassOrInterface()) {
                String rpack = ((IndexEntry)sel).realPackage() + ".";
                if (rpack.startsWith(File.separator)) {
                    rpack = "";
                }
                String realCName = rpack + ((IndexEntry)sel).realClassName().trim();
                while (realCName.startsWith(" ") || realCName.startsWith(".")) {
                    realCName = realCName.substring(1);
                }
                env.put("currentClass", realCName);
            } else if (sel instanceof File && !hadDoc) {
                String nam = ((File)sel).getAbsolutePath();
                String dir = VFile.ExtractDir(nam);
                String name = ((File)sel).getName();
                String parentDir = dir;
                String firstDir = name;
                if (((File)sel).isDirectory()) {
                    parentDir = VFile.RemoveLast(dir);
                    name = "";
                    firstDir = VFile.LastDir(dir);
                    while (firstDir.startsWith(File.separator)) {
                        firstDir = firstDir.substring(1);
                    }
                }
                env.put("currentName", firstDir);
                env.put("currentParentDir", parentDir);
                File fi = (File)sel;
                if (fi.getName().endsWith(".java")) {
                    String clname = fi.getName().substring(0, fi.getName().length() - 5);
                    String pack = DocumentStream.ScanPackage(fi);
                    if (pack != null) {
                        String realCName = pack + "." + clname;
                        while (realCName.startsWith(" ") || realCName.startsWith(".")) {
                            realCName = realCName.substring(1);
                        }
                        env.put("currentClass", realCName);
                    }
                }
                env.put("currentFile", name);
                env.put("currentDir", dir);
            } else if (sel instanceof TextDocument) {
                TextDocument doc = (TextDocument)sel;
                String fi = doc.getFile().getAbsolutePath();
                String dir = VFile.ExtractDir(fi);
                String name = doc.getFile().getName();
                if (doc.getFile().isDirectory()) {
                    name = "";
                }
                env.put("currentFile", name);
                env.put("currentDir", dir);
                env.put("currentName", name);
                env.put("currentParentDir", dir);
                env.put("currentLineNr", "" + doc.cY());
                env.put("currentColNr", "" + doc.cX());
                env.put("currentTextSel", doc.currentWordAsString());
            }
            --n2;
        }
        if (((String)env.get("currentClass")).length() == 0) {
            try {
                String file2 = env.get("currentFile").toString();
                if (file2.length() > 5) {
                    String dir = env.get("currentDir").toString();
                    String name = file2.substring(0, file2.length() - 5);
                    IndexEntry ie = SourceBase.This().getPossibleClassDefFor(name, dir + File.separatorChar + file2);
                    if (ie != null) {
                        String realCName = ie.realPackage() + "." + ie.realClassName();
                        while (realCName.startsWith(" ") || realCName.startsWith(".")) {
                            realCName = realCName.substring(1);
                        }
                        env.put("currentClass", realCName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(Tracer.This);
            }
        }
        return env;
    }

    String ressolveVariable(String varName, Hashtable calculated) {
        return this.ressolveVariable(varName, calculated, 0);
    }

    String ressolveVariable(String varName, Hashtable calculated, int recCount) {
        if (varName.startsWith("ask:")) {
            return Confirm.GetText(EditApp.App.mainFrame, null, "Enter Parameter:", new String[]{varName.substring(4)});
        }
        Object res = null;
        if (calculated != null) {
            res = calculated.get(varName);
        }
        if (res == null) {
            res = EditApp.App.getMergedUserProperty(varName);
        }
        if (res == null) {
            if ("SystemClasses".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Classes");
            } else if ("Swing".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Swing");
            } else if ("ServletSDK".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.ServletSDK");
            } else if ("Tools".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Tools");
            } else if ("Source.SystemClasses".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Source.Classes");
            } else if ("Source.Swing".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Source.Swing");
            } else if ("Source.ServletSDK".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Source.ServletSDK");
            } else if ("Source.Tools".equals(varName)) {
                res = EditApp.App.getWorkspaceProperty("Library.Source.Tools");
            }
        }
        if (res == null) {
            res = System.getProperty(varName);
        }
        if (res == null) {
            switch (recCount) {
                case 0: {
                    return this.ressolveVariable(varName.toUpperCase(), calculated, 1);
                }
                case 1: {
                    return this.ressolveVariable(varName.toLowerCase(), calculated, 2);
                }
            }
        }
        return "" + res;
    }

    public String insertEnvVars(String s, Hashtable values, ISelectedContext context) {
        return this.insertEnvVars(s, values, context, 0);
    }

    public String insertEnvVars(String s, Hashtable values, ISelectedContext context, int depth) {
        if (depth > 90) {
            return s;
        }
        String res = "";
        int i = s.indexOf("($");
        if (i >= 0) {
            res = s.substring(0, i);
            int i1 = s.indexOf(")", i + 2);
            if (i1 < 0) {
                return s;
            }
            String var = s.substring(i + 2, i1);
            String val = this.ressolveVariable(var, values);
            if (val != null) {
                res = res + val;
            }
            res = res + s.substring(i1 + 1);
            return this.insertEnvVars(res, values, context, ++depth);
        }
        return s;
    }

    class MyCopier
    extends RecursiveFileCopier {
        String instantiationName;
        String toReplaceName;

        public MyCopier(String instantiationName, String toReplaceName) {
            super(null, null);
            this.instantiationName = instantiationName;
            this.toReplaceName = toReplaceName;
        }

        public void replace(File f, String[] keys, String[] values) {
            Hashtable ht = TemplateEngine.this.getDefaultTemplateValues("", f.getAbsolutePath());
            ht.put("objectname", this.instantiationName);
            String pack = EditApp.App.getPossiblePackageFor(new File(VFile.ExtractDir(f.getAbsolutePath())), f);
            if (pack != null && pack.trim().length() > 0 && !pack.equals("source") && !pack.equals("src")) {
                ht.put("packageStatement", "package " + pack + ";");
                ht.put("package", pack);
                ht.put("packageurl", pack.replace('.', '/') + "/");
                String packagebase = VFile.ExtractDir(f.getAbsolutePath());
                int maxN = 0;
                int tmp = -1;
                while ((tmp = pack.indexOf(46, tmp + 1)) >= 0) {
                    ++maxN;
                }
                int n = 0;
                while (n < maxN + 1) {
                    packagebase = VFile.RemoveLast(packagebase);
                    ++n;
                }
                ht.put("packagebase", packagebase);
                ht.put("fullqualifiedobjectname", pack + "." + this.instantiationName);
            } else {
                ht.put("packageStatement", "");
                ht.put("package", "");
                ht.put("packageurl", "");
                ht.put("packagebase", VFile.ExtractDir(f.getAbsolutePath()));
                ht.put("fullqualifiedobjectname", this.instantiationName);
            }
            TemplateEngine.this.instantiateTemplateFile(f, ht);
            TemplateEngine.this.newFiles.addElement(f);
        }

        public boolean shouldCopy(String name) {
            name = name.toLowerCase();
            Tracer.This.println("SHOULD COPY:----------------------------" + name);
            return !name.equals("descr.txt") && !name.equals("big.gif") && !name.equals("small.gif") && !name.equals("delme");
        }

        public boolean shouldReplace(String name) {
            return name.endsWith(".java") || name.endsWith(".ajpr") || name.endsWith(".prp") || name.endsWith(".gml") || name.endsWith("conf.txt") || name.endsWith(".xml") || name.endsWith(".html") || name.endsWith(".htm");
        }

        public String mapFileName(String name) {
            name = NCStringUtilities.Replace(name, this.toReplaceName, this.instantiationName);
            return name;
        }
    }
}

